#include <STDLIB.H>
#include <STRING.H>
#include <SPAD/LIBC.H>
#include <OPENSSL/BN.H>

#include "SSHD.H"

int bn_2_string(BIGNUM *bn, __u8 **buf, __u32 *bytes)
{
	if (__unlikely(bn->neg)) return -1;
	*bytes = BN_num_bytes(bn);
	if (__unlikely(!(*buf = malloc(*bytes + 1)))) return -1;
	if (__unlikely(BN_bn2bin(bn, *buf) != *bytes))
		KERNEL$SUICIDE("Wrong number of bytes put in bignum");
	if (__likely(*bytes) && (*buf)[0] >= 0x80) {
		memmove(*buf + 1, *buf, *bytes);
		(*buf)[0] = 0;
		(*bytes)++;
	}
	return 0;
}
