#include <STRING.H>

#include "SSHD.H"

static int null_copy(struct compress *ct, __u8 **cmp, unsigned *cmpl, __u8 **res, unsigned *resl)
{
	unsigned len = __unlikely(*cmpl > *resl) ? *resl : *cmpl;
	memcpy(*res, *cmp, len);
	*cmp += len;
	*cmpl -= len;
	*res += len;
	*resl -= len;
	return 0;
}

struct compress_type compress_none = {
	null_copy, null_copy, "none"
};

struct compress_type *compress_types[] = {
	&compress_none,
	NULL
};

int setup_in_compress(struct ssh_connection *c, struct compress_type *ct)
{
	c->in_compress.type = ct;
	return 0;
}

int setup_out_compress(struct ssh_connection *c, struct compress_type *ct)
{
	c->out_compress.type = ct;
	return 0;
}

