#include <STRING.H>
#include <OPENSSL/EVP.H>
#include <OPENSSL/HMAC.H>
#include <OPENSSL/SHA.H>
#include <OPENSSL/MD5.H>
#include <OPENSSL/RIPEMD.H>

#include "SSHD.H"

static void mac_null(struct mac *mac, __u32 seq, __u8 *data, unsigned len, __u8 *md)
{
}

static void mac_evp(struct mac *mac, __u32 seq, __u8 *data, unsigned len, __u8 *md)
{
	HMAC_CTX ctx;
	HMAC_Init(&ctx, mac->key, mac->type->keysize, mac->md);
	seq = __32CPU2BE(seq);
	HMAC_Update(&ctx, (void *)&seq, sizeof seq);
	HMAC_Update(&ctx, data, len);
	HMAC_Final(&ctx, md, NULL);
	HMAC_cleanup(&ctx);
}

struct mac_type mac_none = {
	0, 0, mac_null, NULL, "none"
};

static struct mac_type mac_sha1 = {
	SHA_DIGEST_LENGTH, SHA_DIGEST_LENGTH, mac_evp, EVP_sha1, "hmac-sha1",
};

static struct mac_type mac_sha1_96 = {
	12, SHA_DIGEST_LENGTH, mac_evp, EVP_sha1, "hmac-sha1-96",
};

static struct mac_type mac_md5 = {
	MD5_DIGEST_LENGTH, MD5_DIGEST_LENGTH, mac_evp, EVP_md5, "hmac-md5",
};

static struct mac_type mac_md5_96 = {
	12, MD5_DIGEST_LENGTH, mac_evp, EVP_md5, "hmac-md5-96",
};

static struct mac_type mac_ripemd160 = {
	RIPEMD160_DIGEST_LENGTH, RIPEMD160_DIGEST_LENGTH, mac_evp, EVP_ripemd160, "hmac-ripemd160",
};

struct mac_type *mac_types[] = {
	&mac_sha1,
	&mac_ripemd160,
	&mac_sha1_96,
	&mac_md5,
	&mac_md5_96,
	&mac_none,
	NULL
};

int setup_in_mac(struct ssh_connection *c, struct mac_type *mt, __u8 *mac_key)
{
	if (__unlikely(!(c->in_mac.key = reallocf(c->in_mac.key, mt->keysize))))
		return -1;
	memcpy(c->in_mac.key, mac_key, mt->keysize);
	if (mt->mdfunc) c->in_mac.md = mt->mdfunc();
	c->in_mac.type = mt;
	return 0;
}

int setup_out_mac(struct ssh_connection *c, struct mac_type *mt, __u8 *mac_key)
{
	if (__unlikely(!(c->out_mac.key = reallocf(c->out_mac.key, mt->keysize))))
		return -1;
	memcpy(c->out_mac.key, mac_key, mt->keysize);
	if (mt->mdfunc) c->out_mac.md = mt->mdfunc();
	c->out_mac.type = mt;
	return 0;
}

