#include <STDLIB.H>
#include <UNISTD.H>
#include <STRING.H>
#include <SYS/TYPES.H>
#include <SYS/STAT.H>
#include <FCNTL.H>
#include <SPAD/LIBC.H>
#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <SYS/SOCKET.H>
#include <NETINET/IN.H>
#include <NETDB.H>
#include <SYS/UTSNAME.H>
#include <SPAD/IOCTL.H>
#include <ARPA/INET.H>
#include <ARPA/TELNET.H>

/*
/user/login/process/
PASSWORD password
SSH-AUTH blablablabla
DONE
TERMINAL tty
XDISPLOC x
DONE
*/
/*
OK
SSHAUTH blebleble
FAILED
*/

#define OUT_BUFFER_SIZE		1460
#define IN_BUFFER_SIZE		256
#define INPUT_SIZE		256

#define MAX_PASSWORD_TRIES	3

#define MAX_TTY_TYPE		32
#define MAX_XDISP_LOC		256

static int port = -1;
static int ls;
static int ttyh;

static char *init_string = NULL;
static int init_string_len;
static char *default_user = "/USER/";

static __const__ char init_opts[] = { IAC, WILL, TELOPT_ECHO, IAC, DO, TELOPT_SGA, IAC, WILL, TELOPT_SGA, IAC, DO, TELOPT_TTYPE, IAC, DO, TELOPT_NAWS, IAC, DO, TELOPT_XDISPLOC };

static __const__ char issue1[] = "\033[2J\033[1;1H\r\n";
static __const__ char issue2[] = "\r\n\r\nLOGIN: ";

struct telnet_conn {
	int s;
	int state;
	int laststate;
	struct sockaddr_in na;
	unsigned char tty_type[MAX_TTY_TYPE + 1];
	unsigned char xdisp_loc[MAX_XDISP_LOC + 1];
	int width, height;
	int old_width, old_height;
	unsigned char *out_buffer;
	unsigned char *tmp_buffer;
	unsigned char in_buffer[IN_BUFFER_SIZE];
	int in_buffer_ptr;
	unsigned char tty_name_[TTYSTR_LEN];	/* these two must be after */
	unsigned char key_buffer[IN_BUFFER_SIZE];
	int key_buffer_ptr;
	unsigned char reply_buffer[IN_BUFFER_SIZE * 3];
	int reply_buffer_ptr;
	unsigned char input_buffer[INPUT_SIZE];
	int input_buffer_ptr;
	unsigned char user[INPUT_SIZE + 2];
	unsigned char password[INPUT_SIZE + 1];
	int auth_ptr;
	int outstanding;
	SIORQ out_sock;
	SIORQ in_sock;
	IOCTLRQ out_tty;
	IOCTLRQ in_tty;
	CLOSERQ closerq;
	int auth_tries;
};

#define tty_name(n)	((n)->key_buffer - TTYSTR_LEN)

#define ST_LOGIN	1
#define ST_PASSWORD	2
#define ST_PDONE	3
#define ST_CONNECTED	4
#define ST_ABORTING	-1

extern AST_STUB ABORT_CLOSED;
extern AST_STUB ABORT_TTY;

extern AST_STUB TTY_ALLOCATED;
extern AST_STUB TTY_SENT_AUTH;
extern AST_STUB TTY_RCV_AUTH;
extern AST_STUB TTY_CLOSED;

extern AST_STUB GOT_INPUT;
extern AST_STUB WROTE_INPUT;

static void read_init(void)
{
	int h;
	struct utsname u;
	free(init_string);
	h = open("ISSUE:", O_RDONLY);
	if (h != -1) {
		struct stat st;
		if (fstat(h, &st) && !S_ISREG(st.st_mode)) {
			close(h);
			goto e;
		}
		if (!(init_string = malloc(init_string_len = sizeof(init_opts) + st.st_size)))
			_exit_msg(-ENOMEM, "CAN'T ALLOC");
		memcpy(init_string, init_opts, sizeof(init_opts));
		if (read(h, init_string + sizeof(init_opts), st.st_size) != st.st_size) {
			close(h);
			__slow_free(init_string);
			init_string = NULL;
			goto e;
		}
		close(h);
	} else e: {
		if (!(init_string = malloc(sizeof(init_opts) + sizeof(issue1) + SYS_NMLN * 2 + 1 + sizeof(issue2) + 1)))
			_exit_msg(-ENOMEM, "CAN'T ALLOC");
		memcpy(init_string, init_opts, sizeof(init_opts));
		if (!uname(&u)) {
			strcpy(init_string + sizeof(init_opts), issue1);
			strcat(init_string + sizeof(init_opts), u.sysname);
			strcat(init_string + sizeof(init_opts), " ");
			strcat(init_string + sizeof(init_opts), u.release);
			strcat(init_string + sizeof(init_opts), issue2);
		} else {
			strcpy(init_string + sizeof(init_opts), issue1);
			strcat(init_string + sizeof(init_opts), "SPAD");
			strcat(init_string + sizeof(init_opts), issue2);
		}
		init_string_len = strlen(init_string + sizeof(init_opts)) + sizeof(init_opts);
	}
}

static void abort_connection(struct telnet_conn *n)
{
	n->reply_buffer_ptr = 0;
	n->state = ST_ABORTING;
	if (n->outstanding) {
		KERNEL$CIO((IORQ *)&n->out_sock);
		KERNEL$CIO((IORQ *)&n->in_sock);
		KERNEL$CIO((IORQ *)&n->out_tty);
		KERNEL$CIO((IORQ *)&n->in_tty);
		return;
	}
	free(n->tmp_buffer);
	free(n->out_buffer);
	n->closerq.fn = ABORT_CLOSED;
	n->closerq.h = n->s;
	CALL_IORQ(&n->closerq, KERNEL$CLOSE);
}

DECL_AST(ABORT_CLOSED, SPL_BOTTOM, CLOSERQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, closerq);
	if (*tty_name(n)) {
		n->out_tty.fn = ABORT_TTY;
		n->out_tty.ioctl = IOCTL_TTYSRVR_CLOSETTY;
		n->out_tty.v.ptr = (unsigned long)tty_name(n);
		n->out_tty.v.len = TTYSTR_LEN;
		RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
	} else {
		free(n);
		RETURN;
	}
}

DECL_AST(ABORT_TTY, SPL_BOTTOM, IOCTLRQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_tty);
	free(n);
	RETURN;
}

DECL_AST(TELNET_WROTE_INIT, SPL_BOTTOM, SIORQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_sock);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status <= -!RQ->v.len)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->v.len != 0)) {
		RQ->progress = 0;
		n->outstanding++;
		RETURN_IORQ(RQ, KERNEL$WRITE);
	}
	if (__unlikely(n->state != n->laststate)) {
		if (!*tty_name(n)) {
			_snprintf(tty_name(n), TTYSTR_LEN, ".%s.%d", inet_ntoa(n->na.sin_addr), ntohs(n->na.sin_port));
		}
		switch (n->laststate = n->state) {
			case ST_PASSWORD:
			case ST_PDONE:
				memcpy(n->out_buffer, tty_name(n), TTYSTR_LEN);
				_snprintf(n->out_buffer + TTYSTR_LEN, OUT_BUFFER_SIZE, "%s%s%s%s%s\nDONE%s%s%s%s\nDONE\n", n->user[0] != '/' ? (char *)default_user : "", n->user[0] != '/' && (!*default_user || default_user[strlen(default_user) - 1] != '/') ? "/" : "", n->user, n->state == ST_PDONE ? "\nPASSWORD " : "", n->state == ST_PDONE ? (char *)n->password : "", *n->tty_type ? "\nTERMINAL " : "", *n->tty_type ? (char *)n->tty_type : "", *n->xdisp_loc ? "\nXDISPLOC " : "", *n->xdisp_loc ? (char *)n->xdisp_loc : "");
				if (__unlikely(strlen(n->out_buffer + TTYSTR_LEN) == OUT_BUFFER_SIZE - 1)) {
					abort_connection(n);
					RETURN;
				}
				n->out_tty.fn = TTY_ALLOCATED;
				n->out_tty.ioctl = IOCTL_TTYSRVR_MAKETTY;
				n->out_tty.v.ptr = (unsigned long)n->out_buffer;
				n->out_tty.v.len = TTYSTR_LEN + strlen(n->out_buffer + TTYSTR_LEN);
				n->outstanding++;
				RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
		}
	}
	n->in_sock.v.ptr = (unsigned long)n->in_buffer + n->in_buffer_ptr;
	n->in_sock.v.len = IN_BUFFER_SIZE - n->in_buffer_ptr;
	n->in_sock.progress = 0;
	n->outstanding++;
	RETURN_IORQ(&n->in_sock, KERNEL$READ);
}

DECL_AST(TTY_ALLOCATED, SPL_BOTTOM, IOCTLRQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_tty);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->ioctl == IOCTL_TTYSRVR_WINSIZE)) goto ok;
	if (__unlikely(RQ->status < 0)) {
		abort_connection(n);
		RETURN;
	}
	if (__likely((n->width | n->height) != 0)) {
		RQ->ioctl = IOCTL_TTYSRVR_WINSIZE;
		RQ->param = ((n->old_width = n->width) << 16) + (n->old_height = n->height);
		RQ->v.len = TTYSTR_LEN;
		n->outstanding++;
		RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
	}
	ok:
	n->auth_ptr = 0;
	n->out_tty.fn = TTY_RCV_AUTH;
	n->out_tty.ioctl = IOCTL_TTYSRVR_GETAUTH;
	n->out_tty.v.ptr = (unsigned long)n->out_buffer;
	n->out_tty.v.len = TTYSTR_LEN;
	n->out_tty.param = 0;
	n->outstanding++;
	RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
	RETURN;
}

DECL_AST(TTY_RCV_AUTH, SPL_BOTTOM, IOCTLRQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_tty);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status < 0)) {
		abort_connection(n);
		RETURN;
	}
	if (__likely(!RQ->status)) {
		n->state = ST_CONNECTED;
		n->in_sock.v.ptr = (unsigned long)n->in_buffer + n->in_buffer_ptr;
		n->in_sock.v.len = IN_BUFFER_SIZE - n->in_buffer_ptr;
		n->in_sock.progress = 0;
		n->outstanding++;
		CALL_IORQ(&n->in_sock, KERNEL$READ);
		n->in_tty.fn = GOT_INPUT;
		n->in_tty.ioctl = IOCTL_TTYSRVR_RCVCHR;
		n->in_tty.v.ptr = (unsigned long)n->out_buffer;
		n->in_tty.v.len = __alloc_size(n->out_buffer);
		n->outstanding++;
		RETURN_IORQ(&n->in_tty, KERNEL$IOCTL);
	}
	if (__unlikely(++n->auth_tries > MAX_PASSWORD_TRIES)) {
		abort_connection(n);
		RETURN;
	}
	n->out_tty.fn = TTY_CLOSED;
	n->out_tty.ioctl = IOCTL_TTYSRVR_CLOSETTY;
	n->out_tty.v.len = TTYSTR_LEN;
	n->outstanding++;
	RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
}

DECL_AST(TTY_CLOSED, SPL_BOTTOM, IOCTLRQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_tty);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status < 0)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(n->state == ST_PDONE)) {
		n->state = n->laststate = ST_PASSWORD;
		n->input_buffer_ptr = 0;
	}
	strcpy(n->reply_buffer, "PASSWORD: ");
	n->out_sock.fn = TELNET_WROTE_INIT;
	n->out_sock.v.ptr = (unsigned long)n->reply_buffer;
	n->out_sock.v.len = strlen(n->reply_buffer);
	n->out_sock.progress = 0;
	n->outstanding++;
	RETURN_IORQ(&n->out_sock, KERNEL$WRITE);
}

DECL_AST(GOT_INPUT, SPL_BOTTOM, IOCTLRQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, in_tty);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status <= 0)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(memchr(n->out_buffer + TTYSTR_LEN, IAC, RQ->status) != NULL)) {
		int i, j;
		if (__unlikely(!(n->tmp_buffer = malloc(RQ->status << 1)))) {
			abort_connection(n);
			RETURN;
		}
		for (i = 0, j = 0; i < RQ->status; i++, j++) {
			unsigned char c = n->tmp_buffer[j] = n->out_buffer[TTYSTR_LEN + i];
			if (__unlikely(c == IAC)) n->tmp_buffer[++j] = IAC;
		}
		n->out_sock.v.ptr = (unsigned long)n->tmp_buffer;
		n->out_sock.v.len = j;
	} else {
		n->out_sock.v.ptr = (unsigned long)n->out_buffer + TTYSTR_LEN;
		n->out_sock.v.len = RQ->status;
	}
	n->out_sock.fn = WROTE_INPUT;
	n->out_sock.progress = 0;
	n->outstanding++;
	RETURN_IORQ(&n->out_sock, KERNEL$WRITE);
}

DECL_AST(WROTE_INPUT, SPL_BOTTOM, SIORQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_sock);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status <= -!RQ->v.len)) {
		__slow_free(n->tmp_buffer), n->tmp_buffer = NULL;
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->v.len != 0)) {
		RQ->progress = 0;
		n->outstanding++;
		RETURN_IORQ(RQ, KERNEL$WRITE);
	}
	free(n->tmp_buffer), n->tmp_buffer = NULL;
	n->outstanding++;
	RETURN_IORQ(&n->in_tty, KERNEL$IOCTL);
}

DECL_AST(TTY_WROTE, SPL_BOTTOM, IOCTLRQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, out_tty);
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->ioctl == IOCTL_TTYSRVR_WINSIZE)) goto ok;
	if (__unlikely(RQ->status <= 0)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status < n->out_tty.v.len - TTYSTR_LEN)) {
		memmove(n->out_buffer + TTYSTR_LEN, n->out_buffer + TTYSTR_LEN + RQ->status, n->out_tty.v.len - RQ->status - TTYSTR_LEN);
		n->out_tty.v.len -= RQ->status;
		n->outstanding++;
		RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
	}
	if (__unlikely(n->old_width != n->width) || __unlikely(n->old_height != n->height)) {
		RQ->ioctl = IOCTL_TTYSRVR_WINSIZE;
		RQ->param = ((n->old_width = n->width) << 16) + (n->old_height = n->height);
		RQ->v.len = TTYSTR_LEN;
		n->outstanding++;
		RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
	}
	ok:
	n->in_sock.v.ptr = (unsigned long)n->in_buffer + n->in_buffer_ptr;
	n->in_sock.v.len = IN_BUFFER_SIZE - n->in_buffer_ptr;
	n->in_sock.progress = 0;
	n->outstanding++;
	RETURN_IORQ(&n->in_sock, KERNEL$READ);
}


DECL_AST(TELNET_READ, SPL_BOTTOM, SIORQ)
{
	struct telnet_conn *n = GET_STRUCT(RQ, struct telnet_conn, in_sock);
	int i, j, k;
	unsigned char sb_buffer[IN_BUFFER_SIZE];
	n->outstanding--;
	if (__unlikely(n->state == ST_ABORTING)) {
		abort_connection(n);
		RETURN;
	}
	if (__unlikely(RQ->status <= 0)) {
		abort_connection(n);
		RETURN;
	}
	n->in_buffer_ptr += RQ->status;
	n->key_buffer_ptr = 0;
	n->reply_buffer_ptr = 0;
	for (i = 0; i < n->in_buffer_ptr; i++) {
		unsigned char c;
		if (__likely((c = n->in_buffer[i]) != IAC)) {
			if (__unlikely(!c) || __unlikely(c == 10)) continue;
			n->key_buffer[n->key_buffer_ptr++] = c;
			continue;
		}
		if (__unlikely(i + 1 >= n->in_buffer_ptr)) {
			incomp:
			if (__unlikely(!i)) {
				n->in_buffer_ptr = 0;
			} else {
				memmove(n->in_buffer, n->in_buffer + i, n->in_buffer_ptr -= i);
			}
			goto brk;
		}
		switch (n->in_buffer[i + 1]) {
			case IAC:
				n->key_buffer[n->key_buffer_ptr++] = IAC;
				i++;
				continue;
			case DONT:
			case DO:
			case WONT:
			case WILL:
				if (__unlikely(i + 2 >= n->in_buffer_ptr)) goto incomp;
				if ((n->in_buffer[i + 1] == DO && n->in_buffer[i + 2] == TELOPT_ECHO) ||
				    (n->in_buffer[i + 1] == WILL && n->in_buffer[i + 2] == TELOPT_SGA) ||
				    (n->in_buffer[i + 1] == DO && n->in_buffer[i + 2] == TELOPT_SGA) ||
				    (n->in_buffer[i + 1] == WILL && n->in_buffer[i + 2] == TELOPT_NAWS)) {
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == WILL && n->in_buffer[i + 2] == TELOPT_TTYPE) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = SB;
					n->reply_buffer[n->reply_buffer_ptr++] = TELOPT_TTYPE;
					n->reply_buffer[n->reply_buffer_ptr++] = TELQUAL_SEND;
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = SE;
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == WILL && n->in_buffer[i + 2] == TELOPT_XDISPLOC) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = SB;
					n->reply_buffer[n->reply_buffer_ptr++] = TELOPT_XDISPLOC;
					n->reply_buffer[n->reply_buffer_ptr++] = TELQUAL_SEND;
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = SE;
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == DO && n->in_buffer[i + 2] == TELOPT_BINARY) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = WILL;
					n->reply_buffer[n->reply_buffer_ptr++] = TELOPT_BINARY;
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == WILL && n->in_buffer[i + 2] == TELOPT_BINARY) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = DO;
					n->reply_buffer[n->reply_buffer_ptr++] = TELOPT_BINARY;
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == WILL && n->in_buffer[i + 2] == TELOPT_TM) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = DO;
					n->reply_buffer[n->reply_buffer_ptr++] = TELOPT_TM;
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == DO || n->in_buffer[i + 1] == DONT) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = WONT;
					n->reply_buffer[n->reply_buffer_ptr++] = n->in_buffer[i + 2];
					i += 2;
					continue;
				}
				if (n->in_buffer[i + 1] == WILL || n->in_buffer[i + 1] == WONT) {
					n->reply_buffer[n->reply_buffer_ptr++] = IAC;
					n->reply_buffer[n->reply_buffer_ptr++] = DONT;
					n->reply_buffer[n->reply_buffer_ptr++] = n->in_buffer[i + 2];
					i += 2;
					continue;
				}
				i++;
				continue;
			case SB:
				k = 0;
				for (j = i + 2; j < n->in_buffer_ptr - 1; j++) {
					if (__likely(n->in_buffer[j] != IAC)) {
						sb_buffer[k++] = n->in_buffer[j];
					} else {
						if (__unlikely(n->in_buffer[j + 1] == IAC)) {
							sb_buffer[k++] = IAC;
							j++;
						} else {
							i = j - 1;
							goto sb_brk;
						}
					}
				}
				goto incomp;
				sb_brk:
				if (__unlikely(!k)) break;
				switch (sb_buffer[0]) {
					case TELOPT_TTYPE:
						if (__unlikely(k <= 2)) break;
						if (__unlikely(sb_buffer[1] != TELQUAL_IS)) break;
						if (__unlikely(k - 2 > MAX_TTY_TYPE)) k = MAX_TTY_TYPE + 2;
						memcpy(n->tty_type, sb_buffer + 2, k - 2);
						n->tty_type[k - 2] = 0;
						{
							int i;
							for (i = 0; n->tty_type[i]; i++) if (n->tty_type[i] >= 'A' && n->tty_type[i] <= 'Z') n->tty_type[i] += 'a' - 'A';
						}
						break;
					case TELOPT_XDISPLOC:
						if (__unlikely(k <= 2)) break;
						if (__unlikely(sb_buffer[1] != TELQUAL_IS)) break;
						if (__unlikely(k - 2 > MAX_XDISP_LOC)) k = MAX_XDISP_LOC + 2;
						memcpy(n->xdisp_loc, sb_buffer + 2, k - 2);
						n->xdisp_loc[k - 2] = 0;
						break;
					case TELOPT_NAWS:
						if (__unlikely(k != 5)) break;
						n->width = (sb_buffer[1] << 8) + sb_buffer[2];
						n->height = (sb_buffer[3] << 8) + sb_buffer[4];
						break;
				}
				continue;
			case GA:
				i++;
				continue;
			case EL:
				n->key_buffer[n->key_buffer_ptr++] = 21;
				i++;
				continue;
			case EC:
				n->key_buffer[n->key_buffer_ptr++] = 8;
				i++;
				continue;
			case AYT:
				n->reply_buffer[n->reply_buffer_ptr++] = 'O';
				n->reply_buffer[n->reply_buffer_ptr++] = 'K';
				n->reply_buffer[n->reply_buffer_ptr++] = '.';
				i++;
				continue;
			case AO:
				i++;
				continue;
			case IP:
				n->key_buffer[n->key_buffer_ptr++] = 26;
				i++;
				continue;
			case BREAK:
				n->key_buffer[n->key_buffer_ptr++] = 3;
				i++;
				continue;
			case DM:
				i++;
				continue;
			case NOP:
				i++;
				continue;
			case SE:
				i++;
				continue;
			case EOR:
				i++;
				continue;
			case ABORT:
				n->key_buffer[n->key_buffer_ptr++] = 28;
				i++;
				continue;
			case SUSP:
				n->key_buffer[n->key_buffer_ptr++] = 26;
				i++;
				continue;
			case xEOF:
				n->key_buffer[n->key_buffer_ptr++] = 4;
				i++;
				continue;
			default:
				i++;
				continue;
		}
	}
	n->in_buffer_ptr = 0;
	brk:
	if (__likely(n->state == ST_CONNECTED)) {
		/*{
			int i;
			for (i = 0; i < n->key_buffer_ptr; i++)
				__debug_printf("(%d)", n->key_buffer[i]);
		}*/
		n->out_tty.fn = TTY_WROTE;
		n->out_tty.ioctl = IOCTL_TTYSRVR_SENDCHR;
		n->out_tty.param = 0;
		n->out_tty.v.ptr = (unsigned long)tty_name(n);
		n->out_tty.v.len = TTYSTR_LEN + n->key_buffer_ptr;
		n->outstanding++;
		RETURN_IORQ(&n->out_tty, KERNEL$IOCTL);
	} else {
		for (i = 0; i < n->key_buffer_ptr; i++) {
			unsigned char c = n->key_buffer[i];
			if (__unlikely(n->state == ST_PDONE)) {
				if (__likely(n->input_buffer_ptr < INPUT_SIZE))
					n->input_buffer[n->input_buffer_ptr++] = c;
				continue;
			}
			switch (c) {
				case 0:
				case 10:
					break;
				case 8:
				case 127:
					if (__likely(n->input_buffer_ptr)) {
						n->input_buffer_ptr--;
						if (n->state == ST_LOGIN) {
							n->reply_buffer[n->reply_buffer_ptr++] = 8;
							n->reply_buffer[n->reply_buffer_ptr++] = ' ';
							n->reply_buffer[n->reply_buffer_ptr++] = 8;
						}
					}
					break;
				case 4:
				case 13:
					n->reply_buffer[n->reply_buffer_ptr++] = '\r';
					n->reply_buffer[n->reply_buffer_ptr++] = '\n';
					if (n->state == ST_LOGIN) {
						memcpy(n->user, n->input_buffer, n->input_buffer_ptr);
						if (n->input_buffer_ptr && n->user[n->input_buffer_ptr - 1] != '/') n->user[n->input_buffer_ptr++] = '/';
						n->user[n->input_buffer_ptr] = 0;
						n->input_buffer_ptr = 0;
						n->state = ST_PASSWORD;
					} else {
						memcpy(n->password, n->input_buffer, n->input_buffer_ptr);
						n->password[n->input_buffer_ptr] = 0;
						n->input_buffer_ptr = 0;
						n->state = ST_PDONE;
					}
					break;
				case 21:
					if (__likely(n->input_buffer_ptr)) {
						n->input_buffer_ptr = 0;
						n->reply_buffer[n->reply_buffer_ptr++] = '\r';
						n->reply_buffer[n->reply_buffer_ptr++] = '\n';
					}
					break;
				default:
					if (__likely(n->input_buffer_ptr < INPUT_SIZE)) {
						if (n->state == ST_LOGIN && c >= 'a' && c <= 'z') c -= 0x20;
						n->input_buffer[n->input_buffer_ptr++] = c;
						if (n->state == ST_LOGIN) {
							if (__likely(c >= ' ')) {
								if (__unlikely(c == IAC)) n->reply_buffer[n->reply_buffer_ptr++] = c;
								n->reply_buffer[n->reply_buffer_ptr++] = c;
							} else {
								n->reply_buffer[n->reply_buffer_ptr++] = '^';
								n->reply_buffer[n->reply_buffer_ptr++] = c + 'A' - 1;
							}
						}
					}
			}
		}
		n->out_sock.fn = TELNET_WROTE_INIT;
		n->out_sock.v.ptr = (unsigned long)n->reply_buffer;
		n->out_sock.v.len = n->reply_buffer_ptr;
		n->out_sock.progress = 0;
		n->outstanding++;
		RETURN_IORQ(&n->out_sock, KERNEL$WRITE);
	}
	RETURN;
}

int main(int argc, char *argv[])
{
	IOCTLRQ io;
	char **arg;
	int state;
	struct servent *serv;
	struct sockaddr_in la;
	struct __param_table params[] = {
		"PORT", __PARAM_INT, 0, IPPORT_MAX, NULL,
		"USER", __PARAM_STRING, 1, OUT_BUFFER_SIZE, NULL,
		NULL, 0, 0, 0, NULL,
	};
	params[0].__p = &port;
	params[1].__p = &default_user;
	arg = argv;
	state = 0;
	if (__parse_params(&arg, &state, params, NULL, NULL, NULL)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SYNTAX ERROR");
		return -EBADSYN;
	}
	if (port == -1) {
		if (__unlikely(!(serv = getservbyname("telnet", "tcp")))) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "COULD NOT GET TELNET SERVICE FROM ETC.:/SERVICES");
			return -ENETDOWN;
		}
		port = ntohs(serv->s_port);
	}
	if ((ttyh = open("SYS$TTYSRVR:", O_RDWR)) == -1) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "COULD NOT OPEN SYS$TTYSRVR: %s", strerror(errno));
		return -errno;
	}
	read_init();
	if (__unlikely((ls = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "COULD NOT CREATE SOCKET: %s", strerror(errno));
		return -errno;
	}
	la.sin_family = AF_INET;
	la.sin_port = htons(port);
	la.sin_addr.s_addr = htonl(INADDR_ANY);
	if (__unlikely(bind(ls, (struct sockaddr *)&la, sizeof la))) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "COULD NOT BIND SOCKET TO PORT %d: %s", port, strerror(errno));
		return -errno;
	}
	if (__unlikely(listen(ls, 100))) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "COULD NOT LISTEN ON SOCKET: %s", strerror(errno));
		return -errno;
	}
	io.h = ttyh;
	io.ioctl = IOCTL_TTYSRVR_CLEAR;
	io.param = 0;
	io.v.ptr = 0;
	io.v.len = 0;
	io.v.vspace = &KERNEL$VIRTUAL;
	SYNC_IO(&io, KERNEL$IOCTL);
	if (__unlikely(io.status < 0)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "CAN'T INIT SYS$TTYSRVR: %s", strerror(-io.status));
		return -io.status;
	}
	while (1) {
		struct sockaddr_in na;
		int nal = sizeof(na);
		int ns;
		struct telnet_conn *n;
		ns = accept(ls, (struct sockaddr *)&na, &nal);
		if (__unlikely(ns == -1)) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ACCEPT ERROR: %s", strerror(errno));
			return -errno;
		}
		if (__unlikely(nal != sizeof(struct sockaddr_in))) {
			close(ns);
			continue;
		}
		if (__unlikely(!(n = calloc(1, sizeof(struct telnet_conn))))) {
			close(ns);
			continue;
		}
		if (__unlikely(!(n->out_buffer = malloc(TTYSTR_LEN + OUT_BUFFER_SIZE)))) {
			__slow_free(n);
			close(ns);
			continue;
		}
		n->s = ns;
		memcpy(&n->na, &na, sizeof(struct sockaddr_in));
		n->state = ST_LOGIN;
		n->in_tty.h = ttyh;
		n->in_tty.v.vspace = &KERNEL$VIRTUAL;
		n->out_tty.h = ttyh;
		n->out_tty.v.vspace = &KERNEL$VIRTUAL;
		n->in_sock.fn = TELNET_READ;
		n->in_sock.h = n->s;
		n->in_sock.v.vspace = &KERNEL$VIRTUAL;
		n->out_sock.fn = TELNET_WROTE_INIT;
		n->out_sock.h = n->s;
		n->out_sock.v.ptr = (unsigned long)init_string;
		n->out_sock.v.len = init_string_len;
		n->out_sock.v.vspace = &KERNEL$VIRTUAL;
		n->out_sock.progress = 0;
		n->outstanding++;
		CALL_IORQ(&n->out_sock, KERNEL$WRITE);
	}
}

