#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <ARCH/IO.H>
#include <SPAD/VM.H>
#include <STRING.H>

static __const__ struct __param_table general_params[] = {
	NULL, 0, 0, 0, NULL
};

static unsigned long io;
static __u64 mmio;
static unsigned v;

static __const__ struct __param_table io_in_params[] = {
	"", __PARAM_UNSIGNED_LONG, 0, IO_SPACE_LIMIT + 1, &io,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table io_outb_params[] = {
	"", __PARAM_UNSIGNED_LONG, 0, IO_SPACE_LIMIT + 1, &io,
	"", __PARAM_UNSIGNED_INT, 0, 0x100, &v,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table io_outw_params[] = {
	"", __PARAM_UNSIGNED_LONG, 0, IO_SPACE_LIMIT + 1, &io,
	"", __PARAM_UNSIGNED_INT, 0, 0x10000, &v,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table io_outl_params[] = {
	"", __PARAM_UNSIGNED_LONG, 0, IO_SPACE_LIMIT + 1, &io,
	"", __PARAM_UNSIGNED_INT, 0, 1 << 31 << 1, &v,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table mmio_in_params[] = {
	"", __PARAM_UNSIGNED_INT64, 0, 0, &mmio,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table mmio_outb_params[] = {
	"", __PARAM_UNSIGNED_INT64, 0, 0, &mmio,
	"", __PARAM_UNSIGNED_INT, 0, 0x100, &v,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table mmio_outw_params[] = {
	"", __PARAM_UNSIGNED_INT64, 0, 0, &mmio,
	"", __PARAM_UNSIGNED_INT, 0, 0x10000, &v,
	NULL, 0, 0, 0, NULL
};

static __const__ struct __param_table mmio_outl_params[] = {
	"", __PARAM_UNSIGNED_INT64, 0, 0, &mmio,
	"", __PARAM_UNSIGNED_INT, 0, 1 << 31 << 1, &v,
	NULL, 0, 0, 0, NULL
};

int main(int argc, char *argv[])
{
	int state = 0;
	char **arg = argv;
	char *opt, *optend, *val;
	void *a;
	if (__unlikely(!KERNEL$KERNEL)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "IO: AVAILABLE ONLY IN KERNEL MODE");
		return -EUSER;
	}
	while (__parse_params(&arg, &state, general_params, &opt, &optend, &val)) {
		int state2 = 0;
		if (!__strcasexcmp("INB", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!*val) || __unlikely(__parse_extd_param(&val, &state2, io_in_params, NULL, NULL, NULL, NULL))) goto bads;
			_printf("INB(%lX) = %02X\n", io, io_inb(io));
		} else if (!__strcasexcmp("INW", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!*val) || __unlikely(__parse_extd_param(&val, &state2, io_in_params, NULL, NULL, NULL, NULL))) goto bads;
			_printf("INW(%lX) = %04X\n", io, io_inw(io));
		} else if (!__strcasexcmp("INL", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!*val) || __unlikely(__parse_extd_param(&val, &state2, io_in_params, NULL, NULL, NULL, NULL))) goto bads;
			_printf("INL(%lX) = %08X\n", io, io_inl(io));
		} else if (!__strcasexcmp("OUTB", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!strchr(val, ',')) || __unlikely(__parse_extd_param(&val, &state2, io_outb_params, NULL, NULL, NULL, NULL))) goto bads;
			_printf("OUTB(%lX, %02X)\n", io, v);
			io_outb(io, v);
		} else if (!__strcasexcmp("OUTW", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!strchr(val, ',')) || __unlikely(__parse_extd_param(&val, &state2, io_outw_params, NULL, NULL, NULL, NULL))) goto bads;
			_printf("OUTW(%lX, %02X)\n", io, v);
			io_outw(io, v);
		} else if (!__strcasexcmp("OUTL", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!strchr(val, ',')) || __unlikely(__parse_extd_param(&val, &state2, io_outl_params, NULL, NULL, NULL, NULL))) goto bads;
			_printf("OUTL(%lX, %02X)\n", io, v);
			io_outl(io, v);
		} else if (!__strcasexcmp("MMINB", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!*val) || __unlikely(__parse_extd_param(&val, &state2, mmio_in_params, NULL, NULL, NULL, NULL))) goto bads;
			if (__unlikely(mmio != (__p_addr)mmio)) goto bads;
			a = KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(mmio, 1, PAT_UC);
			if (__unlikely(__IS_ERR(a))) goto cantmap;
			_printf("MMINB(%"__64_format"X) = %02X\n", mmio, mmio_inb(a));
			KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(a, 1);
		} else if (!__strcasexcmp("MMINW", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!*val) || __unlikely(__parse_extd_param(&val, &state2, mmio_in_params, NULL, NULL, NULL, NULL))) goto bads;
			if (__unlikely(mmio != (__p_addr)mmio)) goto bads;
			a = KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(mmio, 2, PAT_UC);
			if (__unlikely(__IS_ERR(a))) goto cantmap;
			_printf("MMINW(%"__64_format"X) = %04X\n", mmio, mmio_inw(a));
			KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(a, 2);
		} else if (!__strcasexcmp("MMINL", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!*val) || __unlikely(__parse_extd_param(&val, &state2, mmio_in_params, NULL, NULL, NULL, NULL))) goto bads;
			if (__unlikely(mmio != (__p_addr)mmio)) goto bads;
			a = KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(mmio, 4, PAT_UC);
			if (__unlikely(__IS_ERR(a))) goto cantmap;
			_printf("MMINL(%"__64_format"X) = %08X\n", mmio, mmio_inl(a));
			KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(a, 4);
		} else if (!__strcasexcmp("MMOUTB", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!strchr(val, ',')) || __unlikely(__parse_extd_param(&val, &state2, mmio_outb_params, NULL, NULL, NULL, NULL))) goto bads;
			if (__unlikely(mmio != (__p_addr)mmio)) goto bads;
			a = KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(mmio, 1, PAT_UC);
			if (__unlikely(__IS_ERR(a))) goto cantmap;
			_printf("MMOUTB(%"__64_format"X, %02X)\n", mmio, v);
			mmio_outb(a, v);
			KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(a, 1);
		} else if (!__strcasexcmp("MMOUTW", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!strchr(val, ',')) || __unlikely(__parse_extd_param(&val, &state2, mmio_outw_params, NULL, NULL, NULL, NULL))) goto bads;
			if (__unlikely(mmio != (__p_addr)mmio)) goto bads;
			a = KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(mmio, 2, PAT_UC);
			if (__unlikely(__IS_ERR(a))) goto cantmap;
			_printf("MMOUTW(%"__64_format"X, %04X)\n", mmio, v);
			mmio_outw(a, v);
			KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(a, 2);
		} else if (!__strcasexcmp("MMOUTL", opt, optend)) {
			if (__unlikely(!val) || __unlikely(!strchr(val, ',')) || __unlikely(__parse_extd_param(&val, &state2, mmio_outl_params, NULL, NULL, NULL, NULL))) goto bads;
			if (__unlikely(mmio != (__p_addr)mmio)) goto bads;
			a = KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(mmio, 4, PAT_UC);
			if (__unlikely(__IS_ERR(a))) goto cantmap;
			_printf("MMOUTL(%"__64_format"X, %08X)\n", mmio, v);
			mmio_outl(a, v);
			KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(a, 4);
		} else {
			goto bads;
		}
	}
	return 0;

	bads:
	_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "IO: SYNTAX ERROR");
	return -EBADSYN;

	cantmap:
	_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "IO: CAN'T MAP ADDRESS %"__64_format"X: %s", mmio, strerror(-__PTR_ERR(a)));
	return __PTR_ERR(a);
}
