#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SPAD/PCI.H>
#include <SPAD/PCIID.H>
#include <STDLIB.H>

static int arg_cfgspace = 0;
static int arg_resources = 0;

static __const__ struct __param_table params[] = {
	"CFGSPACE", __PARAM_BOOL, ~0, 1, &arg_cfgspace,
	"RESOURCES", __PARAM_BOOL, ~0, 1, &arg_resources,
	NULL, 0, 0, 0, NULL,
};

static char claimed;

static char *test_claimed(__const__ void *table, pci_id_t id, unsigned long *driver_data)
{
	claimed = 0;
	return NULL;
}

static char *test(__const__ void *table, pci_id_t id, unsigned long *driver_data)
{
	unsigned i;
	static char str1[__MAX_STR_LEN];
	__u16 vendor_id, device_id, subsys_vendor_id, subsys_device_id;
	__u8 revision_id, class_prog, class_device_sub, class_device;
	char *vendor_str, *device_str, *subdevice_str;
	char *class_device_str, *class_device_sub_str, *class_prog_str;
	claimed = 1;
	PCI$FIND_DEVICE(NULL, id, ~(pci_id_t)0, 0, test_claimed, NULL, NULL, NULL, 0);
	_printf("%s%s\n", PCI$ID(str1, id), claimed ? " (CLAIMED)" : "");
	vendor_id = PCI$READ_CONFIG_WORD(id, PCI_VENDOR_ID);
	device_id = PCI$READ_CONFIG_WORD(id, PCI_DEVICE_ID);
	subsys_vendor_id = PCI$READ_CONFIG_WORD(id, PCI_SUBSYSTEM_VENDOR_ID);
	subsys_device_id = PCI$READ_CONFIG_WORD(id, PCI_SUBSYSTEM_ID);
	revision_id = PCI$READ_CONFIG_BYTE(id, PCI_REVISION_ID);
	class_prog = PCI$READ_CONFIG_BYTE(id, PCI_CLASS_PROG);
	class_device_sub = PCI$READ_CONFIG_BYTE(id, PCI_CLASS_DEVICE);
	class_device = PCI$READ_CONFIG_BYTE(id, PCI_CLASS_DEVICE + 1);
	PCIID$DESCRIBE_DEVICE(NULL, vendor_id, device_id, subsys_vendor_id, subsys_device_id, &vendor_str, &device_str, &subdevice_str);
	PCIID$DESCRIBE_CLASS(NULL, class_device, class_device_sub, class_prog, &class_device_str, &class_device_sub_str, &class_prog_str);
	_printf("%04X %04X %04X %04X %02X %02X %02X %02X%s%s%s%s%s%s%s%s%s%s%s%s\n", vendor_id, device_id, subsys_vendor_id, subsys_device_id, class_device, class_device_sub, class_prog, revision_id, class_device_str ? "\n\t" : "", class_device_str ? class_device_str : "", class_device_sub_str ? " - " : "", class_device_sub_str ? class_device_sub_str : "", class_prog_str ? " - " : "", class_prog_str ? class_prog_str : "", vendor_str ? "\n\t" : "", vendor_str ? vendor_str : "", device_str ? " - " : "", device_str ? device_str : "", subdevice_str ? " - " : "", subdevice_str ? subdevice_str : "");
	free(vendor_str);
	free(device_str);
	free(subdevice_str);
	free(class_device_str);
	free(class_device_sub_str);
	free(class_prog_str);
	if (arg_resources) {
		__u8 irq;
		for (i = 0; i < 6; i++) {
			__u32 val = PCI$READ_CONFIG_DWORD(id, PCI_BASE_ADDRESS_0 + i * 4);
			if (!val) continue;
			if (val & PCI_BASE_ADDRESS_SPACE_IO) {
				_printf("IO (%d): %08lX\n", i, val & PCI_BASE_ADDRESS_IO_MASK);
			} else {
				char *pf = val & PCI_BASE_ADDRESS_MEM_PREFETCH ? " PREFETCH " : " ";
				switch (val & PCI_BASE_ADDRESS_MEM_TYPE_MASK) {
				case PCI_BASE_ADDRESS_MEM_TYPE_32:
					_printf("MEM 32%s(%d): %08lX\n", pf, i, val & PCI_BASE_ADDRESS_MEM_MASK);
					break;
				case PCI_BASE_ADDRESS_MEM_TYPE_1M:
					_printf("MEM BELOW 1M%s(%d): %08lX\n", pf, i, val & PCI_BASE_ADDRESS_MEM_MASK);
					break;
				case PCI_BASE_ADDRESS_MEM_TYPE_64:
					if (i == 5) goto unknown;
					_printf("MEM 64%s(%d): %08X%08lX\n", pf, i, PCI$READ_CONFIG_DWORD(id, PCI_BASE_ADDRESS_0 + (i + 1) * 4), val & PCI_BASE_ADDRESS_MEM_MASK);
					break;
				case PCI_BASE_ADDRESS_MEM_TYPE_RES:
					unknown:
					_printf("UNKNOWN TYPE (%d): %08X\n", i, val);
					break;
				}
			}
		}
		irq = PCI$READ_CONFIG_BYTE(id, PCI_INTERRUPT_LINE);
		if (irq && irq != 0xff) _printf("IRQ: %02X\n", irq);
	}
	if (arg_cfgspace) {
		for (i = 0; i < 256; i += 4) {
			__u32 val = PCI$READ_CONFIG_DWORD(id, i);
			if (!(i & 31)) _printf("%02X:", i);
			if ((i & 31) == 16) _printf("  %02X:", i);
			_printf(" %08X", val);
			if ((i & 31) == 28) _printf("\n");
		}
	}
	return NULL;
}

int main(int argc, char *argv[])
{
	pci_id_t id = 0, id_mask = 0;
	int order = -1;
	char *opt, *optend, *str;
	char **arg = argv;
	int state = 0;
	while (__parse_params(&arg, &state, params, &opt, &optend, &str)) {
		if (__unlikely(PCI$PARSE_PARAMS(opt, optend, str, &id, &id_mask, &order))) {
			bads:
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "LSPCI: SYNTAX ERROR");
			return -EBADSYN;
		}
	}
	if (__unlikely(order != -1)) goto bads;
	PCI$FIND_DEVICE(NULL, id, id_mask, -1, test, NULL, NULL, NULL, 1);
	return 0;
}
