#ifndef __ARCH_AC_H
#define __ARCH_AC_H

#include <ARCH/SPL.H>

#include <ARCH/SETUP.H>
#include <ARCH/ACDEF.H>

#include <SYS/TYPES.H>

#include <SPAD/SPLDEF.H>

__BEGIN_DECLS

#define SPLX_BELOW __SPLX_BELOW
#define SPL_X __SPL_X
#define SPL_BUSY __SPL_BUSY
#define SPLX_BUSY __SPLX_BUSY
#define ASSERT_SPLX __ASSERT_SPLX
#define RAISE_SPL __RAISE_SPL
#define RAISE_SPLX __RAISE_SPLX
#define LOWER_SPL __LOWER_SPL
#define LOWER_SPLX __LOWER_SPLX
#define TEST_SPL __TEST_SPL
#define TEST_SPLX __TEST_SPLX
#define SPLX_MIN __SPLX_MIN
#define SPLX_MAX __SPLX_MAX

/*
 * AST
 */

typedef __u64 AST_STUB();

#define AST_HEAD		\
	AST_STUB *fn;		\
	unsigned long tmp1

typedef struct {
	AST_HEAD;
} AST;

#define __AST_PREENTRY(PL, VAR)	"				\n\
4:								\n\
	.IF	!("#\VAR")					\n\
	MOVL	$(-2) << ("#\PL"), %EDX				\n\
	.ELSE							\n\
	MOVL	%EAX, %ECX					\n\
	SUBL	$("#\PL") - 8 + 0x80000000, %EAX		\n\
	CDQ							\n\
	SHRL	$3, %EAX					\n\
	XCHGL	%EAX, %ECX					\n\
	SHLL	%CL, %EDX					\n\
	.ENDIF							\n\
	CMPL	%EDX, %ESI					\n\
	JBE	8f						\n\
	MOVL	%EDX, KERNEL$SPL				\n\
	STI							\n\
	JMP	7f						\n\
	.SPACE	32 - (. - 4b), 0x90				\n\
"

/* warning, MOVL $..., %ECX must be first, it is read by the kernel when
   throwing the AST to userspace.
   Similar code exists in INIT_THREAD_UNBLOCK and ALLOC_THREAD
*/

#define __AST_ENTRY(PL, VAR, LOCAL, NO_UPPER)	"		\n\
	.IF	!("#\VAR")					\n\
	MOVL	$(-2) << ("#\PL"), %EDX				\n\
	.ELSEIF	("#\VAR") == 1					\n\
	MOVL	%EAX, %ECX					\n\
	SUBL	$("#\PL") - 8, %ECX				\n\
	XORL	%EDX, %EDX					\n\
	SHRL	$3, %ECX					\n\
	DECL	%EDX						\n\
	SHLL	%CL, %EDX					\n\
	.ELSE							\n\
	MOVL	%EAX, %ECX					\n\
	SUBL	("#\PL"), %ECX					\n\
	SHRL	$4, %ECX					\n\
	MOVL	$-2, %EDX					\n\
	SHLL	%CL, %EDX					\n\
	.ENDIF							\n\
7:	MOVL	$KERNEL$CPU_ID, %ECX				\n\
	CMPL	%EDX, %ESI					\n\
	JBE	9f						\n\
	.IF	!("#\LOCAL")					\n\
	CMPL	$0x80000000, (%ECX)				\n\
41:								\n\
	.SECTION .FEATURE_FIXUP					\n\
	.LONG	41b - 4, 41b, 0, 0, "__stringify(FEATURE_VALUE_CPU_ID)" \n\
	.PREVIOUS						\n\
	.IF	!("#\NO_UPPER")					\n\
	JNZ	6f						\n\
	.ELSE							\n\
	JNZ	9f						\n\
	.ENDIF							\n\
	.ENDIF							\n\
	MOVL	%EDX, 4(%ECX)					\n\
	.IF	!("#\NO_UPPER")					\n\
	TESTL	%EDX, 8(%ECX)					\n\
6:	JNZ	9f						\n\
	.ENDIF							\n\
	.IF	"__stringify(__DEBUG)" >= 2			\n\
	MOVL	$KERNEL$BPL, %ECX				\n\
	PUSHL	(%ECX)						\n\
	MOVL	%EDX, (%ECX)					\n\
	.ENDIF							\n\
								\n\
	.SECTION .text.end					\n\
	.IF "__stringify(__SPL_SIZE_OPTIMAL)" == 0		\n\
	.ALIGN	16						\n\
	.ENDIF							\n\
9:								\n\
	.IF	!("#\VAR")					\n\
	.IF	!("#\LOCAL")					\n\
	MOVL	$0x80000000, %EDX				\n\
51:								\n\
	CMPL	%EDX, (%ECX)					\n\
	JNZ	5f						\n\
	.ENDIF							\n\
	MOVL	$1 << ("#\PL"), %ECX				\n\
	MOVL	$("#\PL") * 8 + KERNEL$AST_QUEUES, %EDX		\n\
	JMP	KERNEL$QUEUE_AST				\n\
	.IF	!("#\LOCAL")					\n\
	.IF "__stringify(__SPL_SIZE_OPTIMAL)" == 0		\n\
	.ALIGN	4						\n\
	.ENDIF							\n\
5:								\n\
	MOVL	$"#\PL", %ECX					\n\
	JMP	*KERNEL$XCPU_AST				\n\
	.ENDIF							\n\
	.ELSE							\n\
	SARL	%EDX						\n\
	NEGL	%EDX						\n\
	MOVL	%EDX, %ECX					\n\
	BSFL	%EDX, %EDX					\n\
	LEAL	KERNEL$AST_QUEUES(, %EDX, 8), %EDX		\n\
	JMP	KERNEL$QUEUE_AST				\n\
	.ENDIF							\n\
	.PREVIOUS						\n\
								\n\
	.IF	!("#\VAR") && !("#\LOCAL")			\n\
	.SECTION .FEATURE_FIXUP					\n\
	.LONG	51b - 4, 51b, 0, 0, "__stringify(FEATURE_VALUE_CPU_ID)" \n\
	.PREVIOUS						\n\
	.ENDIF							\n\
"

#define __AST_ENTRY_2(PL, VAR)	"				\n\
	.SECTION .text.end					\n\
	.IF "__stringify(__SPL_SIZE_OPTIMAL)" == 0		\n\
	.ALIGN	16						\n\
	.ENDIF							\n\
8:								\n\
	.IF	!("#\VAR")					\n\
	MOVL	$1 << ("#\PL"), %ECX				\n\
	MOVL	$("#\PL") * 8 + KERNEL$AST_QUEUES, %EDX		\n\
	.ELSE							\n\
	SARL	%EDX						\n\
	NEGL	%EDX						\n\
	MOVL	%EDX, %ECX					\n\
	BSFL	%EDX, %EDX					\n\
	LEAL	KERNEL$AST_QUEUES(, %EDX, 8), %EDX		\n\
	.ENDIF							\n\
	JMP	KERNEL$QUEUE_IRQ_AST				\n\
	.PREVIOUS						\n\
"

#define __AST_RET	"					\n\
	.IF "__stringify(__DEBUG)" >= 2				\n\
	POPL KERNEL$BPL						\n\
	.ENDIF							\n\
	JMP *%EDX						\n\
"

#define DECL_AST(NAME, PL, STRUC)				\
__u64 __attribute__((entry(__AST_ENTRY(PL, 0, 0, PL == SPL_TOP)),ret(__AST_RET),cdecl)) NAME (STRUC *RQ)

#define DECL_IRQ_AST(NAME, PL, STRUC)				\
__u64 __attribute__((preentry(__AST_PREENTRY(PL, 0)),entry(__AST_ENTRY(PL, 0, 0, PL == SPL_TOP) __AST_ENTRY_2(PL, 0)),ret(__AST_RET),cdecl)) NAME (STRUC *RQ)

#define __DECL_VAST_P(NAME, ARRAY_BEGIN)			\
__u64 __attribute__((entry(__AST_ENTRY(ARRAY_BEGIN, 2, 1, 0)),ret(__AST_RET),cdecl)) NAME (AST *RQ)

#define __DECL_IRQ_VAST(NAME, ARRAY_BEGIN)			\
__u64 __attribute__((preentry(__AST_PREENTRY(ARRAY_BEGIN, 1)),entry(__AST_ENTRY(ARRAY_BEGIN, 1, 1, 0) __AST_ENTRY_2(ARRAY_BEGIN, 1)),ret(__AST_RET),cdecl)) NAME (AST *RQ)

#define __DECL_XCPU_AST()					\
__u64 XCPU_AST(AST *RQ, __cpu_id_t TARGET_CPU, int SPL) __attribute__((cdecl));\
__u64 __attribute__((entry("MOVL $(-2) << ("__stringify(SPL_TOP)"), KERNEL$SPL"),ret("JMP *%EDX"),cdecl)) XCPU_AST(AST *RQ, __cpu_id_t TARGET_CPU, int SPL)

#define KERNEL_AST_TMP3(repost)		(repost)
#define KERNEL_AST_TMP3_NOREPOST	(-1)

#define CALL_AST(RQ)			\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"((RQ)->fn),"a"(RQ),"S"(KERNEL$SPL):"cc","memory");	\
} while (0)

#define RETURN_AST(RQ)				\
do {						\
	/*__debug_printf("AST: %s:%d->%p ", __FILE__, __LINE__, (RQ)->fn);*/\
	return __make64((__u32)(RQ), (__u32)(RQ)->fn);	\
} while (0)

#define RETURN					\
do {						\
	return __make64hi((__u32)KERNEL$PROCESS_PENDING_AST);\
} while (0)

/*
 * IORQ
 */

typedef __u64 IO_STUB();

/* HARDCODED IN ASM.S IN "WAIT QUEUES" SECTION */

#define IORQ_HEAD		\
	AST_HEAD;		\
	unsigned long tmp2;	\
	unsigned long tmp3;	\
	long status

typedef struct __IORQ {
	IORQ_HEAD;
} IORQ;

#define __IORQ2WQ(RQ) ((WQ *)(void *)&(RQ)->tmp2)
#define __WQ2IORQ(WQ) ((IORQ *)(void *)((char *)(WQ) - (int)&((IORQ *)0)->tmp2))

#define CALL_IORQ_EXPR(RQ, OP)		\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	(RQ)->status = RQS_PROCESSING;	\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ(RQ, OP)		\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	(RQ)->status = RQS_PROCESSING;	\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL %c3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"i"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ_LSTAT_EXPR(RQ, OP)	\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ_LSTAT(RQ, OP)		\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL %c3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"i"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ_CANCELABLE_EXPR(RQ, OP, PRQ)		\
do {							\
	int __tmp1;					\
	int __tmp2;					\
	int __tmp3;					\
	unsigned __spl;					\
	(RQ)->status = RQS_PROCESSING;			\
	__spl = KERNEL$SPL;				\
	RAISE_SPL(SPL_TOP);				\
	if (__likely((PRQ)->status != RQS_WANTCANCEL)) {\
		(PRQ)->status = RQS_CHAINCANCELABLE;	\
		(PRQ)->tmp2 = (unsigned long)(RQ);	\
		__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
	} else {					\
		(RQ)->status = -EINTR;			\
		__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"((RQ)->fn),"a"(RQ),"S"(__spl):"cc","memory");	\
	}						\
} while (0)

#define CALL_IORQ_CANCELABLE(RQ, OP, PRQ)		\
do {							\
	int __tmp1;					\
	int __tmp2;					\
	int __tmp3;					\
	unsigned __spl;					\
	(RQ)->status = RQS_PROCESSING;			\
	__spl = KERNEL$SPL;				\
	RAISE_SPL(SPL_TOP);				\
	if (__likely((PRQ)->status != RQS_WANTCANCEL)) {\
		(PRQ)->status = RQS_CHAINCANCELABLE;	\
		(PRQ)->tmp2 = (unsigned long)(RQ);	\
		__asm__ volatile ("CALL %c3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"i"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
	} else {					\
		(RQ)->status = -EINTR;			\
		__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"((RQ)->fn),"a"(RQ),"S"(__spl):"cc","memory");	\
	}						\
} while (0)

#define RETURN_IORQ(RQ, OP)				\
do {							\
	/*__debug_printf("IORQ: %s:%d->%p ", __FILE__, __LINE__, (OP));*/\
	(RQ)->status = RQS_PROCESSING;			\
	RAISE_SPL(SPL_TOP);				\
	return __make64((__u32)(RQ), (__u32)(OP));	\
} while (0)

#define RETURN_IORQ_LSTAT(RQ, OP)			\
do {							\
	/*__debug_printf("IORQ: %s:%d->%p ", __FILE__, __LINE__, (OP));*/\
	RAISE_SPL(SPL_TOP);				\
	return __make64((__u32)(RQ), (__u32)(OP));	\
} while (0)

#define RETURN_IORQ_CANCELABLE(RQ, OP, PRQ)		\
do {							\
	/*__debug_printf("IORQ: %s:%d->%p ", __FILE__, __LINE__, (OP));*/\
	(RQ)->status = RQS_PROCESSING;			\
	RAISE_SPL(SPL_TOP);				\
	if (__likely((PRQ)->status != RQS_WANTCANCEL)) {\
		(PRQ)->status = RQS_CHAINCANCELABLE;	\
		(PRQ)->tmp2 = (unsigned long)(RQ);	\
		return __make64((__u32)(RQ), (__u32)(OP));\
	}						\
	(RQ)->status = -EINTR;				\
	RETURN_AST(RQ);					\
} while (0)

#define DECL_IOCALL(NAME, PL, STRUC)				\
__u64 __attribute__((entry("					\n\
	MOVL	$KERNEL$CPU_ID, %ECX				\n\
	MOVL	$(-2) << ("#\PL"), %EDX				\n\
	CMPL	%EDX, %ESI					\n\
	JBE	9f						\n\
	CMPL	$0x80000000, (%ECX)				\n\
41:								\n\
	.SECTION .FEATURE_FIXUP					\n\
	.LONG	41b - 4, 41b, 0, 0, "__stringify(FEATURE_VALUE_CPU_ID)" \n\
	.PREVIOUS						\n\
	JNZ	6f						\n\
	MOVL	%EDX, 4(%ECX)					\n\
	TESTL	%EDX, 8(%ECX)					\n\
6:	JNZ	9f						\n\
8:								\n\
	.IF	"__stringify(__DEBUG)" >= 2			\n\
	MOVL	$KERNEL$BPL, %ECX				\n\
	PUSHL	(%ECX)						\n\
	MOVL	%EDX, (%ECX)					\n\
	.ENDIF							\n\
	.SECTION .text.end					\n\
	.IF "__stringify(__SPL_SIZE_OPTIMAL)" == 0		\n\
	.ALIGN	64						\n\
	.ENDIF							\n\
9:								\n\
	MOVL	$0x80000000, %EDX				\n\
51:								\n\
	MOVL	$7f, 4(%EAX)					\n\
	ADDL	$4, %EAX					\n\
	CMPL	%EDX, (%ECX)					\n\
	JNZ	5f						\n\
	MOVL	$1 << ("#\PL"), %ECX				\n\
	MOVL	$("#\PL") * 8 + KERNEL$AST_QUEUES, %EDX		\n\
	JMP	KERNEL$QUEUE_AST				\n\
	.IF "__stringify(__SPL_SIZE_OPTIMAL)" == 0		\n\
	.ALIGN	4						\n\
	.ENDIF							\n\
7:	MOVL	$"#\NAME", (%EAX)				\n\
	SUBL	$4, %EAX					\n\
	JMP	"#\NAME"					\n\
	.IF "__stringify(__SPL_SIZE_OPTIMAL)" == 0		\n\
	.ALIGN	4						\n\
	.ENDIF							\n\
5:								\n\
	MOVL	$"#\PL", %ECX					\n\
	JMP	*KERNEL$XCPU_AST				\n\
	.PREVIOUS						\n\
	.SECTION .FEATURE_FIXUP					\n\
	.LONG	51b - 4, 51b, 0, 0, "__stringify(FEATURE_VALUE_CPU_ID)" \n\
	.PREVIOUS						\n\
"),ret("							\n\
	.IF "__stringify(__DEBUG)" >= 2				\n\
	POPL KERNEL$BPL						\n\
	.ENDIF							\n\
	JMP *%EDX						\n\
"),cdecl)) NAME (STRUC *RQ)

extern IORQ KERNEL$DUMMY_IORQ;

extern void *KERNEL$AST_QUEUES[];

static __finline__ void __CLEAR_ASTS(void **q, void **d)
{
	unsigned long diff = (unsigned long)d - (unsigned long)q;
	int i;
	for (i = 0; i < 32; i++) {
		q[1] = q[0] = (void *)((unsigned long)q + diff);
		q += 2;
	}
}

__END_DECLS

#endif
