#ifndef __ARCH_BT_H
#define __ARCH_BT_H

#include <SYS/TYPES.H>

static __finline__ int __BT(__const__ void *__ptr, int __bit)
{
	if (__is_constant(__bit)) {
		return (((unsigned char *)__ptr)[__bit / 8] & (1 << (__bit & 7))) != 0;
	} else {
		int __r;
		unsigned *__p = (unsigned *)__ptr;
		__asm__ volatile ("BTL %2, %1; SETC %b0":"=q"(__r):"m"(*__p),"rI"(__bit):"cc","memory");
		return __r & 1;
	}
}

static __finline__ int __BTS(void *__ptr, int __bit)
{
	int __r;
	unsigned *__p = (unsigned *)__ptr;
	__asm__ volatile ("BTSL %2, %1; SETC %b0":"=q"(__r):"m"(*__p),"rI"(__bit):"cc","memory");
	return __r & 1;
}

static __finline__ int __BTR(void *__ptr, int __bit)
{
	int __r;
	unsigned *__p = (unsigned *)__ptr;
	__asm__ volatile ("BTRL %2, %1; SETC %b0":"=q"(__r):"m"(*__p),"rI"(__bit):"cc","memory");
	return __r & 1;
}

static __finline__ int __BTC(void *__ptr, int __bit)
{
	int __r;
	unsigned *__p = (unsigned *)__ptr;
	__asm__ volatile ("BTCL %2, %1; SETC %b0":"=q"(__r):"m"(*__p),"rI"(__bit):"cc","memory");
	return __r & 1;
}

static __finline__ void __BS(void *__ptr, int __bit)
{
	if (__is_constant(__bit)) {
		((unsigned char *)__ptr)[__bit / 8] |= 1 << (__bit & 7);
	} else {
		unsigned *__p = (unsigned *)__ptr;
		__asm__ volatile ("BTSL %1, %0": :"m"(*__p),"rI"(__bit):"cc","memory");
	}
}

static __finline__ void __BR(void *__ptr, int __bit)
{
	if (__is_constant(__bit)) {
		((unsigned char *)__ptr)[__bit / 8] &= ~(1 << (__bit & 7));
	} else {
		unsigned *__p = (unsigned *)__ptr;
		__asm__ volatile ("BTRL %1, %0": :"m"(*__p),"rI"(__bit):"cc","memory");
	}
}

static __finline__ void __BC(void *__ptr, int __bit)
{
	if (__is_constant(__bit)) {
		((unsigned char *)__ptr)[__bit / 8] ^= 1 << (__bit & 7);
	} else {
		unsigned *__p = (unsigned *)__ptr;
		__asm__ volatile ("BTCL %1, %0": :"m"(*__p),"rI"(__bit):"cc","memory");
	}
}

static __finline__ unsigned long __BVS(unsigned long __x, int __bit)
{
	__asm__ ("BTSL %1, %0":"=r"(__x):"r"(__bit),"0"(__x):"cc");
	return __x;
}

static __finline__ unsigned long __BVR(unsigned long __x, int __bit)
{
	__asm__ ("BTRL %1, %0":"=r"(__x):"r"(__bit),"0"(__x):"cc");
	return __x;
}

static __finline__ unsigned long __BVC(unsigned long __x, int __bit)
{
	__asm__ ("BTCL %1, %0":"=r"(__x):"r"(__bit),"0"(__x):"cc");
	return __x;
}

static __finline__ int __BSCAN(unsigned long __x)
{
	int __r;
	__asm__ ("BSFL %1, %0":"=r"(__r):"rm"(__x):"cc");
	return __r;
}

#endif
