#ifndef __ARCH_CPU_H
#define __ARCH_CPU_H

#include <ARCH/CPUDEF.H>
#include <STRING.H>
#include <SYS/TYPES.H>
#include <SPAD/LIST.H>

int KERNEL$FEATURE_TEST(__u32 feature);

#define _FEATURE_ALT(feature, no, yes, type, constraint, instr, directive)\
({									\
	__u##type __ret;						\
	__asm__ ("							\n\
		"#instr"	%1, %0					\n\
	41:								\n\
		.SECTION .rodata.end					\n\
	43:	"#directive"	%c2					\n\
	44:	.PREVIOUS						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41b - ("#type") / 8, 41b, 43b, 44b, "__stringify(feature)"									\n\
		.PREVIOUS						\n\
	":#constraint(__ret):"i"(no),"i"(yes));				\
	__ret;								\
})

#define FEATURE_ALT8(feature, no, yes) _FEATURE_ALT(feature, no, yes, 8, =mq, MOVB, .BYTE)
#define FEATURE_ALT16(feature, no, yes) _FEATURE_ALT(feature, no, yes, 16, =g, MOVW, .WORD)
#define FEATURE_ALT32(feature, no, yes) _FEATURE_ALT(feature, no, yes, 32, =g, MOVL, .LONG)
#define FEATURE_TEST(feature)	FEATURE_ALT8(feature, 0, 1)

#define _FEATURE_VAL(feature, type, constraint, instr)			\
({									\
	__u##type __ret;						\
	__asm__ ("							\n\
		"#instr"	$0, %0					\n\
	41:								\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41b - ("#type") / 8, 41b, 0, 0, "__stringify(feature)"										\n\
		.PREVIOUS						\n\
	":#constraint(__ret):);						\
	__ret;								\
})

#define FEATURE_PATCHED()						\
({									\
	__u8 __ret;							\
	__asm__ ("							\n\
		MOVB	$0, %0						\n\
	41:								\n\
		.SECTION .rodata.end					\n\
	43:	.BYTE	1						\n\
	44:	.PREVIOUS						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41b - 1, 41b, 43b, 44b, "__stringify(0)"	\n\
		.LONG	41b - 1, 41b, 43b, 44b, "__stringify(FEATURE_NEGATE | 0)"									\n\
		.PREVIOUS						\n\
	":"=mq"(__ret):);						\
	__ret;								\
})

#define FEATURE_VAL8(feature)	_FEATURE_VAL(feature, 8, =mq, MOVB)
#define FEATURE_VAL16(feature)	_FEATURE_VAL(feature, 16, =g, MOVW)
#define FEATURE_VAL32(feature)	_FEATURE_VAL(feature, 32, =g, MOVL)

#define VAL_CPU_ID		FEATURE_VAL32(FEATURE_VALUE_CPU_ID)
#define VAL_CPU_ID_LIMIT	FEATURE_VAL32(FEATURE_VALUE_CPU_ID_LIMIT)
#define VAL_NODE_ID		FEATURE_VAL32(FEATURE_VALUE_NODE_ID)
#define VAL_NODE_ID_LIMIT	FEATURE_VAL32(FEATURE_VALUE_NODE_ID_LIMIT)

int KERNEL$READ_MSR(__u32 idx, __u64 *val);
int KERNEL$WRITE_MSR(__u32 idx, __u64 val);

static __finline__ void INIT_FPU(char *fpu, int init)
{
	if (__likely(KERNEL$FEATURE_TEST(FEATURE_FPU_FXSR))) {
		if (init) memset(fpu, 0, 512);
		*(__u32 *)&fpu[0x00] = 0x037fu;
		*(__u32 *)&fpu[0x18] = 0x1f80u;
		*(__u32 *)&fpu[0x1c] = 0xffffu;
	} else {
		if (init) memset(fpu, 0, 108);
	/* 94 or 108 ??? Intel says: "Store FPU state to m94byte or m108byte" */
		*(__u32 *)&fpu[0x00] = 0xffff037fu;
		*(__u32 *)&fpu[0x04] = 0xffff0000u;
		*(__u32 *)&fpu[0x08] = 0xffffffffu;
		*(__u32 *)&fpu[0x18] = 0xffff0000u;
	}
}

static __finline__ void DO_CPUID(__u32 level, __u32 *eax, __u32 *ebx, __u32 *ecx, __u32 *edx)
{
/* do not change EBX, because it can't be used when compiling with -fPIC */
	__u32 eax_sink, ebx_sink, ecx_sink, edx_sink;
	__asm__ volatile ("		\n\
		MOVL	%%EBX, %%ESI	\n\
		CPUID			\n\
		XCHGL	%%EBX, %%ESI	\n\
	":"=a"(*(eax ? eax : &eax_sink)),
	  "=S"(*(ebx ? ebx : &ebx_sink)),
	  "=c"(*(ecx ? ecx : &ecx_sink)),
	  "=d"(*(edx ? edx : &edx_sink)):
	  "a"(level));
}

static __finline__ void DO_CPUID0(__u32 *max_level, char vendor[13])
{
	__u32 vendor0, vendor4, vendor8;
	DO_CPUID(0, max_level, &vendor0, &vendor8, &vendor4);
	if (vendor) {
		memcpy(vendor, &vendor0, 4);
		memcpy(vendor + 4, &vendor4, 4);
		memcpy(vendor + 8, &vendor8, 4);
		vendor[12] = 0;
	}
}

static __finline__ void DO_CPUID1(unsigned *family, unsigned *model, unsigned *stepping, __u32 *feature1, __u32 *feature2)
{
	__u32 rev;
	DO_CPUID(1, &rev, NULL, feature2, feature1);
	if (family) {
		if ((*family = (rev & 0xf00) >> 8) == 0xf)
			*family += (rev & 0xff00000) >> 20;
	}
	if (model) {
		*model = (rev & 0xf0) >> 4;
		if ((rev & 0xf00) == 0x600 || (rev & 0xf00) == 0xf00)
			*model |= (rev & 0xf0000) >> 12;
	}
	if (stepping) {
		*stepping = rev & 0xf;
	}
}

extern long KERNEL$FPU_ENABLED;
void KERNEL$ENABLE_FPU(void);

/* note that this is for integer XMM (and you must restore all modified
   registers), not for FPU ! */
static __finline__ void START_XMM(void)
{
	if (__unlikely(!KERNEL$FPU_ENABLED)) KERNEL$ENABLE_FPU();
}

#endif
