#ifndef __ARCH_IPCHECKS
#define __ARCH_IPCHECKS

#include <SYS/TYPES.H>
#include <ARCH/SETUP.H>

typedef __u32 checksum_t;

static __finline__ void IP_HEADER_MAKE_CHECKSUM(__u8 *ip)
{
	unsigned dummy1, dummy2;
	__asm__ volatile ("				\n\
		CMPB	$0x45, (%2)			\n\
		JNZ	1f				\n\
		MOVZWL	8(%2), %1			\n\
		ADDL	4(%2), %1			\n\
		ADCL	12(%2), %1			\n\
		ADCL	16(%2), %1			\n\
		ADCL	(%2), %1			\n\
		ADCL	$0, %1				\n\
	2:	MOVL	%1, %0				\n\
		SHRL	$16, %1				\n\
		ORL	$0xFFFF0000, %0			\n\
		ADDL	%0, %1				\n\
		ADCL	$0, %1				\n\
		NOTL	%1				\n\
		MOVW	%w1, 10(%2)			\n\
		.SECTION .text.end			\n\
	1:	PUSHL	%%EAX				\n\
		PUSHL	%%EAX				\n\
		PUSHL	%%ECX				\n\
		PUSHL	%%EDX				\n\
		MOVL	%2, %%EDX			\n\
		XORL	%%EAX, %%EAX			\n\
		MOVZBL	(%%EDX), %%ECX			\n\
		MOVW	%%AX, 10(%%EDX)			\n\
		SHLB	$2, %%CL			\n\
		CALL	NET$IP_CHECKSUM			\n\
		MOVL	%%EAX, 12(%%ESP)		\n\
		POPL	%%EDX				\n\
		POPL	%%ECX				\n\
		POPL	%%EAX				\n\
		POPL	%1				\n\
		JMP	2b				\n\
		.PREVIOUS				\n\
	":"=&r"(dummy1),"=&r"(dummy2):"r"(ip):"cc","memory");
}

static __finline__ unsigned IP_HEADER_CHECK_5(__u8 *ip)
{
	unsigned dummy1, checksum;
	__asm__ volatile ("				\n\
		MOVL	8(%2), %1			\n\
		ADDL	4(%2), %1			\n\
		ADCL	12(%2), %1			\n\
		ADCL	16(%2), %1			\n\
		ADCL	(%2), %1			\n\
		ADCL	$0, %1				\n\
		MOVL	%1, %0				\n\
		SHRL	$16, %1				\n\
		ORL	$0xFFFF0000, %0			\n\
		ADDL	%0, %1				\n\
		ADCL	$0, %1				\n\
	":"=&r"(dummy1),"=&r"(checksum):"r"(ip):"cc","memory");
	return checksum & 0xFFFF;
}

#define TCPUDP_MAGIC_CHECKSUM(proto, len)		\
	(htons(__unlikely((len) + (proto) > 0xffff) ? (len) + (proto) - 0xffff : (len) + (proto)))

#define TCPUDP_MAGIC_CHECKSUM_UNFOLDED(proto, len)	\
	((checksum_t)(htons(len) + (proto << 8)))

static __finline__ unsigned IP_CHECKSUM_FOLD(checksum_t checksum)
{
	unsigned dummy1;
	__asm__ ("					\n\
		MOVL	%1, %0				\n\
		SHRL	$16, %1				\n\
		ORL	$0xFFFF0000, %0			\n\
		ADDL	%0, %1				\n\
		ADCL	$0, %1				\n\
	":"=&r"(dummy1),"=&r"(checksum):"1"(checksum):"cc");
	return checksum & 0xFFFF;
}

static __finline__ unsigned IP_CHECKSUM_FOLD_INVERT(checksum_t checksum)
{
	unsigned dummy1;
	__asm__ ("					\n\
		MOVL	%1, %0				\n\
		SHRL	$16, %1				\n\
		ORL	$0xFFFF0000, %0			\n\
		ADDL	%0, %1				\n\
		ADCL	$0, %1				\n\
	":"=&r"(dummy1),"=&r"(checksum):"1"(checksum):"cc");
	return ~checksum & 0xFFFF;
}

checksum_t NET$IP_CHECKSUM(checksum_t init, __const__ void *ptr, size_t len);
checksum_t NET$IP_CHECKSUM_COPY(void *dest, __const__ void *ptr, size_t len);

#define __CHECKSUM_ALIGN	8	/* optimal align for checksums */

#endif
