#ifndef __ARCH_IRQ_H
#define __ARCH_IRQ_H

#include <SPAD/AC.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef __u32 IRQ_STUB(void *) __attribute__((cdecl,aligned(32)));

#define DECL_RT_IRQ_HANDLER(NAME)				\
__attribute__((cdecl,aligned(32))) __u32 NAME(void *DATA)

#define IRQ_RETURN						\
do {								\
	return 0;						\
} while (0)

#define IRQ_POST_AST(RQ)					\
do {								\
	return (__u32)(RQ);					\
} while (0)

/*
 * REQUEST IRQ
 */

#define IRQ_LIMIT		0x0ff

typedef struct __irq_handle IRQ_HANDLE;

__END_DECLS

#endif
