#ifndef __ARCH_LDT_H
#define __ARCH_LDT_H

int modify_ldt(int, void *, unsigned long);

struct modify_ldt_ldt_s {
	unsigned int entry_number;
	unsigned long base_addr;
	unsigned int limit;
	unsigned int seg_32bit:1;
	unsigned int contents:2;
	unsigned int read_exec_only:1;
	unsigned int limit_in_pages:1;
	unsigned int seg_not_present:1;
	unsigned int useable:1;
};

#define user_desc modify_ldt_ldt_s

#define LDT_ENTRIES		8192
#define LDT_ENTRY_SIZE		8

#define MODIFY_LDT_CONTENTS_DATA		0
#define MODIFY_LDT_CONTENTS_STACK		1
#define MODIFY_LDT_CONTENTS_CODE		2

#endif
