#ifndef __ARCH_LIMITS_H
#define __ARCH_LIMITS_H

#define SHRT_MAX	0x7FFF
#define SHRT_MIN	(-0x8000)
#define USHRT_MAX	0xFFFF
#define __SHORT_SGN_BIT	0x8000

#define INT_MAX		0x7FFFFFFF
#define INT_MIN		(-INT_MAX - 1)
#define UINT_MAX	0xFFFFFFFFU
#define __INT_SGN_BIT	0x80000000U

#define LONG_MAX	0x7FFFFFFFL
#define LONG_MIN	(-LONG_MAX - 1)
#define ULONG_MAX	0xFFFFFFFFUL
#define __LONG_SGN_BIT	0x80000000UL

#define LLONG_MAX	0x7FFFFFFFFFFFFFFFLL
#define LLONG_MIN	(-LLONG_MAX - 1)
#define ULLONG_MAX	0xFFFFFFFFFFFFFFFFULL
#define __LLONG_SGN_BIT	0x8000000000000000ULL

#define SIZE_T_MAX	UINT_MAX
#define SSIZE_T_MAX	INT_MAX
#define SSIZE_T_MIN	INT_MIN
#define OFF_MAX		LLONG_MAX
#define OFF_MIN		LLONG_MIN

#define LONG_BIT	32
#define WORD_BIT	32

#endif
