#ifndef __ARCH_LINK_H
#define __ARCH_LINK_H

#define MACH_CURRENT	0x32334149

#define JMP_BASE_OFFSET		0x10
#define JMP_SIZE		5
#define MAX_JMP_SYMBOLS		(LINK_HASH_STIR_LENGTH / JMP_SIZE)

#define RODATA_SECTION_ALIGN	64	/* this is maximum cacheline size */

#define SET_JMP(lh, i, off)						\
do {									\
	__u32 pos_ = JMP_BASE_OFFSET + (i) * JMP_SIZE;			\
	__u32 o_ = (off) - (pos_ + JMP_SIZE);				\
	__u8 *ptr_ = (__u8 *)(lh) + pos_;				\
	ptr_[0] = 0xe9;							\
	ptr_[1] = o_;							\
	ptr_[2] = o_ >> 8;						\
	ptr_[3] = o_ >> 16;						\
	ptr_[4] = o_ >> 24;						\
} while (0)

#endif
