#ifndef __ARCH_MOV_H
#define __ARCH_MOV_H

#include <ARCH/CPU.H>
#include <SYS/TYPES.H>

static __finline__ void __MOVNTI32(__u32 *__dest, __u32 __src)
{
#ifndef __NO_SSE
	__asm__ ("							\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_NEGATE | FEATURE_SSE2)"								\n\
		.PREVIOUS						\n\
	41:	MOVNTI	%1, %0						\n\
	42:	.SECTION .rodata.end					\n\
	43:	MOVL	%1, %0						\n\
	44:	.PREVIOUS						\n\
	" : "=m"(*__dest) : "r"(__src));
#else
	*__dest = __src;
#endif
}

static __finline__ void __MOVNTIPTR(void **__dest, void *__src)
{
	__MOVNTI32((__u32 *)__dest, (__u32)__src);
}

static __finline__ void __MOVNTI_FLUSH(void)
{
#ifndef __NO_SSE
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 42f, 42f, "__stringify(FEATURE_NEGATE | FEATURE_SSE2)"								\n\
		.PREVIOUS						\n\
	41:	SFENCE							\n\
	42:								\n\
	":::"memory");
#endif
}

#ifndef __NO_SSE
#define __GEN_PREFETCH(suffix,iarg,aarg,prio3d)				\
static __finline__ void __PREFETCH##suffix(__const__ void *__ptr)	\
{									\
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.IF "__stringify(prio3d)" <> 0				\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_3DNOW_PREFETCH)"									\n\
		.ELSE							\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_MORE | FEATURE_3DNOW_PREFETCH)", "__stringify(FEATURE_NEGATE | FEATURE_SSE_PREFETCH)"	\n\
		.ENDIF							\n\
		.LONG	41f, 42f, 42f, 42f, "__stringify(FEATURE_MORE | FEATURE_NEGATE | FEATURE_SSE_PREFETCH)", "__stringify(FEATURE_NEGATE | FEATURE_3DNOW_PREFETCH)"									\n\
		.PREVIOUS						\n\
	41:	PREFETCH"#iarg"	%0					\n\
	42:								\n\
		.SECTION .rodata.end					\n\
	43:	PREFETCH"#aarg"	%0					\n\
	44:	.PREVIOUS						\n\
		" :: "m"(*(__u16 *)__ptr));				\
}		/* __u16 will alias least data */
#else
#define __GEN_PREFETCH(arg)						\
static __finline__ void __PREFETCH##arg(__const__ void *__ptr)		\
{									\
}
#endif									\

__GEN_PREFETCH(NTA,NTA,,0)
__GEN_PREFETCH(T0,T0,,0)
__GEN_PREFETCH(T1,T1,,0)
__GEN_PREFETCH(T2,T2,,0)
__GEN_PREFETCH(W,T0,W,1)

#endif
