#ifndef __ARCH_PROC_H
#define __ARCH_PROC_H

#include <SPAD/AC.H>
#include <SPAD/WQ.H>
#include <SYS/TYPES.H>
#include <ARCH/SETUP.H>

typedef struct __proc PROC;

extern PROC KERNEL$PROC_KERNEL;

typedef __u32 sched_unsigned;
typedef __s32 sched_signed;

void KERNEL$SWITCH_PROC_ACCOUNT_TICKS(PROC *proc, sched_unsigned t);
void KERNEL$SWITCH_PROC_ACCOUNT(PROC *proc);
extern PROC *KERNEL$PROC_ACCOUNT;

#if __DEBUG >= 1
#define	__SWITCH_PROC_ACCOUNT_TEST_SPL(spl)				\
do {									\
	if (__unlikely(KERNEL$SPL != (spl)) || __unlikely(SPLX_BELOW(SPL_X(SPL_VSPACE), spl)))								\
		KERNEL$SUICIDE("SWITCH_PROC_ACCOUNT AT SPL %08X (EXPECTED %08X)", KERNEL$SPL, spl);							\
} while (0)
#else
#define	__SWITCH_PROC_ACCOUNT_TEST_SPL(spl)
#endif

#define SWITCH_PROC_ACCOUNT(proc, spl)				\
do {								\
	__SWITCH_PROC_ACCOUNT_TEST_SPL(spl);			\
	__asm__ volatile ("					\n\
		CMPL	KERNEL$PROC_ACCOUNT, %0			\n\
		JNE	7f					\n\
	6:							\n\
	.SECTION .text.end					\n\
		.ALIGN  "__stringify(__CPU_BRANCH_ALIGN)"	\n\
	7:	CMPL	$KERNEL$PROC_KERNEL, %0			\n\
		JE	6b					\n\
		PUSHL	%%EAX					\n\
		MOVL	%0, %%EAX				\n\
		PUSHL	%%EDX					\n\
		.IFNC	%1,%2					\n\
		MOVL	%1, KERNEL$SPL				\n\
		.ENDIF						\n\
		PUSHL	%%ECX					\n\
		CALL	KERNEL$SWITCH_PROC_ACCOUNT		\n\
		.IFNC	%1,%2					\n\
		MOVL	%2, %%EDX				\n\
		MOVL	%%EDX, KERNEL$SPL			\n\
		TESTL	%%EDX, KERNEL$PPL			\n\
		JNZ	9f					\n\
		.ENDIF						\n\
	8:	POPL	%%ECX					\n\
		POPL	%%EDX					\n\
		POPL	%%EAX					\n\
		JMP	6b					\n\
		.IFNC	%1,%2					\n\
	9:	PUSHL	%%ESI					\n\
		MOVL	%%EDX, %%ESI				\n\
		CALL	KERNEL$PROCESS_PENDING_AST		\n\
		POPL	%%ESI					\n\
		JMP	8b					\n\
		.ENDIF						\n\
	.PREVIOUS						\n\
	"::"r"(proc),"i"(SPL_X(SPL_VSPACE)),"ibSD"(spl):"cc","memory");\
} while (0)

#ifndef __NO_ASM_PREDICTIONS
#define __SWITCH_PROC_ACCOUNT_KERNEL_OPTIMIZE_JE	"JE,pt	61f\n"
#else
#define __SWITCH_PROC_ACCOUNT_KERNEL_OPTIMIZE_JE	"JE	61f\n"
#endif

#define SWITCH_PROC_ACCOUNT_KERNEL_OPTIMIZE(proc, spl)		\
do {								\
	__SWITCH_PROC_ACCOUNT_TEST_SPL(spl);			\
	__asm__ volatile ("					\n\
		CMPL	$KERNEL$PROC_KERNEL, %0			\n\
		JNE	7f					\n\
	6:							\n\
	.SECTION .text.end					\n\
		.ALIGN  "__stringify(__CPU_BRANCH_ALIGN)"	\n\
	7:	PUSHL	%%EAX					\n\
		MOVL	%0, %%EAX				\n\
		CMPL	KERNEL$PROC_ACCOUNT, %%EAX		\n"\
	__SWITCH_PROC_ACCOUNT_KERNEL_OPTIMIZE_JE		\
"		PUSHL	%%EDX					\n\
		.IFNC	%1,%2					\n\
		MOVL	%1, KERNEL$SPL				\n\
		.ENDIF						\n\
		PUSHL	%%ECX					\n\
		CALL	KERNEL$SWITCH_PROC_ACCOUNT		\n\
		MOVL	%2, %%EDX				\n\
		.IFNC	%1,%2					\n\
		MOVL	%%EDX, KERNEL$SPL			\n\
		TESTL	%%EDX, KERNEL$PPL			\n\
		JNZ	9f					\n\
		.ENDIF						\n\
	8:	POPL	%%ECX					\n\
		POPL	%%EDX					\n\
	61:	POPL	%%EAX					\n\
		JMP	6b					\n\
		.IFNC	%1,%2					\n\
	9:	PUSHL	%%ESI					\n\
		MOVL	%%EDX, %%ESI				\n\
		CALL	KERNEL$PROCESS_PENDING_AST		\n\
		POPL	%%ESI					\n\
		JMP	8b					\n\
		.ENDIF						\n\
	.PREVIOUS						\n\
	"::"rm"(proc),"i"(SPL_X(SPL_VSPACE)),"ibSD"(spl):"cc","memory");\
} while (0)

/*
	The above assembler is just an equivalent of this.
	GCC is dumb enough so that register usages on __unlikely path damage
	__likely path. Because this function is used in every IO packet entry
	routine, it is worth optimizing it in assembler.
	if (__unlikely((proc) != KERNEL$PROC_ACCOUNT) && (proc) != &KERNEL$PROC_KERNEL) {
		RAISE_SPL(SPL_VSPACE);
		KERNEL$SWITCH_PROC_ACCOUNT(proc);
		LOWER_SPLX(spl);
	}

	The following routine is optimization in case we already have ticks from
	KERNEL$GET_SCHED_TICKS() (it takes 80 cycles to get them --- executing
	rdtsc) --- it is used mainly in disk drivers.
*/

#define SWITCH_PROC_ACCOUNT_TICKS(proc, spl, t)			\
do {								\
	__SWITCH_PROC_ACCOUNT_TEST_SPL(spl);			\
	__asm__ volatile ("					\n\
		CMPL	KERNEL$PROC_ACCOUNT, %%EAX		\n\
		JE	6f					\n\
		CMPL	$KERNEL$PROC_KERNEL, %%EAX		\n\
		JE	6f					\n\
		PUSHL	%%EAX					\n\
		PUSHL	%%EDX					\n\
		.IFNC	%1,%2					\n\
		MOVL	%1, KERNEL$SPL				\n\
		.ENDIF						\n\
		CALL	KERNEL$SWITCH_PROC_ACCOUNT_TICKS	\n\
		.IFNC	%1,%2					\n\
		MOVL	%2, %%EDX				\n\
		MOVL	%%EDX, KERNEL$SPL			\n\
		TESTL	%%EDX, KERNEL$PPL			\n\
		JNZ	9f					\n\
		.ENDIF						\n\
	8:	POPL	%%EDX					\n\
		POPL	%%EAX					\n\
	6:							\n\
		.IFNC	%1,%2					\n\
	.SECTION .text.end					\n\
	9:	PUSHL	%%ESI					\n\
		MOVL	%%EDX, %%ESI				\n\
		CALL	KERNEL$PROCESS_PENDING_AST		\n\
		POPL	%%ESI					\n\
		JMP	8b					\n\
	.PREVIOUS						\n\
		.ENDIF						\n\
	"::"a"(proc),"i"(SPL_X(SPL_VSPACE)),"ibSD"(spl),"d"(t):"ecx","cc","memory");\
} while (0)

#endif
