#ifndef __ARCH_ROL_H
#define __ARCH_ROL_H

#include <SYS/TYPES.H>

#define __GEN_ROTS(type, asm_sfx, sfx)					\
									\
static __finline__ type __ROL##sfx(type __x, unsigned __n)		\
{									\
	type __r;							\
	__asm__ ("ROL"#asm_sfx" %b2, %0": "=g"(__r): "0"(__x), "ci"(__n): "cc");									\
	return __r;							\
}									\
									\
static __finline__ type __ROR##sfx(type __x, unsigned __n)		\
{									\
	type __r;							\
	__asm__ ("ROR"#asm_sfx" %b2, %0": "=g"(__r): "0"(__x), "ci"(__n): "cc");									\
	return __r;							\
}

__GEN_ROTS(__u8, B, 8)
__GEN_ROTS(__u16, L, 16)
__GEN_ROTS(__u32, L, 32)

#endif
