#ifndef __ARCH_SCHED_H
#define __ARCH_SCHED_H

#include <SYS/TYPES.H>
#include <ARCH/PROC.H>

#define SCHED_REFRESH_MASK	0xc0000000U
#define ARCH_SCHED_INV		0xffffffffU

#define ARCH_SCHED_ADD(ticks, invpri, count, dcount)			\
do {									\
	int dummy;							\
	if (__is_constant(ticks) && !ticks) break;			\
	__asm__ ("							\n\
		MULL %3							\n\
		ADDL %%EAX, %0						\n\
		ADCL %%EDX, %1						\n\
	":"+m"(dcount),"+m"(count),"=a"(dummy):"rm"(invpri),"a"(ticks):"dx","cc","memory");\
} while (0)

#endif
