#ifndef __ARCH_SLAB_H
#define __ARCH_SLAB_H

#include <SYS/TYPES.H>
#include <ARCH/SETUP.H>
#include <ARCH/PAGE.H>
#include <ARCH/SPL.H>
#include <ARCH/BSF.H>
#include <ARCH/SLABDEF.H>

__BEGIN_DECLS

/*int __PRINTF_ATTR__(1,2) __critical_printf(__const__ char *__fmt, ...);*/

#ifndef __static__
#define __static__ static
#endif

void KERNEL$SLAB_CHECK(struct __slhead *__sl, __const__ char *__msg);

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __slalloc(struct __slhead *__h);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __slalloc(struct __slhead *__h)
{
	void *__r;
	void *__dummy;
	__asm__ volatile ("						\n\
	MOVL	(%2), %0						\n\
	TESTL	%0, %0							\n\
	JZ	1f							\n\
	MOVL	(%0), %3						\n\
	INCL	16(%2)							\n\
	MOVL	%3, (%2)						\n\
5:									\n\
	.SECTION .text.end						\n\
	.ALIGN	4							\n\
1:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	MOVL	%3, %%EAX						\n\
	PUSHL	%%EDX							\n\
	CALL	KERNEL$__SLAB_ALLOC					\n\
	MOVL	8(%%ESP), %%ECX						\n\
	MOVL	%%EAX, 8(%%ESP)						\n\
	POPL	%%EDX							\n\
	MOVL	%%ECX, %%EAX						\n\
	POPL	%%ECX							\n\
	POPL	%0							\n\
	JMP	5b							\n\
	.PREVIOUS							\n\
":"=&r"(__r),"=r"(__dummy):"r"(__h->__current_page),"1"(__h):"cc","memory");
	/*if (__unlikely(!__r)) __critical_printf("SLALLOC FAIL: %s\n", __h->__name);*/
	return __r;
}
#endif

#ifdef __NO_INLINES
void __slfree(void *__s);
#else
__static__ __finline__ void __slfree(void *__s)
{
	void *__dummy;
	struct __slpage *__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);

	__asm__ volatile ("						\n\
	DECL	16(%1)							\n\
	MOVL	(%1), %0						\n\
	MOVL	%2, (%1)						\n\
	MOVL	%0, (%2)						\n\
	JZ	1f							\n\
	TESTL	%0, %0							\n\
	JZ	2f							\n\
5:									\n\
	.SECTION .text.end						\n\
	.ALIGN	4							\n\
1:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%1, %%EAX						\n\
	CALL	KERNEL$__SLAB_FREE_PAGE					\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
	.ALIGN	4							\n\
2:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%1, %%EAX						\n\
	CALL	KERNEL$__SLAB_PARTIAL_PAGE				\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
	.PREVIOUS							\n\
":"=&r"(__dummy):"r"(__p),"r"(__s):"cc","memory");
}
#endif

#ifndef __COMMON_C

static __finline__ void __slow_slfree(void *__s)
{
	__asm__ volatile ("						\n\
		PUSHAL							\n\
		.IFNC	%0,%%eax					\n\
		XCHGL	%0, %%EAX					\n\
		.ENDIF							\n\
		CALL	__slfree					\n\
		POPAL							\n\
	"::"r"(__s):"cc","memory");
}

#endif

__END_DECLS

#endif
