#ifndef __ARCH_STRING_H
#define __ARCH_STRING_H

#include <SYS/TYPES.H>

#define __MEMSET_EXPAND_LIMIT	64
#define __MEMCPY_EXPAND_LIMIT	64

__BEGIN_DECLS

#ifndef __static__
#define __static__ static
#endif

	/**********
	 * memset *
	 **********/

#ifndef __NO_INLINES
static __finline__ void *__generic_memset(void *__s, __u32 __c, size_t __count)
{
	__u32 __sink1, __sink2;
	__asm__ __volatile__ ("					\n\
		CALL	___memset_internal			\n\
	":"=c"(__sink1),"=D"(__sink2):"a"(__c),"0"(__count),"1"(__s):"cc","memory");
	return __s;
}
#endif

#ifdef __NO_INLINES
void *memset(void *__s, int __c, size_t __count);
#elif !defined(__COMMON_C)
__static__ __finline__ void *memset(void *__s, int __c, size_t __count)
{
	if (__is_constant(__count)) {
		return __builtin_memset(__s, __c, __count);
	} else if (__is_constant(__c)) {
		__c = (__u8)__c * 0x01010101;
	} else {
		__u32 __sink;
		__asm__ ("					\n\
			MOVB	%b1, %h1			\n\
			MOVZWL	%w1, %0				\n\
			SHLL	$16, %1				\n\
			ORL	%1, %0				\n\
		":"=&a"(__c),"=q"(__sink):"1"(__c):"cc");
	}
	return __generic_memset(__s, __c, __count);
}
#endif

	/**********
	 * memcpy *
	 **********/

#ifndef __NO_INLINES
static __finline__ void *__generic_memcpy(void *__t, __const__ void *__f, size_t __count)
{
	__u32 __sink1, __sink2, __sink3;
	__asm__ __volatile__ ("					\n\
		PUSHL	%%EDX					\n\
		CALL	___memcpy_internal			\n\
		POPL	%%EDX					\n\
	":"=c"(__sink1),"=D"(__sink2),"=S"(__sink3):"0"(__count),"1"(__t),"2"(__f):"cc","memory");
	return __t;
}
#endif

#ifdef __NO_INLINES
void *memcpy(void *__t, __const__ void *__f, size_t __count);
#elif !defined(__COMMON_C)
__static__ __finline__ void *memcpy(void *__t, __const__ void *__f, size_t __count)
{
	if (__is_constant(__count)) return __builtin_memcpy(__t, __f, __count);
	return __generic_memcpy(__t, __f, __count);
}
#endif

#ifdef __NO_INLINES
void *mempcpy(void *__t, __const__ void *__f, size_t __count);
#elif !defined(__COMMON_C)
__static__ __finline__ void *mempcpy(void *__t, __const__ void *__f, size_t __count)
{
#if defined(__GNUC__) && __GNUC__ >= 4
	if (__is_constant(__count)) return (char *)__builtin_mempcpy(__t, __f, __count);
#endif
	return (char *)__generic_memcpy(__t, __f, __count) + __count;
}
#endif

#define __mempcpy	mempcpy

	/************
	 * noinline *
	 ************/

size_t strlen(__const__ char *__s);
size_t strnlen(__const__ char *__s, size_t __count);
char *stpcpy(char *__dest, __const__ char *__src);
char *___stpcpy_alias(char *__dest, __const__ char *__src);
size_t strlcpy(char *__dest, __const__ char *__src, size_t __count);
size_t strlcat(char *__dest, __const__ char *__src, size_t __count);
char *strncpy(char *__dest, __const__ char *__src, size_t __count);
char *stpcat(char *__dest, __const__ char *__src);
char *strncat(char *__dest, __const__ char *__src, size_t __count);
char *strstr(__const__ char *__str, __const__ char *__substr);
int strcmp(__const__ char *__s1, __const__ char *__s2);
int strncmp(__const__ char *__s1, __const__ char *__s2, size_t __count);
int _strcasecmp(__const__ char *__s1, __const__ char *__s2);
void *memchr(__const__ void *__s, int __c, size_t __count);
int memcmp(__const__ void *__s1, __const__ void *__s2, size_t __count);
void *memmove(void *__t, __const__ void *__f, size_t __count);

	/**********
	 * strcpy *
	 **********/

#ifdef __NO_INLINES
char *strcpy(char *__dest, __const__ char *__src);
#elif !defined(__COMMON_C)
static __finline__ char *strcpy(char *__dest, __const__ char *__src)
{
	if (__is_constant(__src[0])) {
		return __builtin_strcpy(__dest, __src);
	} else {
		___stpcpy_alias(__dest, __src);
		return __dest;
	}
}
#endif

	/**********
	 * strcat *
	 **********/

#ifdef __NO_INLINES
char *strcat(char *__dest, __const__ char *__src);
#elif !defined(__COMMON_C)
static __finline__ char *strcat(char *__dest, __const__ char *__src)
{
	stpcat(__dest, __src);
	return __dest;
}
#endif

	/**********
	 * strchr *
	 **********/

char *___strchr_alias(__const__ char *__str, int __c);
char *___strchr_const(__const__ char *__str, int __c);
#ifdef __NO_INLINES
char *strchr(__const__ char *__str, int __c);
#elif !defined(__COMMON_C)
static __finline__ char *strchr(__const__ char *__str, int __c)
{
	if (__is_constant(__c)) return ___strchr_const(__str, ((__u8)__c * 0x01010101));
	else return ___strchr_alias(__str, __c);
}
#endif

	/***********
	 * strrchr *
	 ***********/

char *___strrchr_alias(__const__ char *__str, int __c);
char *___strrchr_const(__const__ char *__str, int __c);
#ifdef __NO_INLINES
char *strrchr(__const__ char *__str, int __c);
#elif !defined(__COMMON_C)
static __finline__ char *strrchr(__const__ char *__str, int __c)
{
	if (__is_constant(__c)) return ___strrchr_const(__str, ((__u8)__c * 0x01010101));
	else return ___strrchr_alias(__str, __c);
}
#endif

	/*******
	 * ffs *
	 *******/

#ifdef __NO_INLINES
int ffs(int __x);
#else
__static__ __finline__ int ffs(int __x)
{
	int __y;
	__asm__ ("				\n\
		BSFL %1, %0			\n\
		JZ 1f				\n\
	2:	.SECTION .text.end		\n\
	1:	MOVL $-1, %0			\n\
		JMP 2b				\n\
		.PREVIOUS			\n\
	" : "=r"(__y) : "rm"(__x) : "cc");
	return __y + 1;
}
#endif

#ifdef __NO_INLINES
int ffsl(long __x);
#else
__static__ __finline__ int ffsl(long __x)
{
	return ffs(__x);
}
#endif

#ifdef __NO_INLINES
int fls(int __x);
#else
__static__ __finline__ int fls(int __x)
{
	int __y;
	__asm__ ("				\n\
		BSRL %1, %0			\n\
		JZ 1f				\n\
	2:	.SECTION .text.end		\n\
	1:	MOVL $-1, %0			\n\
		JMP 2b				\n\
		.PREVIOUS			\n\
	" : "=r"(__y) : "rm"(__x) : "cc");
	return __y + 1;
}
#endif

#ifdef __NO_INLINES
int flsl(long __x);
#else
__static__ __finline__ int flsl(long __x)
{
	return ffs(__x);
}
#endif

	/***************
	 * __upcasechr *
	 ***************/

#ifdef __NO_INLINES
char __upcasechr(char __c);
#else
__static__ __finline__ char __upcasechr(char __c)
{
	__u8 __nc, __add;
	__asm__ ("			\n\
		CMPB	$26, %0		\n\
		SETNB	%1		\n\
	":"=q"(__nc),"=q"(__add):"0"((unsigned char)(__c - 0x61)):"cc");
	return __nc + (__add << 5) + 0x41;
}
#endif

	/***************
	 * __locasechr *
	 ***************/

#ifdef __NO_INLINES
char __locasechr(char __c);
#else
__static__ __finline__ char __locasechr(char __c)
{
	__u8 __nc, __add;
	__asm__ ("			\n\
		CMPB	$26, %0		\n\
		SETB	%1		\n\
	":"=q"(__nc),"=q"(__add):"0"((unsigned char)(__c - 0x41)):"cc");
	return __nc + (__add << 5) + 0x41;
}
#endif

	/************
	 * __upcase *
	 ************/

#ifdef __NO_INLINES
void __upcase(char *__ptr);
#else
__static__ __finline__ void __upcase(char *__ptr)
{
	while (*__ptr) {
		if (__unlikely((unsigned char)(*__ptr - 0x61) < (unsigned char)26)) *__ptr -= 0x20;
		__ptr++;
	}
}
#endif

	/************
	 * __locase *
	 ************/

#ifdef __NO_INLINES
void __locase(char *__ptr);
#else
__static__ __finline__ void __locase(char *__ptr)
{
	while (*__ptr) {
		if (__unlikely((unsigned char)(*__ptr - 0x41) < (unsigned char)26)) *__ptr += 0x20;
		__ptr++;
	}
}
#endif

	/***************
	 * _memcasecmp *
	 ***************/

/* must not touch memory after first mismatch */
#ifdef __NO_INLINES
int _memcasecmp(__const__ void *__s1, __const__ void *__s2, size_t __count);
#else
__static__ __finline__ int _memcasecmp(__const__ void *__s1, __const__ void *__s2, size_t __count)
{
	__const__ unsigned char *__p1 = (__const__ unsigned char *)__s1, *__p2 = (__const__ unsigned char *)__s2;
	while (__count--) {
		int __diff = (unsigned char)__upcasechr(*__p1++) - (unsigned char)__upcasechr(*__p2++);
		if (__unlikely(__diff)) return __diff;
	}
	return 0;
}
#endif

	/*****************
	 * __strcasexcmp *
	 *****************/

/* compare s1 and s2
   s2 is converted to upcase; length is e2 - s2
   s1 is NULL terminated
   returns 0 - match, nonzero - mismatch
   The specification is a bit crazy - it's because of maximizing performance
   of filesystem name lookups.
   I'm not sure if I should use SETB variant of upcase code.
   IMPORTANT NOTICE for someone reimplementing it:
   it must not touch memory after first mismatching byte. */
#ifdef __NO_INLINES
int __strcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2);
#else
__static__ __finline__ int __strcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2)
{
	__u32 __ret, __sink1, __sink2;
	__asm__ __volatile__ ("				\n\
		CMPL	%4, %5				\n\
		JE	3f				\n\
		.ALIGN	"__stringify(__CPU_LOOP_ALIGN)"	\n\
	2:	MOVZBL	(%4), %0			\n\
		INCL	%4				\n\
		CMPB	$0x61, %b0			\n\
		JAE	4f				\n\
	5:	SUBB	(%3), %b0			\n\
		JNZ	1f				\n\
		INCL	%3				\n\
		CMPL	%4, %5				\n\
		JNE	2b				\n\
	3:	MOVZBL	(%3), %0			\n\
	1:						\n\
		.SECTION .text.end			\n\
	4:	CMPB	$0x61 + 26, %b0			\n\
		JAE	6f				\n\
		SUBB	$0x20, %b0			\n\
	6:	JMP	5b				\n\
		.PREVIOUS				\n\
	":"=&q"(__ret),"=r"(__sink1),"=r"(__sink2):"1"(__s1),"2"(__s2),"r"(__e2):"cc","memory");
	return __ret;
#if 0		/* gcc generates lame code for this */
	while (__s2 < __e2) {
		if (__unlikely(__upcasechr(*__s2++) != *__s1++)) return 1;
	}
	return *__s1;
#endif
}
#endif

	/*****************
	 * __memcasexcmp *
	 *****************/

/* compare s1 and s2
   s2 is converted to upcase; length is e2 - s2
   s1 doesn't have to be NULL terminated
   returns 0 - match, nonzero - mismatch
   The specification is a bit crazy - it's because of maximizing performance
   of filesystem name lookups.
   I'm not sure if I should use SETB variant of upcase code.
   IMPORTANT NOTICE for someone reimplementing it:
   it must not touch memory after first mismatching byte. */
#ifdef __NO_INLINES
int __memcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2);
#else
__static__ __finline__ int __memcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2)
{
	__u32 __ret, __sink1, __sink2;
	__asm__ __volatile__ ("				\n\
		CMPL	%4, %5				\n\
		JE	3f				\n\
		.ALIGN	"__stringify(__CPU_LOOP_ALIGN)"	\n\
	2:	MOVZBL	(%4), %0			\n\
		INCL	%4				\n\
		CMPB	$0x61, %b0			\n\
		JAE	4f				\n\
	5:	SUBB	(%3), %b0			\n\
		JNZ	1f				\n\
		INCL	%3				\n\
		CMPL	%4, %5				\n\
		JNE	2b				\n\
	3:	XORL	%0, %0				\n\
	1:						\n\
		.SECTION .text.end			\n\
	4:	CMPB	$0x61 + 26, %b0			\n\
		JAE	6f				\n\
		SUBB	$0x20, %b0			\n\
	6:	JMP	5b				\n\
		.PREVIOUS				\n\
	":"=&q"(__ret),"=r"(__sink1),"=r"(__sink2):"1"(__s1),"2"(__s2),"r"(__e2):"cc","memory");
	return __ret;
#if 0		/* gcc generates lame code for this */
	while (__s2 < __e2) {
		if (__unlikely(__upcasechr(*__s2++) != *__s1++)) return 1;
	}
	return 0;
#endif
}
#endif

#ifndef __COMMON_C
static __finline__ unsigned char __bintoasc(unsigned char __n)
{
	unsigned char __ret;
	__asm__ ("					\n\
		ADDB	$0x90, %%AL			\n\
		DAA					\n\
		ADCB	$0x40, %%AL			\n\
		DAA					\n\
	":"=a"(__ret):"a"(__n):"cc");
	return __ret;
}
#endif

	/**************
	 * __byte_sum *
	 **************/

#ifdef __NO_INLINES
unsigned char __byte_sum(__const__ void *__ptr, int __len);
#else
__static__ __finline__ unsigned char __byte_sum(__const__ void *__ptr, int __len)
{
	__u32 __sum = 0;
	void *__e = (char *)__ptr + __len;
	__asm__ volatile ("": : :"memory");
	do {
		__sum ^= *(__u32 *)__ptr;
		__ptr = (char *)__ptr + 4;
	} while (__ptr < __e);
	__sum ^= __sum >> 16;
	__sum ^= __sum >> 8;
	__asm__ volatile ("": : :"memory");
	return __sum;
}
#endif

/* lookup in a table and avoid L1/2 cache footsteps.
Equivalent to return table[index] */
__u8 __secure_lookup_8(__const__ __u8 *__table, size_t __table_size, size_t __index);

__END_DECLS

#endif
