#ifndef __ARCH_TIME_H
#define __ARCH_TIME_H

#include <ARCH/SETUP.H>
#include <ARCH/CPU.H>
#include <SYS/TYPES.H>
#include <SPAD/LIST.H>
#include <ARCH/TIMEDEF.H>

__BEGIN_DECLS

static __finline__ unsigned RDTSC_LO(void)
{
	unsigned t;
	__asm__ volatile ("RDTSC":"=a"(t)::"dx");
	return t;
}

static __finline__ __u64 RDTSC(void)
{
	__u64 r;
	__asm__ volatile ("RDTSC":"=A"(r));
	return r;
}

static __finline__ __u64 TIMER_RANDOMNESS(void)
{
	__u64 t;
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_TSC)"	\n\
		.PREVIOUS						\n\
	41:								\n\
		PUSHL	%%ECX						\n\
		CALL	KERNEL$GET_JIFFIES				\n\
		POPL	%%ECX						\n\
	42:								\n\
		.SECTION .rodata.end					\n\
	43:								\n\
		RDTSC							\n\
	44:								\n\
		.PREVIOUS						\n\
	":"=A"(t)::"cc");
	return t;
}

static __finline__ void DO_NOP(void)
{
	__asm__ volatile ("REP; NOP");
}

static __finline__ void MONITOR(void *ptr)
{
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 42f, 42f, "__stringify(FEATURE_NEGATE | FEATURE_MONITOR)"								\n\
		.LONG	41f, 42f, 42f, 42f, "__stringify(FEATURE_USERSPACE)"\n\
		.PREVIOUS						\n\
	41:								\n\
		PUSHL	%%ECX						\n\
		XORL	%%ECX, %%ECX					\n\
		PUSHL	%%EDX						\n\
		XORL	%%EDX, %%EDX					\n\
		MONITOR							\n\
		POPL	%%EDX						\n\
		POPL	%%ECX						\n\
	42:								\n\
	"::"a"(ptr):"cc","memory");
}

static __finline__ void MWAIT(void)
{
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	40f, 41f, 41f, 41f, "__stringify(FEATURE_NEGATE | FEATURE_MONITOR)"								\n\
		.LONG	40f, 41f, 41f, 41f, "__stringify(FEATURE_USERSPACE)"\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_NEGATE | FEATURE_MONITOR)"								\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_USERSPACE)"\n\
		.PREVIOUS						\n\
	40:								\n\
		PUSHL	%%EAX						\n\
		XORL	%%EAX, %%EAX					\n\
		PUSHL	%%ECX						\n\
		XORL	%%ECX, %%ECX					\n\
		MWAIT							\n\
	41:								\n\
		POPL	%%ECX						\n\
		POPL	%%EAX						\n\
	42:								\n\
		.SECTION .rodata.end					\n\
	43:								\n\
		REP ; NOP						\n\
	44:								\n\
		.PREVIOUS						\n\
	":::"cc","memory");
}

typedef unsigned udelay_cookie_t;
void KERNEL$UDELAY(unsigned usec);
void KERNEL$UDELAY_PREPARE(udelay_cookie_t *cookie);
void KERNEL$UDELAY_WAIT(udelay_cookie_t *cookie, unsigned u);

typedef long jiffies_lo_t;
typedef unsigned long u_jiffies_lo_t;
typedef long long jiffies_t;
typedef unsigned long long u_jiffies_t;

jiffies_t KERNEL$GET_JIFFIES(void);
jiffies_lo_t KERNEL$GET_JIFFIES_LO(void);

extern jiffies_lo_t KERNEL$JIFFIES_STEP;
extern unsigned char KERNEL$JIFFIES_STEP_BITS;

#define TIMEOUT_JIFFIES(t)	(__likely((t) >= (u_jiffies_lo_t)KERNEL$JIFFIES_STEP) ? (t) : KERNEL$JIFFIES_STEP)

#define TV_2_JIFFIES(tv, j)					\
do {								\
	__asm__ ("						;\
		TESTL	$0xFFFF8000, %%EDX			;\
		JNZ	91f					;\
		SHLDL	$16, %%EAX, %%EDX			;\
		PUSHL	%%EDX					;\
		PUSHL	%%EAX					;\
		MOVL	$1125899907, %%EAX			;\
		MULL	%2					;\
		POPL	%%EAX					;\
		SHLL	$16, %%EAX				;\
		SHRL	$2, %%EDX				;\
		ADDL	%%EDX, %%EAX				;\
		POPL	%%EDX					;\
		JC	9f					;\
	8:							;\
		.SECTION .text.end				;\
	9:	INCL	%%EDX					;\
		JNS	92f					;\
	91:	ORL	$0xFFFFFFFF, %%EAX			;\
		MOVL	$0x7FFFFFFF, %%EDX			;\
	92:	JMP	8b					;\
		.PREVIOUS					;\
	":"=A"(j):"A"((tv)->tv_sec),"rm"((tv)->tv_usec):"cc");	\
} while (0)

#define JIFFIES_2_TV(j, tv)					\
do {								\
	__asm__ volatile ("					;\
		MOVZWL	%%AX, %1				;\
		IMUL	$15625, %1				;\
		SHRDL	$16, %%EDX, %%EAX			;\
		SHRL	$16, %%EDX				;\
		SHRL	$10, %1					;\
	":"=A"((tv)->tv_sec),"=r"((tv)->tv_usec):"A"((u_jiffies_t)(j)):"cc");\
} while (0)

#define USEC_2_JIFFIES_LO(u, j)					\
do {								\
	__asm__ ("						;\
		MOVL	$1125899907, %%EAX			;\
		MULL	%1					;\
		SHRL	$2, %%EDX				;\
	":"=d"(j):"rm"(u):"ax","cc");				\
} while (0)

#define MSEC_2_JIFFIES(m, j)					\
do {								\
	__asm__ ("						;\
		MOVL	$274877907, %%EAX			;\
		MULL	%1					;\
		SHRDL	$22, %%EDX, %%EAX			;\
		SHRL	$22, %%EDX				;\
	":"=&A"(j):"rm"(m):"cc");				\
} while (0)

typedef struct __timer TIMER;

struct __timer {
	LIST_ENTRY list;	/* must be first */
	void (*fn)(TIMER *);
	__u32 __time_lo;
	__u32 __time_hi;
};

void KERNEL$BEEP(unsigned freq);

__END_DECLS

#endif
