#ifndef __ARCH_TYPES_H
#define __ARCH_TYPES_H

#define __IA32__

#ifndef NULL
#define NULL 0
#endif

#define __32_BIT

typedef __signed__ char __s8;
typedef unsigned char __u8;
#define __8_format	"hh"

typedef __signed__ short __s16;
typedef unsigned short __u16;
#define __16_format	"h"

typedef __signed__ int __s32;
typedef unsigned int __u32;
#define __32_format	""

typedef __signed__ long long __s64;
typedef unsigned long long __u64;
#define __64_format	"L"

#define __64_signed_const(c)	c##LL
#define __64_unsigned_const(c)	c##ULL

typedef __u32 __f_off;

#define __VOFF_T_64
typedef __u64 __v_off;			/* address in vspace */

typedef __u64 __p_addr;			/* physical address */

typedef __u32 __cpu_id_t;
typedef __u32 __node_id_t;

#ifndef __CROSS_COMPILING_LINKER
typedef __u32 size_t;
typedef __s32 ssize_t;

#define __OFF_T_64
typedef __u64 _u_off_t;
typedef __s64 off_t;
#define __off_t_format	"L"
#define __OFF_T_ALIGN	4
#endif

#ifndef _FILE_OFFSET_BITS
#define _FILE_OFFSET_BITS	64
#endif

#define __TIME_T_ALIGN	4

typedef __u64 uintmax_t;
typedef __s64 intmax_t;

#define __VOFF2U32(u64) ((__u32 *)(void *)(u64))

#ifdef __GNUC__
#define __LONG_LONG_SUPPORTED
#define __LONG_DOUBLE_SUPPORTED
#endif

#define __ERR_PTR(p)	((void *)(long)(p))

#define __PTR_ERR(e)	((long)(e))

#define __IS_ERR(p)	((unsigned long)(p) >= (unsigned long)-0x7ffe)

#define __stringify(x) #\x

static __finline__ __u64 __make64(__u32 __lo, __u32 __hi)
{
#if !defined(__GNUC__) || __GNUC__ <= 2 || __GNUC__ >= 4
	return ((__u64)__hi << 32) | __lo;
#else
	__u64 __r;
	__asm__ ("":"=A"(__r):"a"(__lo),"d"(__hi));
	return __r;
#endif
}

static __finline__ __u64 __make64hi(__u32 __hi)
{
#if !defined(__GNUC__) || __GNUC__ <= 2 || __GNUC__ >= 4
	return (__u64)__hi << 32;
#else
	__u64 __r;
	__asm__ ("":"=A"(__r):"d"(__hi));
	return __r;
#endif
}

#endif
