#ifndef __ARCH_VM_H
#define __ARCH_VM_H

#include <SPAD/VMDEF.H>
#include <SYS/TYPES.H>
#include <SPAD/WQ.H>

__BEGIN_DECLS

typedef struct __page PAGE;
typedef struct __spages SPAGES;
typedef struct __spage_entry SPAGE_ENTRY;
typedef struct __spage SPAGE;

#if __DEBUG_WQ
#define ___PG_STRUCT_PAGE_PAD	0
#else
#define ___PG_STRUCT_PAGE_PAD	12
#endif

/* page is dirty if page->dirty_from < page->dirty_to */

extern __u8 *KERNEL$ZERO_BANK;

void *KERNEL$MAP_PHYSICAL_BANK(__p_addr physaddr);
void *KERNEL$MAP_PHYSICAL_PAGE(PAGE *p);
void KERNEL$UNMAP_PHYSICAL_BANK(void *ptr);
__p_addr KERNEL$UNMAP_PHYSICAL_BANK_ADDR(void *ptr);
PAGE *KERNEL$UNMAP_PHYSICAL_BANK_PAGE(void *ptr);

void *KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(__p_addr physaddr, unsigned length, int pat);
void KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(const void *vaddr, unsigned length);

__p_addr KERNEL$PAGE_2_PHYS(PAGE *p);
PAGE *KERNEL$PHYS_2_PAGE(__p_addr p);

unsigned long KERNEL$VIRT_2_PHYS(void *virt);
void *KERNEL$PHYS_2_VIRT(unsigned long phys);
void *KERNEL$DMA_2_VIRT(unsigned long dma);

__p_addr KERNEL$PHYSICAL_UNMAP_DMA(__u32 dma);
__p_addr KERNEL$PHYSICAL_UNMAP_DMA64(__u64 dma);

__END_DECLS

#endif
