#include <ARCH/CPUDEF.H>
#include <ARCH/LINK.H>
#include <KERNEL/ASMDEF.H>
#include <PRG/BIND_SYS/FSDCODE.H>
#include <KERNEL/RELEASE.H>

OFFSET_LENGTH = 8
OFFSET_CHECKSUM = 12
EXTRA_BYTES = 16

MAX_SECTORS = 18
BOOT_SECTOR_BASE = 0x7c00
SECTOR_BASE = 0x7e00
SETUP_BASE = SECTOR_BASE + 0x200 * MAX_SECTORS

.CODE16
.GLOBAL _start
_start:
	PUSHW	$0
	POPW	%DS
	PUSHW	%DS
	POPW	%ES
	PUSHW	%DS
	POPW	%SS
	MOVW	$BOOT_SECTOR_BASE, %SP
/* First try whatever disk BIOS suggested */
	CALL	TRY_DISK
	MOVB	$0x80, %DL
2:
	CALL	TRY_DISK
	INCW	%DX
	CMPB	$0x90, %DL
	JB	2b
	MOVB	$0x00, %DL
/* Warning:
   Some smart-ass bioses patch bootsector after loading it from USB.
   Patched offsets are: 28, 29, 30, 31, 36 (they are rewritten with 0).
   If you change anything here, make sure that these skips are at correct
   addresses.
*/
	JMP	SKIP_1
	.LONG	0
SKIP_1:
	CALL	TRY_DISK
	MOVB	$0, %AL		/* skip patched value */
	MOVW	$BOOT_SECTOR_BASE + NO_IMAGE_MSG, %SI
PRINT_STRING:
6:	LODSB
	TESTB	%AL, %AL
5:	JZ	5b
	MOVW	$0x0070, %BX
	MOVB	$0x0e, %AH
	INT	$0x10
	JMP	6b

TRY_DISK:
	CLD
	XORL	%EBP, %EBP
TRY_PARTITION:
	MOVB	$1, %CL
	CALL	LOAD_SECTOR
	JC	0f
	CALL	CMP_MARK
	MOVW	$SECTOR_BASE + 0x1BE, %BX
	XORW	%AX, %AX
	PUSHW	$1
	PUSHL	0x38(%BX)
	PUSHW	0x34(%BX)
	PUSHW	%AX
	PUSHL	0x28(%BX)
	PUSHW	0x24(%BX)
	PUSHW	%AX
	PUSHL	0x18(%BX)
	PUSHW	0x14(%BX)
	PUSHW	%AX
	PUSHL	0x08(%BX)
	PUSHW	0x04(%BX)
2:	POPW	%AX
	POPL	%ECX
	PUSHL	%EBP
	TESTL	%ECX, %ECX
	JZ	3f
	CMPB	$0x05, %AL
	JE	7f
	CMPB	$0x0f, %AL
	JE	7f
	CMPB	$0x85, %AL
	JNE	4f
7:	TESTL	%EBP, %EBP
	JNE	8f
	MOVL	%ECX, BOOT_SECTOR_BASE - 4
	JMP	9f
8:	ADDL	BOOT_SECTOR_BASE - 4, %ECX
9:	MOVL	%ECX, %EBP
	CALL	TRY_PARTITION
	JMP	3f
4:	ADDL	%ECX, %EBP
	MOVB	$1, %CL
	CALL	LOAD_SECTOR
	JC	3f
	CALL	CMP_MARK
3:	POPL	%EBP
	POPW	%AX
	TESTW	%AX, %AX
	JZ	2b
0:	RET

LOAD_SECTOR:
	MOVW	$BOOT_SECTOR_BASE + PACKET, %SI
	MOVB	%CL, 2(%SI)
	MOVL	%EBP, 8(%SI)
	MOVB	$0x42, %AH
	INT	$0x13
	JNC	0f
	PUSHW	%DX
	XORW	%DI, %DI   /* ES:DI == 0 : Interrupt list, guard against bugs */
	MOVW	%DI, %ES
	MOVB	$0x08, %AH
	INT	$0x13
	MOVZBL	%DH, %ESI
	POPW	%BX
	PUSHW	%DS
	POPW	%ES
	JC	1f
	MOVL	%EBP, %EAX
	XORL	%EDX, %EDX
	ANDL	$0x3f, %ECX
/* Some wacky BIOSes return zero here
   (namely the Promise BIOS, when the disk has incomplete IDENT information
   due to delayed spin-up)
   Screw you guys, I'm going home */
	JZ	1f
	DIVL	%ECX
	MOVW	%DX, %CX
	INCW	%CX
	CDQ
	INCW	%SI
	JZ	1f
	DIVL	%ESI
	MOVB	%DL, %DH
	MOVB	%BL, %DL
	CMPW	$0x400, %AX
	JAE	0f
	XCHGB	%AL, %AH
	SHLB	$6, %AL
	ADDW	%AX, %CX
	MOVW	$SECTOR_BASE, %BX
	MOVB	$0x02, %AH
	MOVB	BOOT_SECTOR_BASE + PACKET + 2, %AL
	INT	$0x13
0:	RET
1:	MOVB	%BL, %DL
	STC
	RET

CMP_MARK:
	MOVW	$BOOT_SECTOR_BASE, %SI
	MOVW	$SECTOR_BASE, %DI
	MOVW	$END_COMPARE, %CX
	REPE
	CMPSB
	JNE	0b

	INCL	%EBP
	MOVB	$SETUP_SECTORS, %CL
	MOVW	$SETUP_BASE, %DI
1:	PUSHW	%CX
	PUSHW	%DI
	MOVB	$1, %CL
	CALL	LOAD_SECTOR
PRINT_LOAD_ERROR:
	MOVW	$BOOT_SECTOR_BASE + LOAD_ERR, %SI
3:	JC	PRINT_STRING
	POPW	%DI
	MOVW	$SECTOR_BASE, %SI
	MOVW	$0x100, %CX
	REP
	MOVSW
	POPW	%CX
	INCL	%EBP
	LOOPW	1b

	JMP	DISK_LOADER_CONT - LOADER_HDR + SETUP_BASE - BOOT_SECTOR_BASE

NO_IMAGE_MSG:
	.STRING	"NOT FOUND"
LOAD_ERR:
	.STRING	"LOAD ERROR"

	.ORG	0x1a8
MAGIC_1:	.LONG	0x12345678
MAGIC_2:	.LONG	0x9abcdef0
END_COMPARE:

PACKET:	.BYTE	0x10, 0x00
	.WORD	0x0001
	.WORD	SECTOR_BASE
	.WORD	0
	.LONG	0
	.LONG	0

HIMEM:	.LONG	0, 0
	.LONG	0, 0

	.WORD	0x0200 * MAX_SECTORS - 1
	.WORD	SECTOR_BASE
	.BYTE	0
	.BYTE	0x93
	.WORD	0

	.WORD	0x0200 * MAX_SECTORS - 1
HIM_LO:	.WORD	0
HIM_HI:	.BYTE	0x10
	.BYTE	0x93
	.WORD	0

	.LONG	0, 0
	.LONG	0, 0

	.ORG	497

SETUP_SECTORS = (LOADER_END - _start - 512) >> 9

SETUP_SECTS:	.BYTE	SETUP_SECTORS
ROOT_FLAGS:	.WORD	0
SYSSIZE:	.WORD	-1	# BIND_SYS places system size here
SWAP_DEV:	.WORD	0
RAM_SIZE:	.WORD	0
VID_MODE:	.WORD	0
ROOT_DEV:	.WORD	0
BOOT_FLAG:	.WORD	0xAA55

LOADER_HDR:

	.BYTE	0xEB
	.BYTE	JMP_STARTUP_1 - 1f
1:

			.ASCII	"HdrS"
			.WORD	0x0201
REALMODE_SWITCH:	.WORD	0, 0
START_SYS_SEG:		.WORD	0x1000
KERNEL_VERSION:		.WORD	VERSION - LOADER_HDR
TYPE_OF_LOADER:		.BYTE	0
LOADFLAGS:		.BYTE	1
SETUP_MOVE_SIZE:	.WORD	0x8000

CODE32_START:		.LONG	0x100000
RAMDISK_IMAGE:		.LONG	0
RAMDISK_SIZE:		.LONG	0
BOOTSECT_KLUDGE:	.LONG	0
HEAP_END_PTR:		.WORD	0

SIZE_IN_SECTORS:	.WORD	0

CMD_LINE_PTR:		.LONG	0

JMP_STARTUP_1:
	JMP	STARTUP

DISK_LOADER_CONT:
	PUSHW	%DX
#	MOVZWL	BOOT_SECTOR_BASE + SYSSIZE, %ECX
#	ADDL	$31, %ECX
#	SHRL	$5, %ECX
#		support kernels larger than 1MB
	MOVW	SETUP_BASE + 38, %CX
	MOVW	$0x10000/5, %AX
	MULW	%CX
	MOVW	%DX, %SI
	MOVW	%DX, %BX
	MOVW	$0x09b0, %AX
	POPW	%DX
	MOVW	$1, %DI
1:	DECW	%DI
	JNZ	2f
	PUSHAW
	MOVW	$MAX_SECTORS, %CX
11:	POPW	%DI
	PUSHW	%CX
	CALL	LOAD_SECTOR + BOOT_SECTOR_BASE - SETUP_BASE + 0x200
	POPW	%CX
	PUSHW	%CX
	JNC	10f
	LOOPW	11b
	JMP	PRINT_LOAD_ERROR - SETUP_BASE + BOOT_SECTOR_BASE + 0x200
10:
	MOVW	$BOOT_SECTOR_BASE + HIMEM, %SI
	XCHGB	%CL, %CH
	MOVB	$0x87, %AH
# About wbinvds:
# I don't know any reason for them
# Without them, I get rare load failures on Athlon with VIA chipset
# and very frequent failures on double Opterons on ServerWorks chipset
# (more than half of loads fail checksum).
# The corruption happens in destination memory >= 1M.
# If you have any hint or explanation for this, write me.
# I don't know why lilo and other loaders work without wbinvds.
	WBINVD
	INT	$0x15
	WBINVD
	MOVW	$SETUP_BASE + HIMEM_ERROR_MSG - LOADER_HDR, %SI
	JC	PRINT_STRING - SETUP_BASE + BOOT_SECTOR_BASE + 0x200
	POPAW
2:	ADDW	$0x200, BOOT_SECTOR_BASE + HIM_LO
	ADCB	$0, BOOT_SECTOR_BASE + HIM_HI
	DECW	%SI
	JNZ	3f
	PUSHAW
	MOVW	$0x0007, %BX
	MOVW	$1, %CX
	INT	$0x10
	POPAW
	CMPB	$0xb2, %AL
	INCW	%AX
	JB	4f
	MOVB	$0xdb, %AL
4:	MOVW	%BX, %SI
3:	INCL	%EBP
	LOOPW	1b

#	motor is stopped below ...
#	MOVW	$18 * 5, %CX
#5:	TESTB	$1, 0x43f
#	JZ	6f
#	CMPB	0x46c, %AL
#	JE	5b
#	MOVB	0x46c, %AL
#	LOOPW	5b
#6:

STARTUP:
	PUSHW	$0x0040
	POPW	%ES
	MOVW	$0xB800, %AX
	CMPB	$7, %ES:0x49
	JNE	CGA
	MOVB	$0xB0, %AH
CGA:	MOVW	%AX, %ES
	MOVL	$0x70507053, %ES:0
	MOVL	$0x70447041, %ES:4
	XORL	%EBP, %EBP
	XORL	%EBX, %EBX
	MOVW	%CS, %BP
	MOVW	%BP, %DS
	CALL	WHERE_AM_I
WHERE_AM_I:
	POPW	%BX
	MOVL	%EBP, %EAX
#	SHLL	$16, %EAX
#	MOVW	%BX, %AX
#	JMP	DEBUG16
	SHLL	$4, %EBP
	ADDL	%EBX, %EBP

#	ADDL	%EBP, SM_CODE + 2 - WHERE_AM_I(%BX)	# SELF MODIFYING
	.BYTE	0x66, 0x01, 0xaf
	.WORD	SM_CODE + 2 - WHERE_AM_I

#	not needed because of INT $0x15 below
#	JMP	FLUSH_QUEUE
#FLUSH_QUEUE:

	PUSHAL
	PUSHW	%ES
	MOVL	%EBX, %EDI
	ADDL	$MEM_DESCR - WHERE_AM_I, %EDI
#	LEAL	MEM_DESCR - WHERE_AM_I(%EBX), %EDI
	XORL	%EBX, %EBX
2:	MOVL	$0x0000e820, %EAX
	MOVL	$0x534d4150, %EDX
	MOVL	$20, %ECX
	PUSHW	%DS
	POPW	%ES
	PUSHW	%DI
	INT	$0x15
	POPW	%DI
	JC	1f
	CMPL	$0x534d4150, %EAX
	JNE	1f
	MOVL	16(%DI), %EAX
	CMPL	$1, %EAX
	JE	4f
	CMPL	$3, %EAX
	JE	4f
	CMPL	$4, %EAX
	JNE	3f
4:	MOVL	(%DI), %EAX
	MOVL	4(%DI), %EDX
	ADDL	8(%DI), %EAX
	ADCL	12(%DI), %EDX
	JZ	3f
	SUBL	$1, %EAX
	SBBL	$0, %EDX
	JZ	3f
	MOVB	$1, HIGHMEM_PATCH - MEM_DESCR - 1(%DI)
	JMP	1f
3:	TESTL	%EBX, %EBX
	JNZ	2b
1:
	POPW	%ES
	POPAL

#	ADDL	%EBP, G_BASE - WHERE_AM_I(%BX)
	.BYTE	0x66, 0x01, 0xaf
	.WORD	G_BASE - WHERE_AM_I

#	LGDTL	GDTR - WHERE_AM_I(%BX)
	.BYTE	0x66, 0x0F, 0x01, 0x97
	.WORD	GDTR - WHERE_AM_I

	CMPL	$0, REALMODE_SWITCH - WHERE_AM_I(%BX)
	JZ	1f
	PUSHAL
	LCALL	*REALMODE_SWITCH - WHERE_AM_I(%BX)
	POPAL
1:

	PUSHFL
	POPL	%EAX
	ANDL	$~(EFLAGS_TF|EFLAGS_IF|EFLAGS_DF|EFLAGS_IOPL0|EFLAGS_IOPL1|EFLAGS_NT|EFLAGS_RF|EFLAGS_VM|EFLAGS_AC|EFLAGS_VIF|EFLAGS_VIP), %EAX
	PUSHL	%EAX
	POPFL

	# STOP FLOPPY DISK MOTOR
	TESTB	$0xF, %ES:0x3F
	JZ	1f
	MOVB	$0x0C, %AL
	MOVW	$0x03F2, %DX
	OUTB	%AL, %DX
1:
	MOVL	%CR0, %EAX
	# ANDL	$0x1FFBFFF1, %EAX
	# ORL	$0x00010021, %EAX
	ANDL	$~(CR0_EM|CR0_PG), %EAX
	ORL	$CR0_PE|CR0_MP|CR0_TS|CR0_NE|CR0_WP|CR0_AM, %EAX
	MOVL	%EAX, %CR0	# REAL MODE SUCKS - GET QUICKLY OUT OF IT

SM_CODE:
	LJMPL	$8, $PM - WHERE_AM_I

#DEBUG16:
#	MOVL	%EAX, %EDX
#	MOVW	$160, %BX
#	MOVW	$8, %CX
#WRN:	MOVL	%EDX, %EAX
#	SHRL	$28, %EAX
#	CMPB	$10, %AL
#	JB	NN
#	ADDB	$7, %AL
#NN:	ADDW	$0x7030, %AX
#	MOVW	%AX, %ES:(%BX)
#	SHLL	$4, %EDX
#	INCW	%BX
#	INCW	%BX
#	LOOP	WRN
#STOP:	JMP	STOP
#
.CODE32

#DEBUG32:
#	MOVL	%EAX, %EDX
#	MOVL	$0x000B80A0, %EBX
#	MOVL	$8, %ECX
#WRN32:	MOVL	%EDX, %EAX
#	SHRL	$28, %EAX
#	CMPB	$10, %AL
#	JB	NN32
#	ADDB	$7, %AL
#NN32:	ADDW	$0x7030, %AX
#	MOVW	%AX, (%EBX)
#	SHLL	$4, %EDX
#	INCL	%EBX
#	INCL	%EBX
#	LOOP	WRN32
#STOP32:	JMP	STOP32

PM:
	MOVW	$0x10, %AX
	MOVW	%AX, %DS
	MOVW	%AX, %ES
	MOVW	%AX, %SS
	MOVL	$SMP_TRAMPOLINE_STACK, %ESP

	CALL	EMPTY_8042
	MOVB	$0xD1, %AL
	OUTB	%AL, $0x64
	CALL	EMPTY_8042
	MOVB	$0xDF, %AL
	OUTB	%AL, $0x60
	CALL	EMPTY_8042

	INB	$0x92, %AL
	ORB	$0x02, %AL
	OUTB	%AL, $0x92

	MOVL	$0x200, %EBX
	MOVL	(%EBX), %ECX
	XORL	%EAX, %EAX
1:	INCL	%EAX
	MOVL	%EAX, (%EBX)
	WBINVD
	CMPL	0x100200, %EAX
	JE	1b
	MOVL	%ECX, (%EBX)

	MOVL	CODE32_START - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x100000, %EAX
	JE	1f
	MOVL	$0x100000, CODE32_START - WHERE_AM_I(%EBP)
	LEAL	PM - WHERE_AM_I(%EBP), %EDI
	JMP	*%EAX
1:

/* Loadlin somehow trashes low memory and BIOS calls don't work
   Except for this problem, SPAD could work with loadlin (I tried) */

	MOVB	TYPE_OF_LOADER - WHERE_AM_I(%EBP), %AL
	ANDB	$0xF0, %AL
	CMPB	$0x10, %AL
	LEAL	LOADLIN - WHERE_AM_I(%EBP), %EAX
	JE	XERROR

	MOVL	$0x100000 + JMP_BASE_OFFSET + EXTRA_BYTES, %ESI

	MOVL	-JMP_BASE_OFFSET-EXTRA_BYTES+OFFSET_LENGTH(%ESI), %ECX
	SHRL	$2, %ECX
	PUSHL	%ESI
	SUBL	$JMP_BASE_OFFSET, %ESI
	XORL	%EDX, %EDX
1:	LODSL
	ADCL	%EAX, %EDX
	LOOP	1b
	ADCL	$0, %EDX
	POPL	%ESI
	LEAL	BAD_CHECKSUM - WHERE_AM_I(%EBP), %EAX
	CMPL	%EDX, -JMP_BASE_OFFSET-EXTRA_BYTES+OFFSET_CHECKSUM(%ESI)
	JNZ	XERROR

	LEAL	CORRUPT_FSD - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x44415053, -JMP_BASE_OFFSET(%ESI)
	JNZ	XERROR
	LEAL	BAD_ARCH_FSD - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x32334149, -JMP_BASE_OFFSET + 8(%ESI)
	JNZ	XERROR

	LEAL	ERROR_SM - WHERE_AM_I - 4(%EBP), %EAX
	PUSHL	%EAX
	PUSHL	%EAX

	LEAL	FILE_NAME - WHERE_AM_I(%EBP), %EDX
	MOVL	$FSD_STAT_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	STAT_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	LEAL	- JMP_BASE_OFFSET - EXTRA_BYTES(%ESI, %EAX), %EDI
	ADDL	$3, %EDI
	ANDL	$~3, %EDI
	XCHGL	%EAX, %EBX
	MOVL	$FSD_TOP_OF_HEAP_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	TOP_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	LEAL	JMP_BASE_OFFSET + 3(%EAX), %ECX
	ANDL	$~3, %ECX
	SUBL	%ESI, %ECX
	LEAL	- JMP_BASE_OFFSET - 4(%ESI, %ECX), %ESI
	LEAL	-4(%EDI, %ECX), %EDI
	SHRL	$2, %ECX
	STD
	REP
	MOVSL
	CLD
	XCHGL	%ESI, %EDI
	.IF	4 <> EXTRA_BYTES
	ADDL	$4 - EXTRA_BYTES, %EDI
	.ENDIF
	ADDL	$JMP_BASE_OFFSET + 4, %ESI
	MOVL	$0x100000, %ECX
	LEAL	INTERNAL_ERROR - WHERE_AM_I(%EBP), %EAX
	CMPL	%ECX, %EDI
	JNE	XERROR
	LEAL	FILE_NAME - WHERE_AM_I(%EBP), %EDX
	MOVL	$FSD_OPEN_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	OPEN_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	MOVL	%EBX, %ECX
	MOVL	%EDI, %EDX
	MOVL	$FSD_READ_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	READ_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	TESTL	%EAX, %EAX
	JNZ	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	LEAL	CORRUPT_KERNEL - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x44415053, (%EDI)
	JNZ	XERROR
	LEAL	BAD_ARCH_KERNEL - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x32334149, 8(%EDI)
	JNZ	XERROR
	MOVL	$FSD_CLOSE_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	CLOSE_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	TESTL	%EAX, %EAX
	JNZ	ERROR
	POPL	%ECX
	POPL	%EDX
	MOVL	$FSD_TOP_OF_HEAP_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI		# EAX - HEAP TOP
	LEAL	TOP_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	XCHGL	%EAX, %ECX
	POPL	%EBX
	POPL	%EDX
	LEAL	-JMP_BASE_OFFSET(%ESI), %EDX
	MOVL	%EDI, %EAX
	ADDL	$JMP_BASE_OFFSET, %EDI
	PUSHL	$0
HIGHMEM_PATCH:
	CALL	*%EDI

EMPTY_8042:
	MOVL	$0x00FFFFFF, %ECX
EMPTY_8042_LOOP:
	INB	$0x64, %AL
	TESTB	$1, %AL
	JZ	NO_OUTPUT
	INB	$0x60, %AL
	JMP	EMPTY_8042_LP
NO_OUTPUT:
	TESTB	$2, %AL
EMPTY_8042_LP:
	LOOPNZ	EMPTY_8042_LOOP
RT:	RET

ERROR:	MOVL	%ECX, %ESI
	MOVB	$0x70, %AH
	CALL	PRINT1
	MOVL	$0, %ESI
ERROR_SM:
	CALL	PRINT
LOCK_UP:JMP	LOCK_UP

XERROR:	MOVL	%EAX, %ESI
	MOVB    $0x70, %AH
	CALL	PRINT1
	JMP	LOCK_UP

PRINT1:	MOVL	$0xB80A0, %EDI
	CMPB	$7, 0x449
	JNE	1f
	BTR	$15, %EDI
1:
PRINT:	LODSB
	TEST	%AL, %AL
	JZ	RT
	STOSW
	JMP	PRINT

VERSION:	.ASCII	"SPAD " SPAD_RELEASE " (" SPAD_VERSION ")"
		.BYTE	0
HIMEM_ERROR_MSG:.STRING	"BIOS CAN'T ACCESS HIGH MEMORY"
LOADLIN:	.STRING	"LOADLIN CAN'T BE USED TO LOAD THIS IMAGE"
BAD_CHECKSUM:	.STRING	"BAD CHECKSUM"
CORRUPT_FSD:	.STRING	"FSD IS NOT EXECUTABLE FILE"
BAD_ARCH_FSD:	.STRING	"FSD IS NOT FOR IA32"
TOP_ERROR_MSG:	.STRING	"COULD NOT GET TOP OF HEAD: "
FILE_NAME:	.STRING	"KERNEL.SYS"
STAT_ERROR_MSG:	.STRING	"ERROR GETTING LENGTH OF KERNEL.SYS: "
OPEN_ERROR_MSG:	.STRING	"ERROR OPENING KERNEL.SYS: "
READ_ERROR_MSG:	.STRING	"ERROR READING KERNEL.SYS: "
CLOSE_ERROR_MSG:.STRING	"ERROR CLOSING KERNEL.SYS: "
CORRUPT_KERNEL:	.STRING	"KERNEL.SYS IS NOT EXECUTABLE FILE"
BAD_ARCH_KERNEL:.STRING	"KERNEL.SYS IS NOT FOR IA32"
INTERNAL_ERROR:	.STRING	"INTERNAL ERROR - POINTER MISMATCH"

.ALIGN 8, 0
GDT:

GDTR:	.WORD	GDT_END - GDT - 1
G_BASE:	.LONG	GDT - WHERE_AM_I
	.WORD	0

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x9B
	.BYTE	0xCF, 0x00

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x93
	.BYTE	0xCF, 0x00
GDT_END:

MEM_DESCR:
	.LONG	0
	.LONG	0
	.LONG	0
	.LONG	0
	.LONG	0

.ALIGN 512,0
LOADER_END:
	JMP	*%EDI
	.ORG	LOADER_END + OFFSET_LENGTH
	.LONG	0
	.ORG	LOADER_END + OFFSET_CHECKSUM
	.LONG	0
	.ORG	LOADER_END + EXTRA_BYTES
