#ifndef __KERNEL_APICREG_H
#define __KERNEL_APICREG_H

#define LOCAL_APIC_REGSPACE		0x0800

#define LOCAL_APIC_ID			0x0020
#define  LOCAL_APIC_ID_ID			0xff000000
#define LOCAL_APIC_VERSION		0x0030
#define  LOCAL_APIC_VERSION_VERSION		0x000000ff
#define  LOCAL_APIC_VERSION_MAX_LVT_ENTRY	0x00ff0000
#define  LOCAL_APIC_VERSION_EXTENDED		0x80000000
#define LOCAL_APIC_TPR			0x0080
#define  LOCAL_APIC_TPR_MASK			0x000000ff
#define LOCAL_APIC_APR			0x0090
#define  LOCAL_APIC_APR_MASK			0x000000ff
#define LOCAL_APIC_PPR			0x00a0
#define LOCAL_APIC_EOI			0x00b0
#define  LOCAL_APIC_EOI_WRITE			0x00000000
#define LOCAL_APIC_LDR			0x00d0
#define  LOCAL_APIC_LDR_ID			0xff000000
#define LOCAL_APIC_DFR			0x00e0
#define  LOCAL_APIC_DFR_MODEL			0xf0000000
#define   LOCAL_APIC_DFR_MODEL_CLUSTER			0x00000000
#define   LOCAL_APIC_DFR_MODEL_FLAT			0xf0000000
#define LOCAL_APIC_SVR			0x00f0
#define  LOCAL_APIC_SVR_INTVEC_WIRED_1		0x0000000f
#define  LOCAL_APIC_SVR_INTVEC			0x000000f0
#define  LOCAL_APIC_SVR_ENABLE			0x00000100
#define  LOCAL_APIC_SVR_FOCUS_DISABLE		0x00000200
#define LOCAL_APIC_ISR			0x0100
#define LOCAL_APIC_ISR_STEP		0x0010
#define LOCAL_APIC_TMR			0x0180
#define LOCAL_APIC_TMR_STEP		0x0010
#define LOCAL_APIC_IRR			0x0200
#define LOCAL_APIC_IRR_STEP		0x0010
#define LOCAL_APIC_ESR			0x0280
#define  LOCAL_APIC_ESR_WRITE			0x00000000
#define  LOCAL_APIC_ESR_SEND_CHECKSUM_ERROR	0x00000001
#define  LOCAL_APIC_ESR_RECEIVE_CHECKSUM_ERROR	0x00000002
#define  LOCAL_APIC_ESR_SEND_ACCEPT_ERROR	0x00000004
#define  LOCAL_APIC_ESR_RECEIVE_ACCEPT_ERROR	0x00000008
#define  LOCAL_APIC_ESR_SEND_ILLEGAL_VECTOR	0x00000020
#define  LOCAL_APIC_ESR_RECEIVE_ILLEGAL_VECTOR	0x00000040
#define  LOCAL_APIC_ESR_ILLEGAL_REGISTER	0x00000080
#define LOCAL_APIC_LVT_CMCI		0x02f0
#define LOCAL_APIC_ICR0			0x0300
#define  LOCAL_APIC_ICR0_INTVEC			0x000000ff
#define  LOCAL_APIC_ICR0_DELMOD			0x00000700
#define   LOCAL_APIC_ICR0_DELMOD_FIXED			0x00000000
#define   LOCAL_APIC_ICR0_DELMOD_LOWEST			0x00000100
#define   LOCAL_APIC_ICR0_DELMOD_SMI			0x00000200
#define   LOCAL_APIC_ICR0_DELMOD_REMRD			0x00000300
#define   LOCAL_APIC_ICR0_DELMOD_NMI			0x00000400
#define   LOCAL_APIC_ICR0_DELMOD_INIT			0x00000500
#define   LOCAL_APIC_ICR0_DELMOD_STARTUP		0x00000600
#define   LOCAL_APIC_ICR0_DELMOD_EXTINT			0x00000700
#define  LOCAL_APIC_ICR0_DESTMOD		0x00000800
#define  LOCAL_APIC_ICR0_DELIVS			0x00001000
#define  LOCAL_APIC_ICR0_LEVEL			0x00004000
#define  LOCAL_APIC_ICR0_TRIGGER		0x00008000
#define  LOCAL_APIC_ICR0_SHORTHAND		0x000c0000
#define   LOCAL_APIC_ICR0_SHORTHAND_NO			0x00000000
#define   LOCAL_APIC_ICR0_SHORTHAND_SELF		0x00040000
#define   LOCAL_APIC_ICR0_SHORTHAND_ALL_INCL_SELF	0x00080000
#define   LOCAL_APIC_ICR0_SHORTHAND_ALL_EXCL_SELF	0x000c0000
#define LOCAL_APIC_ICR1			0x0310
#define  LOCAL_APIC_ICR1_DESTINATION_FIELD	0xff000000
#define LOCAL_APIC_LVT_TIMER		0x0320
#define LOCAL_APIC_LVT_THERMAL		0x0330
#define LOCAL_APIC_LVT_PERF_COUNT	0x0340
#define LOCAL_APIC_LVT_LINT0		0x0350
#define LOCAL_APIC_LVT_LINT1		0x0360
#define LOCAL_APIC_LVT_ERROR		0x0370
#define LOCAL_APIC_TIMER_INIT		0x0380
#define LOCAL_APIC_TIMER_CURRENT	0x0390
#define LOCAL_APIC_TIMER_DIVIDE		0x03e0
#define  LOCAL_APIC_TIMER_DIVIDE_MASK		0x0000000b
#define  LOCAL_APIC_TIMER_DIVIDE_2			0x00000000
#define  LOCAL_APIC_TIMER_DIVIDE_4			0x00000001
#define  LOCAL_APIC_TIMER_DIVIDE_8			0x00000002
#define  LOCAL_APIC_TIMER_DIVIDE_16			0x00000003
#define  LOCAL_APIC_TIMER_DIVIDE_32			0x00000008
#define  LOCAL_APIC_TIMER_DIVIDE_64			0x00000009
#define  LOCAL_APIC_TIMER_DIVIDE_128			0x0000000a
#define  LOCAL_APIC_TIMER_DIVIDE_1			0x0000000b

#define LOCAL_EXT_APIC_FEATURE		0x0400
#define  LOCAL_EXT_APIC_FEATURE_INC		0x00000001
#define  LOCAL_EXT_APIC_FEATURE_SNIC		0x00000002
#define  LOCAL_EXT_APIC_FEATURE_XAIDC		0x00000004
#define  LOCAL_EXT_APIC_FEATURE_XLC		0x00ff0000
#define LOCAL_EXT_APIC_CONTROL		0x0410
#define  LOCAL_EXT_APIC_CONTROL_IERN		0x00000001
#define  LOCAL_EXT_APIC_CONTROL_SN		0x00000002
#define  LOCAL_EXT_APIC_CONTROL_XAIDN		0x00000004
#define LOCAL_EXT_APIC_SEOI		0x0420
#define  LOCAL_EXT_APIC_SEOI_INTVEC		0x000000ff
#define LOCAL_EXT_APIC_IER		0x0480
#define LOCAL_EXT_APIC_IER_STEP		0x0010

#define  LOCAL_APIC_LVT_INTVEC			0x000000ff
#define  LOCAL_APIC_LVT_DELMOD			0x00000700
#define   LOCAL_APIC_LVT_DELMOD_FIXED			0x00000000
#define   LOCAL_APIC_LVT_DELMOD_SMI			0x00000200
#define   LOCAL_APIC_LVT_DELMOD_NMI			0x00000400
#define   LOCAL_APIC_LVT_DELMOD_INIT			0x00000500
#define   LOCAL_APIC_LVT_DELMOD_EXTINT			0x00000700
#define  LOCAL_APIC_LVT_DELIVS			0x00001000
#define  LOCAL_APIC_LVT_INTPOL			0x00002000
#define  LOCAL_APIC_LVT_REMOTE_IRR		0x00004000
#define  LOCAL_APIC_LVT_TRIGGER			0x00008000
#define  LOCAL_APIC_LVT_MASK			0x00010000
#define  LOCAL_APIC_LVT_TIMER_MODE		0x00020000

#define IO_APIC_REGSPACE		0x0020

#define IO_APIC_IOREGSEL		0x0000
#define IO_APIC_IOREGWIN		0x0010
#define IO_EXT_APIC_IRQ_PIN_ASSERTION	0x0020
#define IO_EXT_APIC_EOI			0x0040

#define IO_APIC_ID			0x0000
#define  IO_APIC_ID_ID				0xff000000
#define IO_APIC_VER			0x0001
#define  IO_APIC_VER_VERSION			0x000000ff
#define   IO_APIC_VER_VERSION_XAPIC			0x00000014
#define  IO_APIC_VER_PCI_IRQ			0x00008000
#define  IO_APIC_VER_MAX_ENTRY			0x00ff0000
#define IO_APIC_ARB			0x0002
#define  IO_APIC_ARB_ID				0x0f000000
#define IO_EXT_APIC_BOOT_CFG		0x0003
#define  IO_EXT_APIC_BOOT_CFG_FSB		0x00000001
#define IO_APIC_REDTBL0			0x0010
#define  IO_APIC_REDTBL0_INTVEC			0x000000ff
#define  IO_APIC_REDTBL0_DELMOD			0x00000700
#define   IO_APIC_REDTBL0_DELMOD_FIXED			0x00000000
#define   IO_APIC_REDTBL0_DELMOD_LOWEST			0x00000100
#define   IO_APIC_REDTBL0_DELMOD_SMI			0x00000200
#define   IO_APIC_REDTBL0_DELMOD_NMI			0x00000400
#define   IO_APIC_REDTBL0_DELMOD_INIT			0x00000500
#define   IO_APIC_REDTBL0_DELMOD_EXTINT			0x00000700
#define  IO_APIC_REDTBL0_DESTMOD		0x00000800
#define  IO_APIC_REDTBL0_DELIVS			0x00001000
#define  IO_APIC_REDTBL0_INTPOL			0x00002000
#define  IO_APIC_REDTBL0_REMOTE_IRR		0x00004000
#define  IO_APIC_REDTBL0_TRIGGER		0x00008000
#define  IO_APIC_REDTBL0_MASK			0x00010000
#define IO_APIC_REDTBL1			0x0011
#define  IO_APIC_REDTBL1_DESTINATION_FIELD	0xff000000
#define IO_APIC_REDTBL_STEP		0x0002

#endif
