#ifndef __KERNEL_ASM_H
#define __KERNEL_ASM_H

#include <ARCH/CPUDEF.H>
#include <ARCH/SETUP.H>
#include <ARCH/TIME.H>
#include <SPAD/VM.H>
#include <KERNEL/ASMDEF.H>
#include <KERNEL/PROC.H>
#include <SYS/TYPES.H>

void __NORET_ATTR__ VM_BOOT_ENABLE_PAGING(void *);

void __NORET_ATTR__ HALT_KERNEL(void);
void __NORET_ATTR__ HALT_KERNEL_STKDUMP(void);
void __NORET_ATTR__ HALT_CPU(void);

static __finline__ __NORET_ATTR__ void JMP_IDLE_LOOP(void)
{
	__asm__ volatile ("JMP IDLE_LOOP");
	while (1) ;
}

extern __u32 CR_0, CR_4;

extern __u64 IDT[];
extern __u64 IDT_END[];

extern __u64 GDTR;


typedef struct {
	char c[SIZEOF_I8259_IRQ_STUB];
} I8259_IRQ_TEMPLATE;

extern I8259_IRQ_TEMPLATE I8259_IRQ_STUBS[N_I8259_IRQS - 1];
extern I8259_IRQ_TEMPLATE I8259_AST_STUB_TEMPLATES[N_I8259_IRQS - 1];
extern I8259_IRQ_TEMPLATE I8259_RT_STUB_TEMPLATES[N_I8259_IRQS - 1];
extern unsigned I8259_AST_PATCHES[N_I8259_IRQS - 1];
extern unsigned I8259_RT_PTR_PATCHES[N_I8259_IRQS - 1];
extern unsigned I8259_RT_CALL_PATCHES[N_I8259_IRQS - 1];

extern char I8259_DISABLE_VECTORS[];
extern char I8259_ENABLE_VECTORS[];
extern char I8259_DISABLE_ENABLE_STRIDE[];

extern char I8259_MASK_IRQ_STUB[];
extern char I8259_MASK_IRQ_STUB_END[];
extern char I8259_UNMASK_IRQ_STUB[];
extern char I8259_UNMASK_IRQ_STUB_END[];

extern char I8259_PATCH_0[];
extern char I8259_PATCH_1[];
extern char I8259_PATCH_3[];
extern char I8259_PATCH_4[];
extern char I8259_PATCH_5[];
extern char I8259_PATCH_6[];
extern char I8259_PATCH_7[];
extern char I8259_PATCH_8[];
extern char I8259_PATCH_9[];
extern char I8259_PATCH_10[];
extern char I8259_PATCH_11[];
extern char I8259_PATCH_12[];
extern char I8259_PATCH_13[];
extern char I8259_PATCH_14[];
extern char I8259_PATCH_15[];

extern __u8 I8259MASK_1;
extern __u8 I8259MASK_2;

typedef struct {
	char c[SIZEOF_APIC_IRQ_STUB];
} APIC_IRQ_TEMPLATE;

extern char APIC_EOI_PATCH_1[];
extern char APIC_EOI_PATCH_2[];

extern const APIC_IRQ_TEMPLATE APIC_STUB_TEMPLATE;
extern APIC_IRQ_TEMPLATE APIC_IRQ_STUBS[];
extern APIC_IRQ_TEMPLATE APIC_IPI_STUBS[];
extern char APIC_STUB_PATCH_IRQ[];
extern char APIC_STUB_PATCH_JMP[];

extern char APIC_COMMON_IPI[];
extern char APIC_COMMON_RT[];
extern char APIC_COMMON_AST[];


extern char APAGE[];
extern char KPAGE[];
extern char TSS_PAGE[];
extern struct {
	__u16 limit;
	__u16 base_lo;
	__u16 base_hi;
	__u16 pad;
} IDTR;


unsigned long PROC_HANDLE_XCPT(PROC *proc);
unsigned long PROC_POST_TIMER(PROC *proc);

unsigned long PROC_POST_AST(PROC *proc, IORQ *ast);
unsigned long PROC_POST_IO(PROC *proc, IORQ *ast, long status);

unsigned long PROC_POST_SIO(PROC *p, IORQ *usiorq, SIORQ *ksiorq);
unsigned long PROC_POST_AIO(PROC *p, IORQ *uaiorq, AIORQ *kaiorq);
unsigned long PROC_POST_IOCTL(PROC *p, IORQ *uciorq, IOCTLRQ *kciorq);

unsigned long PROC_GET_SIO(PROC *p, IORQ *usiorq, SIORQ *ksiorq);
unsigned long PROC_GET_AIO(PROC *p, IORQ *uaiorq, AIORQ *kaiorq);
unsigned long PROC_GET_IOCTL(PROC *p, IORQ *uciorq, IOCTLRQ *kciorq);

static __finline__ void LOCKDOWN_PROC(void)
{
	PROC_CURRENT_LOCK++;
	__barrier();
}

static __finline__ void UNLOCKDOWN_PROC(void)
{
	__barrier();
	if (__likely(!--PROC_CURRENT_LOCK)) WQ_WAKE_ALL(&PROC_CURRENT_LOCK_WAIT);
#if __DEBUG >= 1
	if (__unlikely(PROC_CURRENT_LOCK < 0))
		KERNEL$SUICIDE("UNLOCKDOWN_PROC: PROC_CURRENT_LOCK UNDERFLOW (%d)", PROC_CURRENT_LOCK);
#endif
}

#endif
