#include <ARCH/SETUP.H>
#include <KERNEL/DEV_OFF.H>
#include <KERNEL/VMDEF.H>
#include <ARCH/TIMEDEF.H>

	.SECTION .data
	.ALIGN	4
	.GLOBAL	KERNEL$DUMMY_IORQ
KERNEL$DUMMY_IORQ:
	.LONG	KERNEL$PROCESS_PENDING_AST
	.LONG	KERNEL$PROCESS_PENDING_AST
	.LONG	0
	.LONG	0
	.LONG	0

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$SUCCESS
KERNEL$SUCCESS:
	MOVL	$0, OFF_IORQ_status(%EAX)
	JMP	*(%EAX)

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	dlsym
dlsym:	MOVL	(%ESP), %ECX
	JMP	__dlsym

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	GET_TIME_SEC
GET_TIME_SEC:
	MOVL	USER_JIFFIES, %EAX
	MOVL	USER_JIFFIES + 4, %EDX
	CMPL	USER_JIFFIES, %EAX
	JNZ,pn	GET_TIME_SEC
	SHRDL	$JIFFIES_PER_SECOND_BITS, %EDX, %EAX
	SHRL	$JIFFIES_PER_SECOND_BITS, %EDX
	RET

	.GLOBAL	KERNEL$__PAGES_PER_CLUSTER_BITS
KERNEL$__PAGES_PER_CLUSTER_BITS = PG_CLUSTER_BITS

	.GLOBAL	KERNEL$__PAGES_PER_CLUSTER
KERNEL$__PAGES_PER_CLUSTER = 1 << PG_CLUSTER_BITS

	.GLOBAL	KERNEL$__PAGE_CLUSTER_BITS
KERNEL$__PAGE_CLUSTER_BITS = PG_SIZE_BITS + PG_CLUSTER_BITS

	.GLOBAL	KERNEL$__PAGE_CLUSTER_SIZE
KERNEL$__PAGE_CLUSTER_SIZE = PAGE_CLUSTER_SIZE

	.GLOBAL	KERNEL$__PAGE_CLUSTER_SIZE_MINUS_1
KERNEL$__PAGE_CLUSTER_SIZE_MINUS_1 = PAGE_CLUSTER_SIZE - 1

	.GLOBAL	KERNEL$__NOT_PAGE_CLUSTER_SIZE_MINUS_1
KERNEL$__NOT_PAGE_CLUSTER_SIZE_MINUS_1 = ~(PAGE_CLUSTER_SIZE - 1)

	.GLOBAL	KERNEL$__PAGE_CLUSTER_SIZE_DIV_SIZEOF_POINTER
KERNEL$__PAGE_CLUSTER_SIZE_DIV_SIZEOF_POINTER = PAGE_CLUSTER_SIZE / 4

	.GLOBAL	KERNEL$__PAGE_CLUSTER_SIZE_DIV_SIZEOF_POINTER_MINUS_1
KERNEL$__PAGE_CLUSTER_SIZE_DIV_SIZEOF_POINTER_MINUS_1 = PAGE_CLUSTER_SIZE / 4 - 1

	.GLOBAL	KERNEL$__SECTORS_PER_PAGE_CLUSTER_BITS
KERNEL$__SECTORS_PER_PAGE_CLUSTER_BITS = PG_SIZE_BITS + PG_CLUSTER_BITS - 9

	.GLOBAL	KERNEL$__SECTORS_PER_PAGE_CLUSTER
KERNEL$__SECTORS_PER_PAGE_CLUSTER = PAGE_CLUSTER_SIZE / 512

	.GLOBAL	KERNEL$__SECTORS_PER_PAGE_CLUSTER_MINUS_1
KERNEL$__SECTORS_PER_PAGE_CLUSTER_MINUS_1 = PAGE_CLUSTER_SIZE / 512 - 1
