#ifndef __KERNEL_ASMDEF_H
#define __KERNEL_ASMDEF_H

#include <ARCH/CPUDEF.H>
#include <ARCH/SETUP.H>

#define N_I8259_IRQS		16
#define SIZEOF_I8259_IRQ_STUB 	48
#define SIZEOF_APIC_IRQ_STUB 	12

#define SPURIOUS_INT	0x0f
#define SYSCALL_INT	0x14
#define MIN_IRQ_INT	0x15
#define I8259_IRQ_INT	0x18
#define MAX_IRQ_INT	0xcf
#define IPI_AST		0xd0
#define IPI_HALT	0xf0
#define MIN_IPI_INT	0xd0
#define MAX_IPI_INT	0xf0

#define OFF___irq_handle_mask_count	0
#define OFF___irq_handle_irq_flags	1
#define OFF___irq_handle_data		8
#define OFF___irq_handle_call		12

#define IRQ_FLAGS_POLARITY_LOW	1
#define IRQ_FLAGS_TRIGGER_LEVEL	2
#define IRQ_FLAGS_MISSED_EDGE	4

#define SMALL_WHEEL_BITS	9
#define BIG_WHEEL_BITS		8

#define SMALL_WHEEL_SIZE	(1 << SMALL_WHEEL_BITS)
#define BIG_WHEEL_SIZE		(1 << BIG_WHEEL_BITS)

#define SYSCALL_SHIFT	24
#define N_SYSCALLS	(1 << (32 - SYSCALL_SHIFT))

#define EFLAGS_LEAVE	(EFLAGS_CF | EFLAGS_PF | EFLAGS_AF | EFLAGS_ZF | EFLAGS_SF | EFLAGS_TF | EFLAGS_DF | EFLAGS_OF | EFLAGS_RF | EFLAGS_AC | EFLAGS_ID)
#define EFLAGS_SET	(EFLAGS_ONE | EFLAGS_IF)

#define SMP_TRAMPOLINE_STACK		ADDR_SMP_STUB
#define SMP_TRAMPOLINE_PHYS		ADDR_SMP_STUB
#define SMP_SEMAPHORE_1_PHYS		ADDR_SMP_STUB_END - 0x01
#define SMP_SEMAPHORE_1_VAL_STARTED	0x01
#define SMP_SEMAPHORE_1_VAL_HALTED	0x02
#define SMP_SEMAPHORE_1_VAL_RUNNING	0x03
#define SMP_SEMAPHORE_1_VAL_STOPPED	0xfd
#define SMP_SEMAPHORE_1_VAL_PANIC	0xfe
#define SMP_SEMAPHORE_2_PHYS		ADDR_SMP_STUB_END - 0x02
#define SMP_SEMAPHORE_2_VAL_GO		0x80
#define SMP_SEMAPHORE_2_VAL_HALT	0x81
#define SMP_TRAMPOLINE_JMP		ADDR_SMP_STUB_END - 0x08
#define SMP_TRAMPOLINE_GDTR		ADDR_SMP_STUB_END - 0x10
#define SMP_TRAMPOLINE_CR4		ADDR_SMP_STUB_END - 0x14
#define SMP_TRAMPOLINE_CR3		ADDR_SMP_STUB_END - 0x18
#define SMP_TRAMPOLINE_CR0		ADDR_SMP_STUB_END - 0x1c
#define SMP_FIND_SHARED			ADDR_SMP_STUB_END - 0x20
#define SMP_CPU_ID			ADDR_SMP_STUB_END - 0x24
#define SMP_CODE			ADDR_SMP_STUB_END - 0x28

#endif
