#include <SPAD/LIBC.H>
#include <SYS/PARAM.H>
#include <KERNEL/ASM.H>
#include <KERNEL/FSDLDR.H>

#include <KERNEL/BOOTCFG.H>

static struct bootcfg BOOTCFG_MAIN;
struct bootcfg *BOOTCFG = &BOOTCFG_MAIN;

static const struct __param_table pse_params[3] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_PSE_AUTO,
	"DISABLE", __PARAM_BOOL, ~0, PARAM_PSE_DISABLE,
	NULL, 0, 0, 0
};

static void *const pse_vars[3] = {
	&BOOTCFG_MAIN.PARAM_PSE,
	&BOOTCFG_MAIN.PARAM_PSE,
	NULL
};

static const struct __param_table pge_params[4] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_PGE_AUTO,
	"DISABLE", __PARAM_BOOL, ~0, PARAM_PGE_DISABLE,
	"ENABLE", __PARAM_BOOL, ~0, PARAM_PGE_ENABLE,
	NULL, 0, 0, 0
};

static void *const pge_vars[4] = {
	&BOOTCFG_MAIN.PARAM_PGE,
	&BOOTCFG_MAIN.PARAM_PGE,
	&BOOTCFG_MAIN.PARAM_PGE,
	NULL
};

static const struct __param_table pae_params[4] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_PAE_AUTO,
	"DISABLE", __PARAM_BOOL, ~0, PARAM_PAE_DISABLE,
	"ENABLE", __PARAM_BOOL, ~0, PARAM_PAE_ENABLE,
	NULL, 0, 0, 0
};

static void *const pae_vars[4] = {
	&BOOTCFG_MAIN.PARAM_PAE,
	&BOOTCFG_MAIN.PARAM_PAE,
	&BOOTCFG_MAIN.PARAM_PAE,
	NULL
};

static const struct __param_table syscall_params[5] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_SYSCALL_AUTO,
	"INTEL", __PARAM_BOOL, ~0, PARAM_SYSCALL_INTEL,
	"AMD", __PARAM_BOOL, ~0, PARAM_SYSCALL_AMD,
	"INT", __PARAM_BOOL, ~0, PARAM_SYSCALL_INT,
	NULL, 0, 0, 0
};

static void *const syscall_vars[5] = {
	&BOOTCFG_MAIN.PARAM_SYSCALL,
	&BOOTCFG_MAIN.PARAM_SYSCALL,
	&BOOTCFG_MAIN.PARAM_SYSCALL,
	&BOOTCFG_MAIN.PARAM_SYSCALL,
	NULL
};

static const struct __param_table up_apic_params[4] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_UP_APIC_AUTO,
	"DISABLE", __PARAM_BOOL, ~0, PARAM_UP_APIC_DISABLE,
	"ENABLE", __PARAM_BOOL, ~0, PARAM_UP_APIC_ENABLE,
	NULL, 0, 0, 0
};

static void *const up_apic_vars[4] = {
	&BOOTCFG_MAIN.PARAM_UP_APIC,
	&BOOTCFG_MAIN.PARAM_UP_APIC,
	&BOOTCFG_MAIN.PARAM_UP_APIC,
	NULL
};

static const struct __param_table smp_params[3] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_SMP_AUTO,
	"DISABLE", __PARAM_BOOL, ~0, PARAM_SMP_DISABLE,
	NULL, 0, 0, 0
};

static void *const smp_vars[4] = {
	&BOOTCFG_MAIN.PARAM_SMP,
	&BOOTCFG_MAIN.PARAM_SMP,
	NULL
};

static const struct __param_table cache_probe_params[4] = {
	"AUTO", __PARAM_BOOL, ~0, PARAM_UP_APIC_AUTO,
	"DISABLE", __PARAM_BOOL, ~0, PARAM_UP_APIC_DISABLE,
	"ENABLE", __PARAM_BOOL, ~0, PARAM_UP_APIC_ENABLE,
	NULL, 0, 0, 0
};

static void *const cache_probe_vars[4] = {
	&BOOTCFG_MAIN.PARAM_CACHE_PROBE,
	&BOOTCFG_MAIN.PARAM_CACHE_PROBE,
	&BOOTCFG_MAIN.PARAM_CACHE_PROBE,
	NULL
};

static const struct __param_table params[9] = {
	"TICK", __PARAM_UNSIGNED_INT, 16, 65537,
	"PSE", __PARAM_EXTD_ONE, (long)&pse_params, NULL,
	"PGE", __PARAM_EXTD_ONE, (long)&pge_params, NULL,
	"PAE", __PARAM_EXTD_ONE, (long)&pae_params, NULL,
	"SYSCALL", __PARAM_EXTD_ONE, (long)&syscall_params, NULL,
	"UP_APIC", __PARAM_EXTD_ONE, (long)&up_apic_params, NULL,
	"SMP", __PARAM_EXTD_ONE, (long)&smp_params, NULL,
	"CACHE_PROBE", __PARAM_EXTD_ONE, (long)&cache_probe_params, NULL,
	NULL, 0, 0, 0
};

static void *const vars[9] = {
	&BOOTCFG_MAIN.PARAM_TICK,
	&pse_vars,
	&pge_vars,
	&pae_vars,
	&syscall_vars,
	&up_apic_vars,
	&smp_vars,
	&cache_probe_vars,
	NULL
};

static void PROCESS_LINE(const char *line)
{
	char error[__MAX_STR_LEN];
	int state = __STATE_EXT_NOSEP;
	const char *arg = line;
	if (!_memcasecmp(line, "REM", 3) && (!line[3] || line[3] == ' '))
		return;
	if (__parse_extd_param(&arg, &state, params, vars, NULL, NULL, NULL, NULL)) {
		_snprintf(error, sizeof error, "INVALID LINE: %s", line);
		BOOT_FAIL(error);
	}
	/*
	static short *p = (short *)0xb8140;
	while (*line)
		*p++ = *line++ | 0x7000;
	p += 2;
	*/
}

static void DEFAULTS(void)
{
	BOOTCFG->PARAM_TICK = 256;
	BOOTCFG->PARAM_PAE = PARAM_PAE_AUTO;
	BOOTCFG->PARAM_SYSCALL = PARAM_SYSCALL_AUTO;
	BOOTCFG->PARAM_UP_APIC = PARAM_UP_APIC_AUTO;
	BOOTCFG->PARAM_SMP = PARAM_SMP_AUTO;
}

void LOAD_CONFIG_KRN(void)
{
	char error[__MAX_STR_LEN];
	char string[__MAX_STR_LEN];
	size_t slen;

	DEFAULTS();
	
	slen = 0;

	long len = FSD_OPEN("CONFIG.KRN", NULL);
	if (len < 0)
		return;

	while (len) {
		char *le;
		size_t idx, leen;
		size_t l = MIN(sizeof(string) - slen, len);

		if (FSD_READ(string + slen, l, error))
			BOOT_FAIL(error);

		len -= l, slen += l;
		idx = 0;

		if (memchr(string, 0, slen))
			BOOT_FAIL("CONFIG.KRN CONTAINS NULL CHARACTER");

		next_line:
		le = memchr(string + idx, '\n', slen);
		if (!le) {
			if (slen == sizeof(string))
				BOOT_FAIL("A LONG LINE IN CONFIG.KRN");
			if (idx) {
				memmove(string, string + idx, slen);
				idx = 0;
			}
			if (len)
				continue;
			if (!slen)
				break;
			le = string + idx + slen++;
		}
		*le = 0;
		leen = le - (string + idx) + 1;
		PROCESS_LINE(string + idx);
		idx += leen;
		slen -= leen;
		goto next_line;
	}

	if (FSD_CLOSE(error))
		BOOT_FAIL(error);
}
