#ifndef __KERNEL_BOOTCFG_H
#define __KERNEL_BOOTCFG_H

#include <SYS/TYPES.H>

void BOOT_FAIL(const char *s) __NORET_ATTR__;

void LOAD_CONFIG_KRN(void);

extern struct bootcfg {
	unsigned PARAM_TICK;
	unsigned PARAM_PSE;
	unsigned PARAM_PGE;
	unsigned PARAM_PAE;
	unsigned PARAM_SYSCALL;
	unsigned PARAM_UP_APIC;
	unsigned PARAM_SMP;
	unsigned PARAM_CACHE_PROBE;
} *BOOTCFG;

#define PARAM_SYSCALL_AUTO	0
#define PARAM_SYSCALL_INTEL	1
#define PARAM_SYSCALL_AMD	2
#define PARAM_SYSCALL_INT	3

#define PARAM_PSE_AUTO		0
#define PARAM_PSE_DISABLE	1

#define PARAM_PGE_AUTO		0
#define PARAM_PGE_DISABLE	1
#define PARAM_PGE_ENABLE	2

#define PARAM_PAE_AUTO		0
#define PARAM_PAE_DISABLE	1
#define PARAM_PAE_ENABLE	2

#define PARAM_UP_APIC_AUTO	0
#define PARAM_UP_APIC_DISABLE	1
#define PARAM_UP_APIC_ENABLE	2

#define PARAM_SMP_AUTO		0
#define PARAM_SMP_DISABLE	1

#define PARAM_CACHE_PROBE_AUTO	0
#define PARAM_CACHE_PROBE_DISABLE 1
#define PARAM_CACHE_PROBE_ENABLE 2

#endif
