#ifndef __KERNEL_IRQARCH_H
#define __KERNEL_IRQARCH_H

int APIC_IRQ_INIT(void);
void I8259_IRQ_INIT(void);

void I8259_HW_INIT(unsigned vec1, unsigned vec2);

unsigned read_4bytes(char *p);
void write_4bytes(char *p, unsigned v);
void set_idt_gate(unsigned intr, void *addr);

#if __KERNEL_SUPPORT_SMP
void BOOT_APS(void);
void STOP_OTHER_CPUS(void);
void APIC_INIT_AP2(void);
#else
static __finline__ void BOOT_APS(void) {}
static __finline__ void STOP_OTHER_CPUS(void) {}
#endif

#endif
