#include <ARCH/CPUDEF.H>
#include <KERNEL/UDATADEF.H>
#include <KERNEL/DEV.H>
#include <SIGNAL.H>
#include <SPAD/LIBC.H>

const char *__strexception(int except)
{
	static char excmsg[__MAX_STR_LEN];
	switch (except) {
		case XCPT_DE: return "DIVIDE ERROR";
		case XCPT_DB: return "DEBUG";
		case XCPT_NMI: return "NMI";
		case XCPT_BP: return "BREAKPOINT";
		case XCPT_OF: return "OVERFLOW";
		case XCPT_BR: return "RANGE EXCEEDED";
		case XCPT_UD: return "INVALID INSTRUCTION";
		case XCPT_NM: return "DEVICE NOT AVAILABLE";
		case XCPT_DF: return "DOUBLE FAULT";
		case XCPT_CSO: return "COPROCESSOR SEGMENT OVERRUN";
		case XCPT_TS: return "INVALID TSS";
		case XCPT_NP: return "SEGMENT NOT PRESENT";
		case XCPT_SS: return "STACK FAULT";
		case XCPT_GP: return "GENERAL PROTECTION FAULT";
		case XCPT_PF: return "PAGE FAULT";
		case XCPT_MF: return "FLOATING-POINT ERROR";
		case XCPT_AC: return "ALIGNMENT CHECK";
		case XCPT_MC: return "MACHINE CHECK";
		case XCPT_XF: return "SIMD FLOATING-POINT ERROR";

		case XCPT_RPF: return "READ PAGE FAULT";
		case XCPT_WPF: return "WRITE PAGE FAULT";

		default: _snprintf(excmsg, __MAX_STR_LEN, "UNKNOWN EXCEPTION %d", except);
			return excmsg;
	}
}

int __exception2signal(int except)
{
	switch (except) {
		case XCPT_DE: return SIGFPE;
		case XCPT_DB: return SIGTRAP;
		case XCPT_NMI: return 0;
		case XCPT_BP: return SIGTRAP;
		case XCPT_OF: return SIGIOT;
		case XCPT_BR: return SIGIOT;
		case XCPT_UD: return SIGILL;
		case XCPT_NM: return 0;
		case XCPT_DF: return 0;
		case XCPT_CSO: return 0;
		case XCPT_TS: return 0;
		case XCPT_NP: return SIGBUS;
		case XCPT_SS: return SIGSEGV;
		case XCPT_GP: return SIGSEGV;
		case XCPT_PF: return SIGSEGV;
		case XCPT_MF: return SIGFPE;
		case XCPT_AC: return SIGBUS;
		case XCPT_MC: return SIGMCE;
		case XCPT_XF: return SIGFPE;

		case XCPT_RPF: return SIGSEGV;
		case XCPT_WPF: return SIGSEGV;

		default: return SIGBUS;
	}
}

void SUSPEND_KERNEL_AST(IORQ *rq)
{
	long t;
	t = rq->tmp3;
#if __DEBUG >= 1
	if (__unlikely(t != -1)) KERNEL$SUICIDE("SUSPEND_KERNEL_AST: INVALID TMP3, TMP3 %08lX", t);
#endif
	rq->tmp3 = -2;
}

void RESUME_KERNEL_AST(IORQ *rq)
{
	long t;
	retry:
	t = rq->tmp3;
#if __DEBUG >= 1
	if (__unlikely(t != -2) && __unlikely(t != -3))
		KERNEL$SUICIDE("RESUME_KERNEL_AST: AST NOT SUSPENDED, TMP3 %08lX", t);
#endif
	if (__unlikely(__CMPXCHGL((long *)&rq->tmp3, t, -1) != 0)) goto retry;
	if (t == -3) CALL_AST(rq);
}

