#include <SPAD/LINK.H>
#include <ARCH/CPU.H>
#include <SYS/TYPES.H>
#include <KERNEL/SEG.H>
#include <ARCH/SETUP.H>

static __finline__ void arch_init_udata(PROC_CONTROL_BLOCK *pcb, unsigned long bootstrap_code)
{
	*(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_EIP)] = bootstrap_code + JMP_BASE_OFFSET;
	*(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_CS)] = SEG_UCODE;
	*(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_SS)] = SEG_USTACK;
	*(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_DS)] = SEG_UDATA + (SEG_UDATA << 16);
#if __DEBUG_LDT
	*(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_LDT)] = *(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT + OFF_UDATA_base)];
#endif
	INIT_FPU(&pcb->init_page[UDATA_PAGE(UDATA_COPROCESSOR)], 0);
}

static __finline__ void arch_set_stack(PROC_CONTROL_BLOCK *pcb, unsigned long data_bottom)
{
	*(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_ESP)] = *(__u32 *)&pcb->init_page[UDATA_PAGE(UDATA_ORIG_ESP)] = data_bottom;
}

#define arch_set_stack_bottom	(UDATA_PAGE(UDATA_ESP))
#define arch_set_stack_top	(UDATA_PAGE(UDATA_ESP) + 4)

