#ifndef __KERNEL_MPS_H
#define __KERNEL_MPS_H

#include "MPSTBL.H"

extern __cpu_id_t CPU_ID;
extern __cpu_id_t CPU_ID_LIMIT;
extern __node_id_t NODE_ID;
extern __node_id_t NODE_ID_LIMIT;

__u8 MPS_CHECKSUM(const void *ptrv, size_t len);

void MPS_DETECT(void);
void MPS_INIT(void);

extern MP_FLOATING_POINTER *MPS_FP;
extern unsigned MPS_FP_SIZE;
extern MP_TABLE *MPS_TABLE;
extern unsigned MPS_TABLE_SIZE;

void MPS_FIND_RESET(__u8 type);
void *MPS_FIND_ENTRY(void);
int MPS_DEFAULT(void);

#endif
