#ifndef __KERNEL_MPSTBL_H
#define __KERNEL_MPSTBL_H

#include <SYS/TYPES.H>

typedef struct {
	__u8 signature[4];
	__u32 mp_table;
	__u8 fp_length;
	__u8 revision;
	__u8 checksum;
	__u8 default_cfg;
	__u32 features;
} MP_FLOATING_POINTER;

#define MP_FP_SIGNATURE				"_MP_"
#define MP_FP_FEATURES_IMCRP			0x80
#define MP_FP_DEFAULT_CFG_82489_ISA		1
#define MP_FP_DEFAULT_CFG_82489_EISA_NOIRQ0	2
#define MP_FP_DEFAULT_CFG_82489_EISA		3
#define MP_FP_DEFAULT_CFG_82489_MCA		4
#define MP_FP_DEFAULT_CFG_INTEGRATED_ISA_PCI	5
#define MP_FP_DEFAULT_CFG_INTEGRATED_EISA_PCI	6
#define MP_FP_DEFAULT_CFG_INTEGRATED_MCA_PCI	7

typedef struct {
	__u8 signature[4];
	__u16 base_length;
	__u8 revision;
	__u8 checksum;
	__u8 oem_id[8];
	__u8 prod_id[12];
	__u32 oem_ptr;
	__u16 oem_size;
	__u16 entry_count;
	__u32 local_apic_addr;
	__u16 ext_length;
	__u8 ext_checksum;
	__u8 pad;
} MP_TABLE;

#define MP_T_SIGNATURE			"PCMP"

#define MP_ENTRY_TYPE_PROCESSOR		0
#define MP_ENTRY_TYPE_BUS		1
#define MP_ENTRY_TYPE_IO_APIC		2
#define MP_ENTRY_TYPE_IO_INTERRUPT	3
#define MP_ENTRY_TYPE_LOCAL_INTERRUPT	4

typedef struct {
	__u8 type;
	__u8 local_apic_id;
	__u8 local_apic_version;
	__u8 flags;
	__u32 signature;
	__u32 features;
	__u32 pad1;
	__u32 pad2;
} MP_PROCESSOR;

#define MP_PROCESSOR_FLAGS_EN		0x01
#define MP_PROCESSOR_FLAGS_BP		0x02

typedef struct {
	__u8 type;
	__u8 bus_id;
	__u8 string[6];
} MP_BUS;

typedef struct {
	__u8 type;
	__u8 io_apic_id;
	__u8 io_apic_version;
	__u8 flags;
	__u32 io_apic_addr;
} MP_IO_APIC;

#define MP_IO_APIC_FLAGS_EN		0x01

typedef struct {
	__u8 type;
	__u8 interrupt_type;
	__u8 flags;
	__u8 pad;
	__u8 source_bus_id;
	__u8 source_bus_irq;
	__u8 dest_io_apic_id;
	__u8 dest_io_apic_pin;
} MP_IO_INTERRUPT;

#define MP_INTERRUPT_TYPE_INT			0x00
#define MP_INTERRUPT_TYPE_NMI			0x01
#define MP_INTERRUPT_TYPE_SMI			0x02
#define MP_INTERRUPT_TYPE_EXTINT		0x03

#define MP_INTERRUPT_FLAGS_PO			0x03
#define  MP_INTERRUPT_FLAGS_PO_DEFAULT			0x00
#define  MP_INTERRUPT_FLAGS_PO_HIGH			0x01
#define  MP_INTERRUPT_FLAGS_PO_INVALID			0x02
#define  MP_INTERRUPT_FLAGS_PO_LOW			0x03
#define MP_INTERRUPT_FLAGS_TRIGGER		0x0c
#define  MP_INTERRUPT_FLAGS_TRIGGER_DEFAULT		0x00
#define  MP_INTERRUPT_FLAGS_TRIGGER_EDGE		0x04
#define  MP_INTERRUPT_FLAGS_TRIGGER_INVALID		0x08
#define  MP_INTERRUPT_FLAGS_TRIGGER_LEVEL		0x0c

#define MP_INTERRUPT_SOURCE_BIS_IRQ_PCI_PIN	0x03
#define MP_INTERRUPT_SOURCE_BIS_IRQ_PCI_DEVICE	0x7c

typedef struct {
	__u8 type;
	__u8 interrupt_type;
	__u8 flags;
	__u8 pad;
	__u8 source_bus_id;
	__u8 source_bus_irq;
	__u8 dest_local_apic_id;
	__u8 dest_local_apic_pin;
} MP_LOCAL_INTERRUPT;

#endif
