#include <SPAD/VM.H>
#include <ARCH/SETUP.H>
#include <KERNEL/THREAD_A.H>
#include <SYS/TYPES.H>

typedef struct ___thread THREAD;

struct ___thread {
	THREAD_ENTRIES_1;
	void *esp;
	THREAD_ENTRIES_2;
};

extern THREAD MAIN_THREAD;

void BLOCK_THREAD(THREAD *t);	/* t must be CURRENT_THREAD() */
void RUN_THREAD(THREAD *t);
void END_THREAD(THREAD *t, THREAD_RQ *rq, void *thread);
static void START_THREAD(void);

static __finline__ THREAD *ALLOC_THREAD_STRUCT(void)
{
	return KERNEL$ALLOC_KERNEL_PAGE(VM_TYPE_WIRED_MAPPED);
}

static __finline__ void FREE_THREAD_STRUCT(THREAD *t)
{
	KERNEL$FREE_KERNEL_PAGE(t, VM_TYPE_WIRED_MAPPED);
}

static __finline__ void INIT_THREAD_STRUCT(THREAD *t)
{
	t->esp = (char *)t + PAGE_CLUSTER_SIZE - __CPU_MAX_ALIGN - 20;
	*((void **)t->esp + 4) = &START_THREAD;
}

static __finline__ THREAD *__attribute__((const)) CURRENT_THREAD(void)
{
	/*	GCC does not honour `const' attribute when register variable in esp
	const register unsigned long p __asm__("esp");
	return (THREAD *)(p & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
	*/
	unsigned long p;
	__asm__ ("MOVL %%ESP, %0": "=g"(p));
	return (THREAD *)(p & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
}

static __finline__ THREAD *RQ_THREAD(IORQ *rq)
{
	return (THREAD *)((unsigned long)rq & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
}

static __finline__ void MD_THREAD_INIT(void)
{
	if (THREAD_ESP != (int)(unsigned long)&((THREAD *)NULL)->esp) KERNEL$SUICIDE("MD_THREAD_INIT: THREAD_ESP == %d, SHOULD BE %d", THREAD_ESP, (int)(unsigned long)&((THREAD *)NULL)->esp);
}
