#include <ARCH/SETUP.H>
#include <KERNEL/THREAD_A.H>
#include <SPAD/SPLDEF.H>
#include <SPAD/VMDEF.H>

/*
 * IN: %EAX - POINTER TO CURRENT THREAD
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL BLOCK_THREAD
BLOCK_THREAD:
	PUSHL	%EBX
	PUSHL	%ESI
	PUSHL	%EDI
	PUSHL	%EBP
#if __DEBUG >= 1
	CMPL	$MAIN_THREAD, %EAX
	JE	MAIN_BLOCKED
#endif
	MOVL	%ESP, THREAD_ESP(%EAX)
	MOVL	MAIN_THREAD + THREAD_ESP, %ESP
POP_REGS:
	POPL	%EBP
	POPL	%EDI
	POPL	%ESI
	POPL	%EBX
	RET

/*
 * IN: %EAX - POINTER TO THREAD TO BE UNBLOCKED
 *		IT MUST BE CALLED FROM MAIN THREAD
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL RUN_THREAD
RUN_THREAD:
	PUSHL	%EBX
	PUSHL	%ESI
	PUSHL	%EDI
	PUSHL	%EBP
	MOVL	%ESP, MAIN_THREAD + THREAD_ESP
	MOVL	THREAD_ESP(%EAX), %ESP
	POPL	%EBP
	POPL	%EDI
	POPL	%ESI
	POPL	%EBX
	RET

/*
 * IN: %EAX - CURRENT THREAD
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL END_THREAD
END_THREAD:
	MOVL	MAIN_THREAD + THREAD_ESP, %ESP
	MOVL	KERNEL$SPL, %ESI
	MOVL	%EAX, %EDI
	MOVL	%EDX, %EAX
	MOVL	%ECX, %EBP
	CALL	*(%EAX)
	TESTL	%EBP, %EBP
#ifndef __NO_ASM_PREDICTIONS
	JNZ,pn	POP_REGS
#else
	JNZ	POP_REGS
#endif
	MOVL	%EDI, %EAX
	MOVL	$VM_TYPE_WIRED_MAPPED, %EDX
	CALL	KERNEL$FREE_KERNEL_PAGE
	JMP	POP_REGS

#if __DEBUG >= 1
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
MAIN_BLOCKED:
	PUSHL	$1f
	CALL	KERNEL$SUICIDE

	.SECTION .rodata
1:	.STRING	"BLOCK_THREAD: MAIN THREAD ATTEMPTED TO BLOCK"
#endif
