#ifndef __KERNEL_TIME_H
#define __KERNEL_TIME_H

#include <ARCH/CPU.H>
#include <ARCH/BSF.H>
#include <SYS/TYPES.H>
#include <ARCH/SCHED.H>
#include <SYS/TIME.H>

#include <ARCH/TIME.H>

void TIMER_INIT(void);

extern __u8 FINE_TICKS_SHIFT;

extern volatile time_t USER_JIFFIES;
extern volatile short int TIME_MINUTESWEST;
extern volatile int TIME_DST;

extern volatile jiffies_t __JIFFIES;

static __finline__ jiffies_lo_t GET_JIFFIES_LO(void)
{
	return *(volatile jiffies_lo_t *)(void *)&__JIFFIES;
}

static __finline__ jiffies_t GET_JIFFIES(void)
{
	return KERNEL$GET_JIFFIES();
}

extern sched_unsigned FINE_TICKS_PER_MINUTE;

#define _FINE_TICKS_SHIFT_WITHOUT_TSC	(__BSR_CONST(70000000 / (JIFFIES_PER_SECOND * 60)) + 1)

static __finline__ sched_unsigned GET_FINE_TICKS(void)
{
	long t;
	__asm__ volatile ("				\n\
		.SECTION .FEATURE_FIXUP			\n\
		.LONG	0f - 1, 0f, 0, 0, "__stringify(_FEATURE_VALUE_FINE_TICKS_SHIFT)"						\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(FEATURE_NEGATE | FEATURE_TSC)"							\n\
		.PREVIOUS				\n\
	41:						\n\
		MOVL	IRQ_RDTSC, %%EAX		\n\
		TESTL	%%EAX, %%EAX			\n"
#ifndef __NO_ASM_PREDICTIONS
"		JNE,pt	0f				\n"
#else
"		JNE	0f				\n"
#endif
"		RDTSC					\n\
		SHRDL	$0x1f, %%EDX, %%EAX		\n\
	0:	MOVL	$0, IRQ_RDTSC			\n\
	42:						\n\
		.SECTION .rodata.end			\n\
	43:						\n\
		MOVL	__JIFFIES, %%EAX		\n\
		SHLL	%b1, %%EAX			\n\
	44:						\n\
		.PREVIOUS				\n\
		":"=a"(t):"cn"(_FINE_TICKS_SHIFT_WITHOUT_TSC):"dx","cc");
	return t;
}

time_t GET_TIME_SEC(void);
int GET_TIME_OF_DAY(struct timeval *tv);

static __finline__ void ARCH_UPDATE_TIME(void)
{
	unsigned __tmp1 = KERNEL$JIFFIES_STEP;
	__asm__ volatile ("				\n\
		ADDL	%0, USER_JIFFIES		\n\
		JC	11f				\n\
	12:	ADDL	%0, __JIFFIES			\n\
		JC	21f				\n\
	22:						\n\
		.SECTION .text.end			\n\
	11:	INCL	USER_JIFFIES + 4		\n\
		JMP	12b				\n\
	21:	INCL	__JIFFIES + 4			\n\
		JMP	22b				\n\
		.PREVIOUS				\n\
		.SECTION .FEATURE_FIXUP			\n\
		.LONG	41f, 42f, 42f, 42f, "__stringify(FEATURE_NEGATE | FEATURE_TSC)"					 		\n\
		.PREVIOUS				\n\
	41:						\n\
		MOVL	IRQ_RDTSC, %0			\n\
		MOVL	%0, LAST_FINE_TICKS		\n\
	42:						\n\
		":"=r"(__tmp1):"0"(__tmp1):"cc","memory");
}

#endif
