#ifndef __KERNEL_TIMEREG_H
#define __KERNEL_TIMEREG_H

#define TIMER_IO_BASE		0x40
#define TIMER_IO_RANGE		0x04

#define TIMER_0_IO		0x40
#define TIMER_1_IO		0x41
#define TIMER_2_IO		0x42
#define TIMER_CTL_IO		0x43
#define  TIMER_CTL_BCD			0x01
#define  TIMER_CTL_MODE			0x0e
#define   TIMER_CTL_MODE_0			0x00
#define   TIMER_CTL_MODE_1			0x02
#define   TIMER_CTL_MODE_2			0x04
#define   TIMER_CTL_MODE_3			0x06
#define   TIMER_CTL_MODE_4			0x08
#define   TIMER_CTL_MODE_5			0x0a
#define  TIMER_CTL_ACTION		0x30
#define   TIMER_CTL_ACTION_READ			0x00
#define   TIMER_CTL_ACTION_RW_MSB		0x10
#define   TIMER_CTL_ACTION_RW_LSB		0x20
#define   TIMER_CTL_ACTION_RW_LSB_MSB		0x30
#define  TIMER_CTL_TIMER		0xc0
#define   TIMER_CTL_TIMER_0			0x00
#define   TIMER_CTL_TIMER_1			0x40
#define   TIMER_CTL_TIMER_2			0x80

#define PPI_PORT_A		0x60
#define PPI_PORT_B		0x61
#define  PPI_PORT_B_ENABLE_TIMER_2	0x01
#define  PPI_PORT_B_ENABLE_SPEAKER	0x02
#define  PPI_PORT_B_PORT_C_SELECT	0x04
#define  PPI_PORT_B_TAPE		0x08
#define  PPI_PORT_B_RAM_PARITY		0x10
#define  PPI_PORT_B_ENABLE_SLOT_ERROR	0x20
#define  PPI_PORT_B_ENABLE_KBD_CLOCK	0x40
#define  PPI_PORT_B_PORT_A_SELECT	0x80
#define PPI_PORT_C		0x62

#endif
