#ifndef __ARCH_UDATADEF_H
#define __ARCH_UDATADEF_H

#include <ARCH/SETUP.H>
#include <KERNEL/VMDEF.H>
#include <KERNEL/SYSDEF.H>

#define USTACK_SIZE	4096
#define UPAGES		2

#define UDATA_BOTTOM		0

#define UDATA_COPROCESSOR	0
#define UDATA_AST_QUEUES	512	/* size is 8 * 32 = 256 */

#define UDATA_EAX		768
#define UDATA_ECX		772
#define UDATA_EDX		776
#define UDATA_EBX		780
#define UDATA_EBP		784
#define UDATA_ESI		788
#define UDATA_EDI		792
#define UDATA_EFLAGS		796
#define UDATA_EIP		800
#define UDATA_CS		804	/* must be UDATA_EIP+4 --- ljmp */
#define UDATA_ESP		808
#define UDATA_SS		812	/* must be UDATA_ESP+4 --- lss */

#define UDATA_TMP_STACK		816

#define UDATA_CPU_ID		820
#define UDATA_SPL		824
#define UDATA_PPL		828
#define UDATA_LIST_END		832

#define UDATA_ORIG_ESP		840

#define UDATA_DS		844
#define UDATA_ES		846	/* must be UDATA_DS+2 */
#define UDATA_FS		848
#define UDATA_GS		850	/* must be UDATA_FS+2 */

#define UDATA_ALTSTACK		852
#define UDATA_ALTSTACK_SIZE	856

#define UDATA_LDT		860
#define UDATA_LDT_N		864

#define UDATA_COPROCESSOR_USED	868

#define UDATA_SAVED_EIP		872
#define UDATA_SAVED_ESP		876
#define UDATA_SAVED_CS_SS	880
#define UDATA_SAVED_EFLAGS	884

#define UDATA_BPL		888

#define UDATA_MALLOC_BUCKETS	896

#define UDATA_STRUCT		2944

#define UDATA_TOP		(UDATA_STRUCT + sizeof(UDATA))

#define OFF_UDATA_base			(0*4)
#define OFF_UDATA_lnt			(4*4)
#define OFF_UDATA_timer_available	(9*4+1)
#define OFF_UDATA_xcpt_available	(9*4+2)
#define OFF_UDATA_xcpt_handler		(10*4)
#define OFF_UDATA_xcpt_return		(15*4)
#define OFF_UDATA_xcpt_type		(16*4)
#define OFF_UDATA_xcpt_address		(17*4)
#define OFF_UDATA_xcpt_error		(18*4)

#define OFF_UDATA_timer_handler		(19*4)

#define OFF_UDATA_n_slabs		(26*4)
#define OFF_UDATA_all_slabs		(27*4)
#define OFF_UDATA_vspace		(29*4)
#define OFF_UDATA_environ		(30*4)
#define OFF_UDATA_environ_callbacks	(31*4)
#define OFF_UDATA_environ_list		(32*4)
#define OFF_UDATA_progname		(33*4)
#define OFF_UDATA_exit_func		(34*4)
#define OFF_UDATA_errno			(35*4)

#define OFF_UDATA_repost_ast_fn		(36*4)

#define OFF_UDATA_current_thread	((36+KERNEL_CALL_MAX)*4)
#define OFF_UDATA_init_thread		((37+KERNEL_CALL_MAX)*4)
#define OFF_UDATA_isthreaded		((49+KERNEL_CALL_MAX)*4)
#define OFF_UDATA_multiopen		((50+KERNEL_CALL_MAX)*4)
#define OFF_UDATA_subproc_ctl		((51+KERNEL_CALL_MAX)*4)
#define OFF_UDATA_logical_wait		((52+KERNEL_CALL_MAX)*4)

#define XCPT_RPF		0x100
#define XCPT_WPF		0x101

#define PTR_ALIGN		4
#define VMMAP_PAD		8
#define VMMAP_ALIGN		8
#define LNT_ALIGN		4
#define FILE_ALIGN		8
#define IORQ_ALIGN		4
#define LN_LIST_STAT_ALIGN	4
#define KSPAWNRQ_ALIGN		4

#define MALLOC_ALIGN(x)		(((x) + sizeof(size_t) + __MALLOC_ALIGN - 1) & ~(unsigned long)(__MALLOC_ALIGN - 1))

#define KERNEL_DLL_BASE		(1024 * 4096)
#define MAP_EXE_ADDR		(512 * 1024 * 1024)
#define STACK_SIZE		(64 * 1024 * 1024)

#define APAGE_RETURN_BLOCK		0x00
#define APAGE_RETURN			0x00
#define APAGE_SEG_RETURN		0x14
#define APAGE_RETURN_BLOCK_SIZE		0x40	/* must be power of 2 */
#define APAGE_START_FIXUP		0x40
#define APAGE_QUEUE_AST			0x40
#define APAGE_PROCESS_PENDING_AST	0x52
#define APAGE_JMP_EAX			0x9d
#define APAGE_SYSCALL			0xa0
#define APAGE_POP_RET			0xaa
#define APAGE_RET			0xaf
#define	APAGE_SET_8			0xb0
#define	APAGE_GET_8			0xb9
#define APAGE_CHECK_ASTS		0xc0
#define	APAGE_POP_RET_SEG		0xf5
#define APAGE_GET_TIME_OF_DAY		0x150
#define APAGE_MALLOC			0x1a8
#define APAGE_MALLOC_CONST		0x1b0
#define APAGE_MALLOC_RET		0x1ca
#define APAGE_FREE			0x1d0
#define APAGE_FREE_RET			0x1ff
#define APAGE_END_FIXUP			0x200

#define APAGE_USER_JIFFIES		0x800	/* time_t */
#define APAGE_LAST_FINE_TICKS		0x808
#define APAGE_JIFFIES_STEP		0x80c	/* int */
#define APAGE_JIFFIES_STEP_BITS		0x810	/* char */
#define APAGE_TIME_MINUTESWEST		0x812	/* short int */
#define APAGE_TIME_DST			0x814	/* int */

#define APAGE_FEATURE_BOX		0x820

#define KUVMTOP		((__KERNEL_USER_VBANKS << (PG_BANK_BITS + PG_SIZE_BITS)) - PAGE_CLUSTER_SIZE)
#define KUVMBASE	(KUVMTOP - UPAGES * PAGE_CLUSTER_SIZE + USTACK_SIZE)
#define KUPLACE(idx)	(KUVMBASE + (idx))

#define UVMTOP		((VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS)) - PAGE_CLUSTER_SIZE + PG_BANK * PG_SIZE)
#define UVMBASE		(UVMTOP - UPAGES * PAGE_CLUSTER_SIZE + USTACK_SIZE)
#define UPLACE(idx)	(UVMBASE + (idx))

#define ABASE		((VM_KERNEL_RESERVED_BANK << (PG_BANK_BITS + PG_SIZE_BITS)) + (RESERVED_APAGE << PG_SIZE_BITS))
#define APLACE(idx)	(ABASE + (idx))
#define KBASE		((VM_KERNEL_RESERVED_BANK << (PG_BANK_BITS + PG_SIZE_BITS)) + (RESERVED_KPAGE << PG_SIZE_BITS))
#define KPLACE(idx)	(KBASE + (idx))

#if defined(__GNUC__) && (__GNUC__ < 3 || (__GNUC__ == 3 && __GNUC_MINOR__ < 3))
#define KERNEL_DLL_DATA_SIZE	1024
#else
#define KERNEL_DLL_DATA_SIZE	768
#endif

#define SET_8(addr, val1, val2) __asm__ volatile ("CALL "__stringify(APLACE(APAGE_SET_8))::"c"(addr),"a"(val1),"d"(val2):"cc","memory");
#define SET_VMMAPS(base, len) SET_8(&udata.vmmaps, base, len)

#define SET_OFFSET(addr, val) __asm__ volatile ("CALL "__stringify(APLACE(APAGE_SET_8))::"c"(addr),"A"((__u64)(val)):"cc","memory");

#define TEST_AND_SET_OFFSET_AVAILABLE	__CMPXCHG64_AVAILABLE

#define TEST_AND_SET_OFFSET		__CMPXCHG64

#endif
