#ifndef __KERNEL_VMDEF_H
#define __KERNEL_VMDEF_H

#include <SPAD/VMDEF.H>
#include <ARCH/SETUP.H>
#include <ARCH/CPUDEF.H>

#ifndef _1U
#define _1U 1U
#endif

#define PG_CLUSTER_BITS		__KERNEL_CLUSTER_BITS
#define PG_CLUSTER		(1 << __KERNEL_CLUSTER_BITS)
#define PAGE_CLUSTER_SIZE	(PG_SIZE << __KERNEL_CLUSTER_BITS)

#define PG_MAXPAGES_NOPAE	0x00100000
#define PG_MAXPAGES_PAE		0x01000000

#define KERNEL_HIGH_ZONE_COMPILE	1
#define KERNEL_BOUNCE_COMPILE		1


#define VM_KERNEL_PAGE_BANK		__KERNEL_USER_VBANKS
#define VM_KERNEL_DIRECT_BANK_NOPAE	(VM_KERNEL_PAGE_BANK + ((PG_MAXPAGES_NOPAE >> __KERNEL_CLUSTER_BITS) * PG_SIZEOF_STRUCT_PAGE + PG_SIZE * PG_BANK - 1) / PG_SIZE / PG_BANK)
#define VM_KERNEL_DIRECT_BANK_PAE	(VM_KERNEL_PAGE_BANK + ((PG_MAXPAGES_PAE >> __KERNEL_CLUSTER_BITS) * PG_SIZEOF_STRUCT_PAGE + PG_SIZE * PG_BANK - 1) / PG_SIZE / PG_BANK)

#define VM_KERNEL_DIRECT_OFFSET_NOPAE	(_1U * VM_KERNEL_DIRECT_BANK_NOPAE * PG_SIZE * PG_BANK)
#define VM_KERNEL_DIRECT_OFFSET_PAE	(_1U * VM_KERNEL_DIRECT_BANK_PAE * PG_SIZE * PG_BANK)

#define VM_KERNEL_RESERVED_BANK		1022
#define 	RESERVED_APAGE			0
#define 	RESERVED_KPAGE			1
#define 	RESERVED_TSS			2
#define 	RESERVED_IOBMP			3
#define 		IOBMP_OFFSET			32
#define 		IOBMP_PAGES			3
#define		RESERVED_LDT			(RESERVED_IOBMP + IOBMP_PAGES)
#define			LDT_PAGES			16
#define		RESERVED_MEMMAP			(RESERVED_LDT + LDT_PAGES)
#define			MEMMAP_PAGES			(1024 - RESERVED_MEMMAP)

#define VM_KERNEL_COPY_OF_LAST_BANK	1023

#endif
