#ifndef __KERNEL_VM_ARCH_H
#define __KERNEL_VM_ARCH_H

#include <SPAD/VM.H>
#include <KERNEL/VMDEF.H>
#include <KERNEL/ASM.H>
#include <ARCH/SETUP.H>
#include <ARCH/CPU.H>
#include <SPAD/WQ.H>
#include <KERNEL/SMP/SHARE.H>

#define MAX_NODES_BITS			8

extern char PREPARE_FOR_HIGHMEM;

void *VM_BOOT_INIT_NOPAE(void);
void *VM_BOOT_INIT_PAE(void);
#define VM_BOOT_INIT			(!KERNEL$FEATURE_TEST(_FEATURE_USE_PAE) ? VM_BOOT_INIT_NOPAE : VM_BOOT_INIT_PAE)
void VM_BOOT_GET_MEM_NOPAE(unsigned long code_bottom, unsigned long free_later, unsigned long code_top, unsigned long data_bottom, unsigned long data_top, unsigned long mem_top);
void VM_BOOT_GET_MEM_PAE(unsigned long code_bottom, unsigned long free_later, unsigned long code_top, unsigned long data_bottom, unsigned long data_top, unsigned long mem_top);
void VM_BOOT_GET_MEM(unsigned long code_bottom, unsigned long free_later, unsigned long code_top, unsigned long data_bottom, unsigned long data_top, unsigned long mem_top);
void VM_BOOT_GET_MORE_MEM_NOPAE(void);
void VM_BOOT_GET_MORE_MEM_PAE(void);
#define VM_BOOT_GET_MORE_MEM		(!KERNEL$FEATURE_TEST(_FEATURE_USE_PAE) ? VM_BOOT_GET_MORE_MEM_NOPAE : VM_BOOT_GET_MORE_MEM_PAE)

void *VM_BOOT_MAKE_DIRECT_MAPPING_NOPAE(void);
void *VM_BOOT_MAKE_DIRECT_MAPPING_PAE(void);
#define VM_BOOT_MAKE_DIRECT_MAPPING	(!FEATURE_TEST(_FEATURE_USE_PAE) ? VM_BOOT_MAKE_DIRECT_MAPPING_NOPAE : VM_BOOT_MAKE_DIRECT_MAPPING_PAE)
void VM_BOOT_CLEAR_DIRECT_MAPPING_NOPAE(void);
void VM_BOOT_CLEAR_DIRECT_MAPPING_PAE(void);
#define VM_BOOT_CLEAR_DIRECT_MAPPING	(!FEATURE_TEST(_FEATURE_USE_PAE) ? VM_BOOT_CLEAR_DIRECT_MAPPING_NOPAE : VM_BOOT_CLEAR_DIRECT_MAPPING_PAE)

#define MAX_PBANKS		(PG_MAXPAGES_PAE / PG_BANK)

extern PAGE KERNEL_PAGE_MAP[];

#define PAGE_2_PHYS(p) 		((__p_addr)(unsigned long)((char *)(p) - (char *)KERNEL_PAGE_MAP) << (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS))
#define PHYS_2_PAGE_ALIGNED(a)	((PAGE *)((char *)KERNEL_PAGE_MAP + ((a) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS))))
#define PHYS_2_PAGE(a)		(KERNEL_PAGE_MAP + ((a) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS)))

#define PAGE_2_VIRT(p)		((((char *)(p) - (char *)KERNEL_PAGE_MAP) << (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS)) + KERNEL$ZERO_BANK)
#define VIRT_2_PAGE_ALIGNED(a)	((PAGE *)((char *)KERNEL_PAGE_MAP + (((__u8 *)(a) - KERNEL$ZERO_BANK) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS))))
#define VIRT_2_PAGE(a)		(KERNEL_PAGE_MAP + (((__u8 *)(a) - KERNEL$ZERO_BANK) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS)))

/* can't use KERNEL$ZERO_BANK because this must work before link fixup
   is performed */
#define KMAP_PHYS_2_VIRT(P)	((void *)((unsigned long)(P) + (!KERNEL$FEATURE_TEST(_FEATURE_USE_PAE) ? VM_KERNEL_DIRECT_OFFSET_NOPAE : VM_KERNEL_DIRECT_OFFSET_PAE)))
#define KMAP_PAGE_2_VIRT(P)	KMAP_PHYS_2_VIRT(PAGE_2_PHYS(P))

#define IS_PAGE_POINTER(p)	((__u8 *)(p) < KERNEL$ZERO_BANK)

#define CACHE_WBINVD()							\
do {									\
	__asm__ volatile ("WBINVD":::"memory");				\
} while (0)

#define CACHE_WBINVD_WHEN_NO_SELFSNOOP()				\
do {									\
	__asm__ volatile ("						\n\
	.SECTION .FEATURE_FIXUP						\n\
	.LONG	41f, 42f, 42f, 42f, "__stringify(_FEATURE_SELF_SNOOP)"	\n\
	.PREVIOUS							\n\
41:	WBINVD								\n\
42:									\n\
	":::"memory");							\
} while (0)

#define TLB_INVD_NG()							\
do {									\
	__asm__ volatile ("						\n\
	MOVL	PROC_CURRENT, %%EAX					\n\
	CALL	SET_PROC_CURRENT					\n\
	":::"ax","memory");						\
} while (0)

#define TLB_INVD_G()							\
do {									\
	__u32 tmp1;							\
	__asm__ volatile ("						\n\
	.SECTION .FEATURE_FIXUP						\n\
	.LONG	41f, 42f, 42f, 42f, "__stringify(FEATURE_NEGATE | _FEATURE_GLOBAL_PAGES)"								\n\
	.LONG	43f, 44f, 44f, 44f, "__stringify(FEATURE_NEGATE | _FEATURE_GLOBAL_PAGES)"								\n\
	.PREVIOUS							\n\
41:									\n\
	MOVL	CR_4, %0						\n\
	ANDL	$~"__stringify(CR4_PGE)", %0				\n\
	MOVL	%0, %%CR4						\n\
42:									\n\
	MOVL	PROC_CURRENT, %%EAX					\n\
	CALL	SET_PROC_CURRENT					\n\
43:									\n\
	ORL	$"__stringify(CR4_PGE)", %0				\n\
	MOVL	%0, %%CR4						\n\
44:									\n\
	":"=r"(tmp1)::"ax","cc","memory");				\
} while (0)

#define TLB_INVD_PG(addr)						\
do {									\
	__asm__ volatile ("INVLPG %0"::"m"(*(char *)(addr)):"memory");	\
} while (0)

#define AREA_KERNEL_ZONE	0x10000

int VM_ARCH_NEW_PBANK_NOPAE(int type, __node_id_t node, __node_id_t node_mask);
int VM_ARCH_NEW_PBANK_PAE(int type, __node_id_t node, __node_id_t node_mask);
#define VM_ARCH_NEW_PBANK	(!FEATURE_TEST(_FEATURE_USE_PAE) ? VM_ARCH_NEW_PBANK_NOPAE : VM_ARCH_NEW_PBANK_PAE)
__node_id_t VM_GET_NODE(__p_addr addr);
int VM_ARCH_CHECK_HW_MEM(PAGE *p);

void VM_ARCH_INIT_PAGETABLES_NOPAE(void);
void VM_ARCH_INIT_PAGETABLES_PAE(void);
#define VM_ARCH_INIT_PAGETABLES	(!FEATURE_TEST(_FEATURE_USE_PAE) ? VM_ARCH_INIT_PAGETABLES_NOPAE : VM_ARCH_INIT_PAGETABLES_PAE)

WQ *VM_ARCH_MAP_PAGE(PROC *p, unsigned long addr, PAGE *page, int wr);
WQ *VM_ARCH_UNMAP_RANGE(PROC *p, unsigned long addr, unsigned long len);
WQ *VM_ARCH_READ_ONLY(PROC *p);
WQ *VM_ARCH_UNMAP_MAPPING(XLIST_HEAD *mapping);
WQ *VM_ARCH_CHECK_MAPPING(XLIST_HEAD *mapping, int unw);
PAGE *VM_ARCH_GET_PAGE(PROC *p, unsigned long addr, int wr);
void VM_ARCH_AFTER_FORK(PROC *p);

int VM_SPLIT_BIGPAGE_NOPAE(__p_addr addr);
int VM_SPLIT_BIGPAGE_PAE(__p_addr addr);
#define VM_SPLIT_BIGPAGE	(!FEATURE_TEST(_FEATURE_USE_PAE) ? VM_SPLIT_BIGPAGE_NOPAE : VM_SPLIT_BIGPAGE_PAE)

int KERNEL_SET_MEMORY_LIMIT_NOPAE(__u64 memory, __u64 *holes, int n_holes);
int KERNEL_SET_MEMORY_LIMIT_PAE(__u64 memory, __u64 *holes, int n_holes);
int KERNEL_SET_MEMORY_PAT_NOPAE(__p_addr addr, __p_addr len, int pat);
int KERNEL_SET_MEMORY_PAT_PAE(__p_addr addr, __p_addr len, int pat);
int KERNEL_SET_MAPPED_MEMORY_NOPAE(__p_addr addr, __p_addr len, int pat);
int KERNEL_SET_MAPPED_MEMORY_PAE(__p_addr addr, __p_addr len, int pat);
__u64 KERNEL_GET_MEMORY_SIZE_NOPAE(int type);
__u64 KERNEL_GET_MEMORY_SIZE_PAE(int type);
void VM_BOOT_INIT_AP(void);
void VM_BOOT_INIT_AP_NOPAE(void);
void VM_BOOT_INIT_AP_PAE(void);

int VM_ADD_MEMORY_HOLE(__u64 h0, __u64 h1);

extern char FOLD_DL;

void VM_KERNEL_FAULT_EXCEPTION(void *addr, int flags, void *ip);
void SYSCALL_INVD_EXTD_PAGE(unsigned long sys, unsigned long idx, unsigned long arg3);

void *KERNEL_MAP_PHYSICAL_BANK_PAE(__p_addr physaddr_);
void KERNEL_UNMAP_PHYSICAL_BANK_PAE(void *ptr);
__p_addr KERNEL_UNMAP_PHYSICAL_BANK_ADDR_PAE(void *ptr);
PAGE *KERNEL_UNMAP_PHYSICAL_BANK_PAGE_PAE(void *ptr);
void *KERNEL_MAP_PHYSICAL_PAGE_PAE(PAGE *p);
__p_addr KERNEL_PAGE_2_PHYS_PAE(PAGE *p);
PAGE *KERNEL_PHYS_2_PAGE_PAE(__p_addr p);
unsigned long KERNEL_VIRT_2_PHYS_PAE(void *virt);
void *KERNEL_PHYS_2_VIRT_PAE(unsigned long phys);
void *KERNEL_DMA_2_VIRT_PAE(unsigned long dma);
__u32 KERNEL_MAP_PAGE_DMA_PAE(PAGE *p);
PAGE *KERNEL_UNMAP_PAGE_DMA_PAE(__u32 d);
__u64 KERNEL_MAP_PAGE_DMA64_PAE(PAGE *p);
PAGE *KERNEL_UNMAP_PAGE_DMA64_PAE(__u64 d);
WQ *VM_ARCH_MAP_PAGE_PAE(PROC *p, unsigned long addr, PAGE *page, int wr);
WQ *VM_ARCH_UNMAP_RANGE_PAE(PROC *p, unsigned long addr, unsigned long len);
WQ *VM_ARCH_READ_ONLY_PAE(PROC *p);
WQ *VM_ARCH_UNMAP_MAPPING_PAE(XLIST_HEAD *mapping);
WQ *VM_ARCH_CHECK_MAPPING_PAE(XLIST_HEAD *mapping, int unw);
PAGE *VM_ARCH_GET_PAGE_PAE(PROC *p, unsigned long addr, int wr);
void VM_KERNEL_FAULT_EXCEPTION_PAE(void *addr, int flags, void *ip);
void SYSCALL_INVD_EXTD_PAGE_PAE(unsigned long sys, unsigned long idx, unsigned long arg3);
void ARCH_PROC_CTOR_PAE(PROC *proc);
void ARCH_PROC_INIT_PAE(PROC *proc, PROC *previous);
void ARCH_PROC_DESTROY_PAE(PROC *proc);
void ARCH_PROC_FREE_PAE(PROC *proc);
void VM_ARCH_AFTER_FORK_PAE(PROC *proc);
void *KERNEL_MAP_PHYSICAL_REGION_LONG_TERM_PAE(__p_addr addr, unsigned length, int pat);
void KERNEL_UNMAP_PHYSICAL_REGION_LONG_TERM_PAE(const void *vaddr_, unsigned length);

void SAVE_FPU(void);
void SAVE_FPU_PAE(void);
void FLUSH_FPU(void);	/* may be called only from top-level */
void FLUSH_FPU_PAE(void);	/* may be called only from top-level */

void MACHINE_INIT(void);
__u64 MACHINE_SET_MEMORY_LIMIT(__u64 memsize, __u64 *holes, int n_holes);

__p_addr CACHE_LIMIT_PROBE(void);

#define KERNEL_BOUNCE_ACTIVE		(FEATURE_TEST(_FEATURE_USE_BOUNCE))
#define KERNEL_PADDR_NEEDS_BOUNCE(a)	((a) >= (__u64)1 << 32)

#define N_HOLES		1024

struct vm_arch {
	__u64 MEMSIZE;
	int N_PBANKS;
	int N_DIRECT_PBANKS;
	__u32 DIRECT_SIZE;	/* == N_DIRECT_PBANKS << (PG_BANK_BITS + PG_SIZE_BITS); */
	int PBANKS[MAX_PBANKS];
	__p_addr PHYSMAP_486[MAX_PBANKS];
	int VM_N_HOLES;
	__u64 VM_HOLES[N_HOLES * 2];
	int MEMMAP_REFCOUNTS[MEMMAP_PAGES];
	__u64 CACHE_LIMIT;
};

extern struct vm_arch *VM_ARCH;

#define VM_ARCH_IS_PBANK_HIGH(b)	((b) >= 1024)

#endif
