#define _1U	1

#include <ARCH/SETUP.H>
#include <ARCH/CPUDEF.H>
#include <KERNEL/VMDEF.H>
#include <SPAD/SPLDEF.H>

#if __DEBUG >= 1
	.SECTION .rodata.end
SPL_ERR:.STRING "%s AT SPL %08X"
#define SPLVSPACEASSERT(s)						\
	CMPL	$0xfffffffe << SPL_VSPACE, KERNEL$SPL			;\
	JNE	1f							;\
	.SECTION .rodata.end						;\
2:	.STRING s							;\
	.SECTION .text.end						;\
1:	PUSHL	KERNEL$SPL						;\
	PUSHL	$2b							;\
	PUSHL	$SPL_ERR						;\
	CALL	KERNEL$SUICIDE						;\
	.SECTION .text
#else
#define SPLVSPACEASSERT(s)
#endif

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO VDMA
 * OUT: %EAX - UNLOCK
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	VIRTUAL_DMALOCK
	.GLOBAL	VIRTUAL_DMA64LOCK
	.GLOBAL	VIRTUAL_PHYSLOCK
VIRTUAL_DMA64LOCK:
VIRTUAL_PHYSLOCK:
	MOVL	$0, 12(%ECX)
VIRTUAL_DMALOCK:
	SPLVSPACEASSERT("VIRTUAL_DMALOCK")
	MOVL	8(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	MOVL	(%EAX), %EAX
41:
	SUBL	$VM_KERNEL_DIRECT_OFFSET_NOPAE, %EAX
42:
	.SECTION .rodata.end
43:
	SUBL	$VM_KERNEL_DIRECT_OFFSET_PAE, %EAX
44:
	.PREVIOUS
	.SECTION .FEATURE_FIXUP
	.LONG	41b, 42b, 43b, 44b, _FEATURE_USE_PAE
	.PREVIOUS
	JMP	physlock_finish_2

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO PTR TO UNMAP
 * OUT: %EAX - PTR
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	VIRTUAL_MAP
VIRTUAL_MAP:
	SPLVSPACEASSERT("VIRTUAL_MAP")
	MOVL	4(%ESP), %EDX
	MOVL	$KERNEL$NULL_VSPACE_UNMAP, (%EDX)
	MOVL	(%EAX), %EAX
	MOVL	%ECX, %EDX
	JMP	VSPACE_LOWER_SPL


/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO PTR TO VDMA
 * OUT: %EAX - UNLOCK
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PHYSICAL_DMALOCK
PHYSICAL_DMALOCK:
	SPLVSPACEASSERT("PHYSICAL_DMALOCK")
#if KERNEL_BOUNCE_COMPILE
#if __DEBUG_BOUNCE
	TESTB	$1, %DL
	JE	JMP_KERNEL_DO_BOUNCE
	TESTB	$2, %DL
	JE	JMP_KERNEL_DO_BOUNCE
#endif
41:
	CMPL	$0, 4(%EAX)
	JNZ	JMP_KERNEL_DO_BOUNCE
42:
	.SECTION .FEATURE_FIXUP
	.LONG	41b, 42b, 42b, 42b, FEATURE_NEGATE | _FEATURE_USE_BOUNCE
	.PREVIOUS
#endif
	MOVL	8(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	MOVL	(%EAX), %EAX
physlock_finish_2:
	MOVL	%EAX, 8(%ECX)
	MOVL	$NULL_CALL, %EAX
physlock_finish:
	MOVL	(%ECX), %EDX
#if __DEBUG >= 2
	JMP	VSPACE_LOWER_SPL
#else
VSPACE_LOWER_SPL:
	MOVL	%EDX, KERNEL$SPL
	TESTL	%EDX, KERNEL$PPL
	JNZ	9f
	RET
	.SECTION .text.end
	.ALIGN	__CPU_BRANCH_ALIGN
9:
	PUSHL	%ESI
	MOVL	%EDX, %ESI
	PUSHL	%EAX
	CALL	KERNEL$PROCESS_PENDING_AST
	POPL	%EAX
	POPL	%ESI
	RET
	.PREVIOUS
#endif

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$NULL_VSPACE_UNMAP
	.GLOBAL	KERNEL$NULL_VSPACE_DMAUNLOCK
	.GLOBAL	KERNEL$NULL_VSPACE_DMA64UNLOCK
	.GLOBAL	KERNEL$NULL_VSPACE_PHYSUNLOCK
	.GLOBAL	KERNEL$PHYSICAL_UNMAP_DMA64
#if !__DEBUG_BOUNCE
KERNEL$PHYSICAL_UNMAP_DMA64:
#endif
	MOVL	4(%ESP), %EAX
	MOVL	8(%ESP), %EDX
KERNEL$NULL_VSPACE_DMA64UNLOCK:
KERNEL$NULL_VSPACE_PHYSUNLOCK:
KERNEL$NULL_VSPACE_UNMAP:
KERNEL$NULL_VSPACE_DMAUNLOCK:
NULL_CALL:
	RET

#if KERNEL_BOUNCE_COMPILE
	.SECTION .text
JMP_KERNEL_DO_BOUNCE:	
	JMP	KERNEL_DO_BOUNCE
#endif

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$PHYSICAL_UNMAP_DMA
KERNEL$PHYSICAL_UNMAP_DMA:
41:
	JMP	KERNEL_DO_UNBOUNCE
42:
	.SECTION .rodata.end
43:
	XORL	%EDX, %EDX
	RET
44:
	.PREVIOUS
	.SECTION .FEATURE_FIXUP
	.LONG	41b, 42b, 43b, 44b, FEATURE_NEGATE | _FEATURE_USE_BOUNCE
	.PREVIOUS

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO VDMA64
 *     4(%ESP) - PTR TO PTR TO UNLOCK
 * OUT: NOTHING
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PHYSICAL_DMA64LOCK
	.GLOBAL	PHYSICAL_PHYSLOCK
PHYSICAL_DMA64LOCK:
PHYSICAL_PHYSLOCK:
	SPLVSPACEASSERT("PHYSICAL_DMA64LOCK")
#if __DEBUG_BOUNCE
	TESTB	$1, %DL
	JE	1f
	TESTB	$2, %DL
	JE	1f
#endif
41:
	MOVL	4(%EAX), %EDX
42:
	.SECTION .rodata.end
43:
	XORL	%EDX, %EDX
44:
	.PREVIOUS
	.SECTION .FEATURE_FIXUP
	.LONG	41b, 42b, 43b, 44b, FEATURE_NEGATE | _FEATURE_USE_BOUNCE
	.PREVIOUS
	MOVL	%EDX, 12(%ECX)
	MOVL	8(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	MOVL	(%EAX), %EAX
	MOVL	%EAX, 8(%ECX)
	MOVL	$KERNEL$NULL_VSPACE_PHYSUNLOCK, %EAX
	JMP	physlock_finish

#if __DEBUG_BOUNCE
1:
	MOVL	$0, 12(%ECX)
	JMP	KERNEL_DO_BOUNCE

KERNEL$PHYSICAL_UNMAP_DMA64:
	MOVL	8(%ESP), %EDX
	MOVL	4(%ESP), %EAX
	TESTL	%EDX, %EDX
	JZ	KERNEL_DO_UNBOUNCE
	RET
#endif
