#include <SPAD/LIBC.H>
#include <STRING.H>
#include <SPAD/VM.H>
#include <ARCH/CPUDEF.H>
/*
#include <ARCH/SPINLOCK.H>
#include <SMP.H>
*/
#include <ARCH/IO.H>
#include <SPAD/IRQ.H>
#include <SPAD/AC.H>
#include <SPAD/DL.H>

#include <ARCH/BIOS16.H>

/*
SPINLOCK_T *bios_lock;
*/

const __u16 BIOS16$REAL_OFFSET = ADDR_BIOS16_PTR;
const __u16 BIOS16$REAL_SEGMENT = 0;

extern unsigned long BIOS_STUB_ADDRESS;

extern unsigned long STUB_EAX, STUB_ECX, STUB_EDX, STUB_EBX, STUB_EBP, STUB_ESI, STUB_EDI;
extern unsigned short STUB_ES, STUB_DS, STUB_FS, STUB_GS;
extern unsigned char STUB_FLAGS;
extern unsigned char STUB_INT;
extern unsigned char STUB_SAVE_CR4;

extern unsigned char REAL_MODE_STUB[], REAL_MODE_STUB_END[], REAL_MODE_STUB_ENTRY[];

int BIOS16$REAL_INT(int intnum, struct bios_regs *regs, void *ptr, unsigned len, int flags)
{
	int clen;
	int pae;
	unsigned long pgd_phys;
	__u32 *vpgd;
	unsigned zb_offs;
	__u32 saved_zero_pointer;
	__u32 saved_zero_pointer_2;
	if (__unlikely(FEATURE_TEST(FEATURE_USERSPACE))) return -EUSER;
	if (ADDR_BIOS16_STUB + (REAL_MODE_STUB_END - REAL_MODE_STUB) > ADDR_BIOS16_STUB_END) KERNEL$SUICIDE("BIOS STUB TOO LARGE (%X > %X)", ADDR_BIOS16_STUB + (REAL_MODE_STUB_END - REAL_MODE_STUB), ADDR_BIOS16_STUB_END);
	if (len >= ADDR_BIOS16_PTR_END - ADDR_BIOS16_PTR) KERNEL$SUICIDE("BIOSCALL$REAL_INT: TOO LONG DATA, %X > %X", len, ADDR_BIOS16_PTR_END - ADDR_BIOS16_PTR);
	clen = 0;

	pae = 0;
	if (FEATURE_TEST(FEATURE_CR4)) {
		__u32 cr4;
		__asm__ volatile ("MOVL %%CR4, %0":"=r"(cr4));
		if (cr4 & CR4_PAE)
			pae = 1;
	}
	KERNEL$DI_HW();	/* if some jerk enables interrupts in real mode, we
		don't want to crash because of unexpected interrupt
		note: it does really happen --- Trident int 10h routine enables
		interrupts
		*/
	/* now we are mucking with page tables ... the rest of the kernel must not run !!! */
	__asm__ volatile ("MOVL	%%CR3, %0":"=r"(pgd_phys):);
	vpgd = KERNEL$MAP_PHYSICAL_BANK(pgd_phys);
	zb_offs = (unsigned long)KERNEL$ZERO_BANK >> (PG_BANK_BITS + PG_SIZE_BITS);
	/* code needs to be in page with same physical and virtual address when enabling or disabling paging */
	if (__likely(!pae)) {
		saved_zero_pointer = vpgd[0];
		saved_zero_pointer_2 = 0;	/* useless, but the compiler complains about possibly uninitialized variable ... */
		vpgd[0] = vpgd[zb_offs] & ~PTE_G;
	} else {
		unsigned zb_pmd_offs = zb_offs / 256;
		unsigned zb_pgd_offs = zb_offs % 256;
		__u64 z_pgd_phys = __make64(vpgd[0], vpgd[1]) & ~(__u64)0xfff;
		__u64 zb_pgd_phys = __make64(vpgd[zb_pmd_offs * 2], vpgd[zb_pmd_offs * 2 + 1]) & ~(__u64)0xfff;
		__u32 new_zero_pointer, new_zero_pointer_2;
		KERNEL$UNMAP_PHYSICAL_BANK(vpgd);
		vpgd = KERNEL$MAP_PHYSICAL_BANK(zb_pgd_phys);
		new_zero_pointer = vpgd[zb_pgd_offs * 4];
		new_zero_pointer_2 = vpgd[zb_pgd_offs * 4 + 1];
		KERNEL$UNMAP_PHYSICAL_BANK(vpgd);
		vpgd = KERNEL$MAP_PHYSICAL_BANK(z_pgd_phys);
		saved_zero_pointer = vpgd[0];
		saved_zero_pointer_2 = vpgd[1];
		vpgd[0] = new_zero_pointer & ~PTE_G;
		vpgd[1] = new_zero_pointer_2;
	}
	__asm__ volatile ("MOVL %%CR3, %%EAX; MOVL %%EAX, %%CR3":::"ax");
	if (flags & BIOS_DATA_PUT) memcpy((void *)ADDR_BIOS16_PTR, ptr, len), clen = len;
	memcpy((void *)BIOS_STUB_ADDRESS, REAL_MODE_STUB, REAL_MODE_STUB_END - REAL_MODE_STUB);
	STUB_EAX = regs->eax;
	STUB_ECX = regs->ecx;
	STUB_EDX = regs->edx;
	STUB_EBX = regs->ebx;
	STUB_EBP = regs->ebp;
	STUB_ESI = regs->esi;
	STUB_EDI = regs->edi;
	STUB_ES = regs->es;
	STUB_DS = regs->ds;
	STUB_FS = regs->fs;
	STUB_GS = regs->gs;
	STUB_FLAGS = regs->flags;
	STUB_INT = intnum;
	STUB_SAVE_CR4 = FEATURE_TEST(FEATURE_CR4);
			/* GCC is buggy and cannot save %EBP register
			   it also can't save %EBX when compiled with -fPIC */
	__asm__ volatile ("PUSHL %%EBX; PUSHL %%EBP; CALL REAL_MODE_STUB_ENTRY; POPL %%EBP; POPL %%EBX":::"ax","cx","dx","si","di","cc","memory");
	regs->eax = STUB_EAX;
	regs->ecx = STUB_ECX;
	regs->edx = STUB_EDX;
	regs->ebx = STUB_EBX;
	regs->ebp = STUB_EBP;
	regs->esi = STUB_ESI;
	regs->edi = STUB_EDI;
	regs->es = STUB_ES;
	regs->ds = STUB_DS;
	regs->fs = STUB_FS;
	regs->gs = STUB_GS;
	regs->flags = STUB_FLAGS;
	vpgd[0] = saved_zero_pointer;
	if (__unlikely(pae))
		vpgd[1] = saved_zero_pointer_2;
	__asm__ volatile ("MOVL %%CR3, %%EAX; MOVL %%EAX, %%CR3":::"ax");
	/* so ... page tables are back in consistent state and we can enable interrupts */
	if (flags & BIOS_DATA_GET) memcpy(ptr, KERNEL$ZERO_BANK + ADDR_BIOS16_PTR, len), clen = len;
	/*SPIN_UNLOCK(bios_lock);*/
	KERNEL$EI_HW();
	KERNEL$UNMAP_PHYSICAL_BANK(vpgd);
	return 0;
}

/*static SMPRQ s;*/

static DLINITRQ *dlrq;

/*
static AST_STUB LOCK_ALLOCATED;
static AST_STUB LOCK_FREED;

static void init_spinlock(void *p)
{
	SPIN_LOCK_INIT((SPINLOCK_T *)p);
}
*/

DECL_IOCALL(DLL$LOAD, SPL_DEV, DLINITRQ)
{
	dlrq = RQ;
/*
	s.fn = &LOCK_ALLOCATED;
	s.size = sizeof(SPINLOCK_T);
	s.name = "BIOSCALL.DLL$BIOS_SPIN_LOCK";
	s.ctor = &init_spinlock;
	s.dtor = NULL;
	RETURN_IORQ(&s, &KERNEL$GRAB_SHARED_AREA);
}

static DECL_AST(LOCK_ALLOCATED, SPL_DEV, SMPRQ)
{
	if (s.status < 0) {
		_snprintf(dlrq->error, __MAX_STR_LEN, "FAILED TO ALLOCATE SHARED LOCK");
		dlrq->status = RQ->status;
		RETURN_IORQ(dlrq, &KERNEL$DL_LOAD_CANCEL);
	}
	bios_lock = s.ptr;*/
	dlrq->status = 0;
	RETURN_AST(dlrq);
}

DECL_IOCALL(DLL$UNLOAD, SPL_DEV, DLINITRQ)
{
	dlrq = RQ;
	/*
	s.fn = &LOCK_FREED;
	RETURN_IORQ(&s, &KERNEL$RELEASE_SHARED_AREA);
}

static DECL_AST(LOCK_FREED, SPL_DEV, SMPRQ)
{*/
	dlrq->status = 0;
	RETURN_AST(dlrq);
}


