#include <ARCH/CPUDEF.H>

	.GLOBAL	STUB_EAX, STUB_ECX, STUB_EDX, STUB_EBX, STUB_EBP, STUB_ESI, STUB_EDI, STUB_ES, STUB_DS, STUB_FS, STUB_GS, STUB_FLAGS, STUB_INT, STUB_SAVE_CR4, REAL_MODE_STUB, REAL_MODE_STUB_END, REAL_MODE_STUB_ENTRY
	.GLOBAL	BIOS_STUB_ADDRESS, REAL_MODE_STUB, REAL_MODE_STUB_END

#define STUB_SHIFT	- REAL_MODE_STUB + ADDR_BIOS16_STUB

	.SECTION .rodata
BIOS_STUB_ADDRESS:	.LONG	ADDR_BIOS16_STUB

	.SECTION .text

	.CODE32

/* SWITCH TO REAL MODE IS REALLY UGLY. SPECIAL GDT MUST BE CREATED JUST FOR THAT. */

REAL_MODE_STUB:

REAL_MODE_STUB_ENTRY = . STUB_SHIFT

	MOVW	%CS, STUB_CS_RET

	MOVL	%ESP, STUB_ESP_RET
	MOVW	%SS, STUB_SS_RET

	MOVW	%ES, STUB_ES_RET
	MOVW	%DS, STUB_DS_RET

	PUSHFL
	POPL	STUB_FLAGS_RET

	SGDTL	STUB_GDT_RET
	SIDTL	STUB_IDT_RET
	SLDTW	STUB_LDT_RET
	STRW	STUB_TR_RET

	CMPB	$0, STUB_SAVE_CR4
	JZ	1f
	MOVL	%CR4, %EAX
	MOVL	%EAX, STUB_CR4_RET
1:

	MOVL	%CR3, %ECX
	MOVL	%ECX, STUB_CR3_RET
	MOVL	%CR0, %EAX
	MOVL	%EAX, STUB_CR0_RET
	ANDL	$~CR0_PG, %EAX
	XORL	%EDX, %EDX
	MOVL	%ECX, %CR3	/* Pentium errata 60 */
	MOVL	%EAX, %CR0
	MOVL	%EDX, %CR3

	LIDTL	TRANSFER_IDTR
	LGDTL	TRANSFER_GDTR
	LJMPL	$8, $1f STUB_SHIFT

	.CODE16

1:	MOVW	$0x10, %AX
	MOVW	%AX, %SS
	MOVW	$ADDR_BIOS16_STUB, %SP
	MOVW	$0x20, %AX
	MOVW	%AX, %ES
	MOVW	%AX, %DS
	MOVW	%AX, %FS
	MOVW	%AX, %GS

	LIDTL	REAL_IDTR

	MOVL	%CR0, %EAX
	ANDL	$~CR0_PE, %EAX
	MOVL	%EAX, %CR0
	LJMPW	$0, $1f STUB_SHIFT

	.CODE16
1:
	MOVW	$0, %AX
	MOVW	%AX, %SS

	MOVW	$0, %AX
STUB_ES = . - 2 STUB_SHIFT
	MOVW	%AX, %ES
	MOVW	$0, %AX
STUB_DS = . - 2 STUB_SHIFT
	MOVW	%AX, %DS
	MOVW	$0, %AX
STUB_FS = . - 2 STUB_SHIFT
	MOVW	%AX, %FS
	MOVW	$0, %AX
STUB_GS = . - 2 STUB_SHIFT
	MOVW	%AX, %GS

	MOVB	$0, %AH
STUB_FLAGS = . - 1 STUB_SHIFT
	SAHF

	MOVL	$0, %EAX
STUB_EAX = . - 4 STUB_SHIFT
	MOVL	$0, %ECX
STUB_ECX = . - 4 STUB_SHIFT
	MOVL	$0, %EDX
STUB_EDX = . - 4 STUB_SHIFT
	MOVL	$0, %EBX
STUB_EBX = . - 4 STUB_SHIFT
	MOVL	$0, %EBP
STUB_EBP = . - 4 STUB_SHIFT
	MOVL	$0, %ESI
STUB_ESI = . - 4 STUB_SHIFT
	MOVL	$0, %EDI
STUB_EDI = . - 4 STUB_SHIFT

	INT	$0
STUB_INT = . - 1 STUB_SHIFT

ADDR32	MOVL	%EAX, %CS:STUB_EAX
	MOVW	%DS, %AX
ADDR32	MOVW	%AX, %CS:STUB_DS
	MOVW	%CS, %AX
	MOVW	%AX, %DS
ADDR32	MOVL	%ECX, STUB_ECX
ADDR32	MOVL	%EDX, STUB_EDX
ADDR32	MOVL	%EBX, STUB_EBX
ADDR32	MOVL	%EBP, STUB_EBP
ADDR32	MOVL	%ESI, STUB_ESI
ADDR32	MOVL	%EDI, STUB_EDI
	LAHF
ADDR32	MOVB	%AH, STUB_FLAGS
ADDR32	MOVW	%ES, STUB_ES
ADDR32	MOVW	%FS, STUB_FS
ADDR32	MOVW	%GS, STUB_GS

	CLI
ADDR32	LGDTL	STUB_GDT_RET
ADDR32	LIDTL	STUB_IDT_RET

	MOVL	$0, %EAX
STUB_CR3_RET = . - 4 STUB_SHIFT
	MOVL	%EAX, %CR3

ADDR32	CMPB	$0, STUB_SAVE_CR4
	JZ	1f
	MOVL	$0, %EAX
STUB_CR4_RET = . - 4 STUB_SHIFT
	MOVL	%EAX, %CR4
1:

	/*MOVL	%CR0, %EAX
	ORL	$CR0_PE, %EAX
	MOVL	%EAX, %CR0*/

	MOVL	$0, %EAX
STUB_CR0_RET = . - 4 STUB_SHIFT
	MOVL	%EAX, %CR0
	LJMPW	$0, $1f STUB_SHIFT
STUB_CS_RET = . - 2 STUB_SHIFT

	.CODE32

1:
	MOVW	$0, %AX
STUB_SS_RET = . - 2 STUB_SHIFT
	MOVW	%AX, %SS
	MOVL	$0, %ESP
STUB_ESP_RET = . - 4 STUB_SHIFT

	PUSHL	$0x80000000
STUB_FLAGS_RET = . - 4 STUB_SHIFT
	POPFL

	MOVW	$0, %AX
STUB_ES_RET = . - 2 STUB_SHIFT
	MOVW	%AX, %ES
	MOVW	$0, %AX
STUB_DS_RET = . - 2 STUB_SHIFT
	MOVW	%AX, %DS
	MOVW	$0, %AX
	MOVW	%AX, %FS
	MOVW	%AX, %GS

	LLDTW	STUB_LDT_RET

	/* RESET BUSY FLAG OF TSS */
	MOVZWL	STUB_TR_RET, %EAX
	ANDL	$~7, %EAX
	ADDL	STUB_GDT_RET + 2, %EAX
	ANDL	$~(1 << 9), 4(%EAX)

	LTRW	STUB_TR_RET

	RET

	.ALIGN	8, 0
STUB_GDT_RET = . STUB_SHIFT
	.SPACE	8
STUB_IDT_RET = . STUB_SHIFT
	.SPACE	8
STUB_LDT_RET = . STUB_SHIFT
	.SPACE	2
STUB_TR_RET = . STUB_SHIFT
	.SPACE	2
STUB_SAVE_CR4 = . STUB_SHIFT
	.SPACE	1

	.ALIGN	8, 0
REAL_IDTR = . STUB_SHIFT
	.WORD	0xFF03
	.LONG	0
	.WORD	0

	.ALIGN	8, 0
TRANSFER_GDT = . STUB_SHIFT
	.LONG	0, 0

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x9B
	.BYTE	0x00, 0x00

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x93
	.BYTE	0x00, 0x00

	.LONG	0, 0

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0xF3
	.BYTE	0x00, 0x00

TRANSFER_GDT_END = . STUB_SHIFT

	.ALIGN	8, 0
TRANSFER_GDTR = . STUB_SHIFT
	.WORD	TRANSFER_GDT_END - TRANSFER_GDT - 1
	.LONG	TRANSFER_GDT
	.WORD	0

/* I DON'T KNOW WHY WE NEED SPECIAL IDT WHEN INTERRUPTS ARE DISABLED,
   BUT INTEL MANUAL SAYS SO ... */

TRANSFER_IDTR = . STUB_SHIFT
	.WORD	0
	.LONG	0
	.WORD	0

REAL_MODE_STUB_END:

