#include <ARCH/LDT.H>
#include <ARCH/BARRIER.H>
#include <SPAD/LIBC.H>
#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <STDLIB.H>
#include <LIB/KERNEL/UASM.H>
#include <KERNEL/UDATA.H>
#include <KERNEL/SYSCALL.H>

/* These two defines are from linux/include/asm-i386/desc.h */

#define LDT_entry_a(info) \
	((((info)->base_addr & 0x0000ffff) << 16) | ((info)->limit & 0x0ffff))

#define LDT_entry_b(info) \
	(((info)->base_addr & 0xff000000) | \
	(((info)->base_addr & 0x00ff0000) >> 16) | \
	((info)->limit & 0xf0000) | \
	(((info)->read_exec_only ^ 1) << 9) | \
	((info)->contents << 10) | \
	(((info)->seg_not_present ^ 1) << 15) | \
	((info)->seg_32bit << 22) | \
	((info)->limit_in_pages << 23) | \
	((info)->useable << 20) | \
	0x7100)

int modify_ldt(int fn, void *ptr, unsigned long n)
{
	int spl;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL)))
		KERNEL$SUICIDE("modify_ldt AT SPL %08X", KERNEL$SPL);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_DEV);
	if (__likely(fn == 0x01) || __likely(fn == 0x11)) {
		__u32 a, b;
		unsigned en;
		if (__unlikely(n != sizeof(struct modify_ldt_ldt_s))) {
			einval:
			errno = EINVAL;
			LOWER_SPLX(spl);
			return -1;
		}
#define li	((struct modify_ldt_ldt_s *)ptr)
		en = li->entry_number;
		if (__unlikely(en >= LDT_ENTRIES)) goto einval;
		if (__unlikely(li->contents == 3) && __unlikely(!li->seg_not_present)) goto einval;
		a = LDT_entry_a(li);
		b = LDT_entry_b(li);
		if (en >= ldt_n) {
			unsigned new_n = en >= ldt_n ? en + 1 : ldt_n;
			struct ldt_entry *newldt = malloc(new_n * sizeof(struct ldt_entry)), *oldldt;
			if (__unlikely(!newldt)) {
				LOWER_SPLX(spl);
				return -1;
			}
			memcpy(newldt, ldt, ldt_n * sizeof(struct ldt_entry));
			memset(newldt + ldt_n, 0, (new_n - ldt_n) * sizeof(struct ldt_entry));
			newldt[en].a = a;
			newldt[en].b = b;
			__barrier();
			oldldt = ldt;
			ldt = newldt;
			__barrier();
			ldt_n = new_n;
			__barrier();
			free(oldldt);
		} else {
			SET_8(&ldt[en], a, b);
		}
		SYSCALL2(SYS_INVD_EXTD_PAGE, IOBMP_PAGES + (en >> (PG_SIZE_BITS - 3)));
		LOWER_SPLX(spl);
		return 0;
#undef li
	} else if (__likely(fn == 0x00)) {
		if (__unlikely(n > LDT_ENTRY_SIZE * LDT_ENTRIES)) n = LDT_ENTRY_SIZE * LDT_ENTRIES;
		if (n > ldt_n * sizeof(struct ldt_entry)) {
			memcpy(ptr, ldt, ldt_n * sizeof(struct ldt_entry));
			memset((char *)ptr + ldt_n * sizeof(struct ldt_entry), 0, (n - ldt_n * sizeof(struct ldt_entry)));
		} else {
			memcpy(ptr, ldt, n);
		}
		LOWER_SPLX(spl);
		return n;
	} else if (__likely(fn == 0x02)) {
		if (__unlikely(n > LDT_ENTRY_SIZE * LDT_ENTRIES)) n = LDT_ENTRY_SIZE * LDT_ENTRIES;
		memset(ptr, 0, n);
		LOWER_SPLX(spl);
		return n;
	} else {
		errno = ENOSYS;
		LOWER_SPLX(spl);
		return -1;
	}
}
