#include <ARCH/SETUP.H>
#include <SPAD/ERRNODEF.H>
#include <KERNEL/DEV_OFF.H>
#include <KERNEL/SYSDEF.H>
#include <KERNEL/UDATADEF.H>
#include <SPAD/SPLDEF.H>
#include <ARCH/ACDEF.H>

	.GLOBAL	KERNEL$PROC_KERNEL
KERNEL$PROC_KERNEL = -1

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$AWRITE
KERNEL$AWRITE:
	MOVL	$SYS_AWRITE | (KERNEL_CALL_AWRITE << 8), %ECX
	ORL	$0, OFF_AIORQ_progress(%EAX)	/* probe write access */
	JMP	do_io

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$AREAD
KERNEL$AREAD:
	MOVL	$SYS_AREAD | (KERNEL_CALL_AREAD << 8), %ECX
	ORL	$0, OFF_AIORQ_progress(%EAX)	/* probe write access */
	JMP	do_io

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$IOCTL
KERNEL$IOCTL:
	MOVL	$SYS_IOCTL | (KERNEL_CALL_IOCTL << 8), %ECX
	JMP	do_io

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WRITE
KERNEL$WRITE:
	MOVL	$SYS_WRITE | (KERNEL_CALL_WRITE << 8), %ECX
	JMP	do_sio

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$READ
KERNEL$READ:
	MOVL	$SYS_READ | (KERNEL_CALL_READ << 8), %ECX
do_sio:
	ORL	$0, OFF_SIORQ_progress(%EAX)	/* probe write access */
do_io:
	MOVZBL	%CH, %EDX
	MOVL	%EAX, OFF_IORQ_tmp1(%EAX)	/* random value, just test for write access, we can take COW fault here but not in kernel */
	MOVB	$0, %CH
	MOVL	%EDX, OFF_IORQ_tmp3(%EAX)
	MOVL	OFF_IORQ_status(%EAX), %EDX
	ANDL	$RQS_ACTION_MASK, %EDX
	CMPL	$RQS_PROCESSING, %EDX
	JNE	1f
	MOVL	$RQS_KERNELCANCELABLE, OFF_IORQ_status(%EAX)
2:	MOVL	%EAX, %EDX
	MOVL	%ECX, %EAX
	CALL	SYSCALL2
	JMP	KERNEL$PROCESS_PENDING_AST
	.SECTION .text.end
	.ALIGN	__CPU_BRANCH_ALIGN
1:	ORL	$0, OFF_IORQ_status(%EAX)	/* probe write access */
	CMPL	$RQS_WANTCANCEL, %EDX
	JNZ	2b
	MOVL	$-EINTR, OFF_IORQ_status(%EAX)
	JMP	*(%EAX)
	.PREVIOUS

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	INIT_THREAD_UNBLOCK
INIT_THREAD_UNBLOCK:
	MOVL	$(-2) << SPL_THREAD, %ECX /* needed for the kernel to read SPL */
	MOVL	KUPLACE(UDATA_STRUCT + OFF_UDATA_init_thread), %EDX
	MOVL	%EDX, 8(%EAX)
	JMP	__UNBLOCK

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$MTX_LOCK_TEST
KERNEL$MTX_LOCK_TEST:
	MOVL	%EAX, %EDX
	MOVL	$1, %ECX
	XORL	%EAX, %EAX
	CMPXCHGL %ECX, (%EDX)
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$MTX_UNLOCK_TEST
KERNEL$MTX_UNLOCK_TEST:
#if __DEBUG >= 1
	CMPL	$0, (%EAX)
	JZ	2f
#endif
	/* !!! FIXME: FEATURES convert to dynamic fixup */
	PUSHL	%EAX
	MOVL	$FEATURE_CMPXCHG8B, %EAX
	CALL	KERNEL$FEATURE_TEST
	TESTL	%EAX, %EAX
	POPL	%EAX
	PUSHL	%EDI
	LEAL	4(%EAX), %EDX
	MOVL	%EAX, %EDI
	JZ	1f
	MOVL	(%EAX), %EAX
	PUSHL	%EBX
	XORL	%EBX, %EBX
	MOVL	%EDX, %ECX
	CMPXCHG8B (%EDI)
	SETNZ	%AL
	POPL	%EBX
	MOVZBL	%AL, %EAX
1:	POPL	%EDI
	RET

#if __DEBUG >= 1
2:	PUSHL	$7f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
7:	.STRING	"KERNEL$MTX_UNLOCK_TEST: MUTEX NOT LOCKED"
	.PREVIOUS
#endif

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$BIO
KERNEL$BIO:
	JMP	KERNEL$BIO_EMU

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$PKTIO
KERNEL$PKTIO:
	MOVL	$-ENOOP, OFF_IORQ_status(%EAX)
	JMP	*(%EAX)

/* pthread set_timer function depends on JIFFIES implementation in userspace.
   If you change this, change also set_timer. */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$GET_JIFFIES
KERNEL$GET_JIFFIES:
1:
	MOVL	USER_JIFFIES, %EAX
	MOVL	USER_JIFFIES + 4, %EDX
	CMPL	USER_JIFFIES, %EAX
	JNZ,pn	1b
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$GET_JIFFIES_LO
KERNEL$GET_JIFFIES_LO:
	MOVL	USER_JIFFIES, %EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$READ_MSR
KERNEL$READ_MSR:
	MOVL	$-EUSER, %EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WRITE_MSR
KERNEL$WRITE_MSR:
	MOVL	$-EUSER, %EAX
	RET

	.GLOBAL	XCPU_AST
XCPU_AST:
	PUSHL	$1f
	PUSHL	(%EAX)
	JMP	KERNEL$SUICIDE
	
	.SECTION .rodata
1:	.STRING	"XCPU_AST CALLED"
	.ALIGN	4
	.GLOBAL	KERNEL$XCPU_AST
KERNEL$XCPU_AST:
	.LONG	XCPU_AST

	.SECTION .bss
	.ALIGN	4
	.GLOBAL	INTR_COUNT
INTR_COUNT:
	.LONG	0

	.ALIGN	4
	.GLOBAL	KERNEL$ZERO_BANK
KERNEL$ZERO_BANK:
	.LONG	0

