#include <ARCH/SETUP.H>
#include <SPAD/SLAB.H>
#include <KERNEL/SLAB.H>

#define EXEC_STACK_SIZE		4096

#if !__DEBUG_LDT
#define zldt	(ldt = NULL)
#else
#define zldt	(ldt = STDHEAP_TOP)
#endif

#define ARCH_PREPARE_EXEC						\
do {									\
	unsigned tmp1, tmp2;						\
	__asm__ volatile ("						\n\
		MOVL	%%FS, %0					\n\
		MOVL	%%GS, %1					\n\
		ORL	%0, %1						\n\
		JNZ	1f						\n\
	2:								\n\
		.SECTION .text.end					\n\
	1:	XORL	%0, %0						\n\
		MOVL	%0, %%FS					\n\
		MOVL	%0, %%GS					\n\
		JMP	2b						\n\
		.PREVIOUS						\n\
	":"=r"(tmp1),"=r"(tmp2)::"cc");					\
	__barrier();							\
	ldt_n = 0;							\
	__barrier();							\
	zldt;								\
	__asm__ volatile ("MOVL %0, %%EAX; MOVL %1, %%ESP; JMP CONT_EXEC"::"g"(data),"g"(KERNEL$STACKPAGE):"ax","memory"); 				\
} while (0);

#define ARCH_SET_EXEC_UDATA						\
do {									\
	ORIG_ESP = (void *)KERNEL$STACKPAGE;				\
} while (0)
