#include <SPAD/LIBC.H>
#include <SPAD/DL.H>
#include <KERNEL/UDATADEF.H>
#include <STRING.H>

#define MAX_FUNCTIONS	100

void KERNEL$STACK_DUMP(void)
{
	int x = 0;
	void **esp;
	const char *s;
	unsigned long off;
	/*{
		unsigned char *p;
		for (p = UPLACE(UDATA_COPROCESSOR); p < UPLACE(UDATA_AST_QUEUES); p++) {
			__debug_printf("%02x ", *p);
		}
		__debug_printf("\n");
	}*/
	__asm__ ("MOVL %%ESP, %0":"=r"(esp));
	while ((unsigned long)esp < *(unsigned long *)UPLACE(UDATA_ORIG_ESP)) {
		if ((s = KERNEL$DL_GET_SYMBOL_NAME(*esp, &off, 1))) {
			if (__likely(off != 0)) {
				__critical_printf("%s%s+%lX", x ? ", " : "", s, off);
				if (__unlikely(++x >= MAX_FUNCTIONS)) break;
				if (__unlikely(strstr(s, "START_THREAD") != NULL)) break;
			}
		}
		esp++;
	}
	__critical_printf("\n\r");	/* we might be in raw tty mode */
}

