#include <ARCH/AC.H>
#include <ARCH/CPU.H>
#include <ARCH/IO.H>
#include <ARCH/TIME.H>
#include <SPAD/LIBC.H>
#include <STRING.H>
#include <STDLIB.H>

#include <ARCH/IPCHECKS.H>
#include "IPCHECKA.H"

/*#define DEBUG_IP_CHECKSUMS*/

#define ITERATIONS	4	/* Pentium MMX has still some relicts in 3rd iteration */

extern __u8 CHECKSUM_AMD[];
extern __u8 CHECKSUM_AMD_END[];
extern __u8 CHECKSUM_AMD_FIXUP_PLUS[];

extern __u8 CHECKSUM_INTEL[];
extern __u8 CHECKSUM_INTEL_END[];
extern __u8 CHECKSUM_INTEL_FIXUP_PLUS[];

extern __u8 CHECKSUM_SSE[];
extern __u8 CHECKSUM_SSE_END[];
extern __u8 CHECKSUM_SSE_FIXUP_MINUS[];

extern __u8 CHECKSUM_COPY_AMD[];
extern __u8 CHECKSUM_COPY_AMD_END[];
extern __u8 CHECKSUM_COPY_AMD_FIXUP_PLUS[];

extern __u8 CHECKSUM_COPY_INTEL[];
extern __u8 CHECKSUM_COPY_INTEL_END[];
extern __u8 CHECKSUM_COPY_INTEL_FIXUP_PLUS[];

extern __u8 CHECKSUM_COPY_SSE[];
extern __u8 CHECKSUM_COPY_SSE_END[];
extern __u8 CHECKSUM_COPY_SSE_FIXUP_MINUS[];
extern __u8 CHECKSUM_COPY_SSE_FIXUP_MINUS_2[];

extern __u8 CHECKSUM_COPY_MOVSD[];
extern __u8 CHECKSUM_COPY_MOVSD_END[];
extern __u8 CHECKSUM_COPY_MOVSD_FIXUP_MINUS[];
extern __u8 CHECKSUM_COPY_MOVSD_FIXUP_MINUS_2[];

typedef struct {
	__u8 *start;
	__u8 *end;
	__u8 *fixup_plus;
	__u8 *fixup_minus;
	__u8 *fixup_minus_2;
	__u32 feature;
} CHECKSUM;

const CHECKSUM checksums[] = {
	CHECKSUM_AMD, CHECKSUM_AMD_END, CHECKSUM_AMD_FIXUP_PLUS, NULL, NULL, 0,
	CHECKSUM_INTEL, CHECKSUM_INTEL_END, CHECKSUM_INTEL_FIXUP_PLUS, NULL, NULL, -1,
#ifndef __NO_SSE
	CHECKSUM_SSE, CHECKSUM_SSE_END, NULL, CHECKSUM_SSE_FIXUP_MINUS, NULL, FEATURE_SSE2,
#endif
};

const CHECKSUM copy_checksums[] = {
	CHECKSUM_COPY_AMD, CHECKSUM_COPY_AMD_END, CHECKSUM_COPY_AMD_FIXUP_PLUS, NULL, NULL, 0,
	CHECKSUM_COPY_INTEL, CHECKSUM_COPY_INTEL_END, CHECKSUM_COPY_INTEL_FIXUP_PLUS, NULL, NULL, 0,
#ifndef __NO_SSE
	CHECKSUM_COPY_SSE, CHECKSUM_COPY_SSE_END, NULL, CHECKSUM_COPY_SSE_FIXUP_MINUS, CHECKSUM_COPY_SSE_FIXUP_MINUS_2, FEATURE_SSE2,
#endif
	CHECKSUM_COPY_MOVSD, CHECKSUM_COPY_MOVSD_END, NULL, CHECKSUM_COPY_MOVSD_FIXUP_MINUS, CHECKSUM_COPY_MOVSD_FIXUP_MINUS_2, 0,
};

static int SELECT_CHECKSUM(void *target, const CHECKSUM *c)
{
	__u8 *p = c->start;
	unsigned long l = c->end - p;
	if (__unlikely(l > CHECKSUM_CODE_LEN)) KERNEL$SUICIDE("SELECT_CHECKSUM: CHECKSUM TOO LARGE (%ld > %d)", l, CHECKSUM_CODE_LEN);
	if (c->feature != (__u32)-1 && !KERNEL$FEATURE_TEST(c->feature)) return -1;
	memcpy(target, p, l);
	memset((__u8 *)target + l, 0, CHECKSUM_CODE_LEN - l);
	if (c->fixup_plus) {
		*(__u32 *)(c->fixup_plus - c->start + (__u8 *)target - 4) += (__u8 *)target - c->start;
	}
	if (c->fixup_minus) {
		*(__u32 *)(c->fixup_minus - c->start + (__u8 *)target - 4) -= (__u8 *)target - c->start;
	}
	if (c->fixup_minus_2) {
		*(__u32 *)(c->fixup_minus_2 - c->start + (__u8 *)target - 4) -= (__u8 *)target - c->start;
	}
	return 0;
}

extern __u8 TESTPKT[TEST_PACKET_LEN];
extern __u8 TESTPKTDEST[TEST_PACKET_LEN];

void CHECKSUM_INIT(void);

void CHECKSUM_INIT(void)
{
	__u64 max;
	unsigned i, j, maxi;
	checksum_t ct = 0 /* no warning */;
	TESTPKT[0] = TESTPKT[1] = 1;	/* test it on Fibonacci sequence */
	for (i = 2; i < TEST_PACKET_LEN; i++) TESTPKT[i] = TESTPKT[i - 2] + TESTPKT[i - 1];
	max = -1;
	maxi = 0;
	for (i = 0; i < sizeof(checksums) / sizeof(CHECKSUM); i++) {
		__u64 a;
		checksum_t ch;
		if (__unlikely(SELECT_CHECKSUM(NET$IP_CHECKSUM, &checksums[i]))) continue;
		if (__unlikely(!FEATURE_TEST(FEATURE_TSC))) {
			unsigned k;
			int spl = KERNEL$SPL;
			RAISE_SPL(SPL_ALMOST_TOP);
			for (j = 0; j < ITERATIONS; j++)
				NET$IP_CHECKSUM(0, TESTPKT, sizeof TESTPKT);
			j = KERNEL$GET_JIFFIES_LO();
			while (KERNEL$GET_JIFFIES_LO() == j)
				NET$IP_CHECKSUM(0, TESTPKT, sizeof TESTPKT);
			k = 0;
			j = KERNEL$GET_JIFFIES_LO();
			while (KERNEL$GET_JIFFIES_LO() == j) {
				NET$IP_CHECKSUM(0, TESTPKT, sizeof TESTPKT);
				k++;
			}
			LOWER_SPLX(spl);
			ch = NET$IP_CHECKSUM(0, TESTPKT, sizeof TESTPKT);
			a = (__u64)-1 / k;
		} else {
			KERNEL$DI();
			for (j = 0; j < ITERATIONS; j++) {
				a = RDTSC();
				ch = NET$IP_CHECKSUM(0, TESTPKT, sizeof TESTPKT);
				a = RDTSC() - a;
			}
			KERNEL$EI();
		}
#ifdef DEBUG_IP_CHECKSUMS
		__debug_printf("chs: %d: %Ld\n", i, a);
#endif
		if (!i) ct = IP_CHECKSUM_FOLD(ch);
		else if (__unlikely(ct != IP_CHECKSUM_FOLD(ch)))
#ifndef DEBUG_IP_CHECKSUMS
			KERNEL$SUICIDE
#else
			__debug_printf
#endif
			("CHECKSUM_INIT: CHECKSUM %u IS BROKEN (%04X != %04X)", i, ct, IP_CHECKSUM_FOLD(ch));
		if (a < max) max = a, maxi = i;
	}
	if (__unlikely(SELECT_CHECKSUM(NET$IP_CHECKSUM, &checksums[maxi])))
		KERNEL$SUICIDE("CHECKSUM_INIT: CAN'T SELECT CHECKSUM %u", maxi);
#ifdef DEBUG_IP_CHECKSUMS
	__debug_printf("selected: %u\n", maxi);
#endif
	max = -1;
	maxi = 0;
	for (i = 0; i < sizeof(copy_checksums) / sizeof(CHECKSUM); i++) {
		__u64 a;
		checksum_t ch;
		if (__unlikely(SELECT_CHECKSUM(NET$IP_CHECKSUM_COPY, &copy_checksums[i]))) continue;
		memset(TESTPKTDEST, 0, TEST_PACKET_LEN);
		if (__unlikely(!FEATURE_TEST(FEATURE_TSC))) {
			unsigned k;
			int spl = KERNEL$SPL;
			RAISE_SPL(SPL_ALMOST_TOP);
			for (j = 0; j < ITERATIONS; j++)
				NET$IP_CHECKSUM_COPY(TESTPKTDEST, TESTPKT, sizeof TESTPKT);
			j = KERNEL$GET_JIFFIES_LO();
			while (KERNEL$GET_JIFFIES_LO() == j)
				NET$IP_CHECKSUM_COPY(TESTPKTDEST, TESTPKT, sizeof TESTPKT);
			k = 0;
			j = KERNEL$GET_JIFFIES_LO();
			while (KERNEL$GET_JIFFIES_LO() == j) {
				NET$IP_CHECKSUM_COPY(TESTPKTDEST, TESTPKT, sizeof TESTPKT);
				k++;
			}
			LOWER_SPLX(spl);
			ch = NET$IP_CHECKSUM_COPY(TESTPKTDEST, TESTPKT, sizeof TESTPKT);
			a = (__u64)-1 / k;
		} else {
			KERNEL$DI();
			for (j = 0; j < ITERATIONS; j++) {
				a = RDTSC();
				ch = NET$IP_CHECKSUM_COPY(TESTPKTDEST, TESTPKT, sizeof TESTPKT);
				a = RDTSC() - a;
			}
			KERNEL$EI();
		}
#ifdef DEBUG_IP_CHECKSUMS
		__debug_printf("cch: %d: %Ld\n", i, a);
#endif
		if (__unlikely(ct != IP_CHECKSUM_FOLD(ch)))
#ifndef DEBUG_IP_CHECKSUMS
			KERNEL$SUICIDE
#else
			__debug_printf
#endif
			("CHECKSUM_INIT: COPY CHECKSUM %u IS BROKEN (%04X != %04X)", i, ct, IP_CHECKSUM_FOLD(ch));
		if (__unlikely(memcmp(TESTPKT, TESTPKTDEST, TEST_PACKET_LEN)))
#ifndef DEBUG_IP_CHECKSUMS
			KERNEL$SUICIDE
#else
			__debug_printf
#endif
			("CHECKSUM_INIT: COPY CHECKSUM %u IS BROKEN (PACKET MISCOPIED)", i);
		if (a < max) max = a, maxi = i;
	}
	if (__unlikely(SELECT_CHECKSUM(NET$IP_CHECKSUM_COPY, &copy_checksums[maxi])))
		KERNEL$SUICIDE("CHECKSUM_INIT: CAN'T SELECT COPY CHECKSUM %u", maxi);
#ifdef DEBUG_IP_CHECKSUMS
	__debug_printf("selected: %u\n", maxi);
#endif
}

